/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.duracloud.account.db.model.EmailTemplate;
import org.duracloud.account.db.repo.EmailTemplateRepo;
import org.duracloud.account.db.util.EmailTemplateService;
import org.duracloud.account.db.util.util.EmailTemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="emailTemplateService")
public class EmailTemplateServiceImpl
implements EmailTemplateService {
    private Logger log = LoggerFactory.getLogger(EmailTemplateServiceImpl.class);
    @Autowired
    private EmailTemplateRepo repo;

    @PostConstruct
    public void init() {
        this.log.info("Initializing email templates...");
        if (this.list().size() == EmailTemplate.Templates.values().length) {
            this.log.info("Templates initialized.");
        } else {
            Arrays.asList(EmailTemplate.Templates.values()).stream().forEach(t -> {
                EmailTemplate emailTemplate = this.repo.findByTemplate((EmailTemplate.Templates)((Object)t));
                if (emailTemplate == null) {
                    this.repo.save(EmailTemplateUtil.loadDefault(t));
                }
            });
        }
    }

    @Override
    public EmailTemplate getTemplate(EmailTemplate.Templates template) {
        return this.repo.findByTemplate(template);
    }

    @Override
    public EmailTemplate getTemplate(Long templateId) {
        return (EmailTemplate)this.repo.findOne(templateId);
    }

    @Override
    public List<EmailTemplate> list() {
        return this.repo.findAll();
    }

    @Override
    public EmailTemplate update(Long templateId, String subject, String body) {
        EmailTemplate emailTemplate = this.getTemplate(templateId);
        emailTemplate.setSubject(subject);
        emailTemplate.setBody(body);
        emailTemplate.setModified(new Date());
        return this.repo.save(emailTemplate);
    }
}

