/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.protocol.HttpContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AsyncClientHttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsAsyncClientHttpRequest;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.Assert;

public class HttpComponentsAsyncClientHttpRequestFactory
extends HttpComponentsClientHttpRequestFactory
implements AsyncClientHttpRequestFactory,
InitializingBean {
    private HttpAsyncClient asyncClient;

    public HttpComponentsAsyncClientHttpRequestFactory() {
        this.asyncClient = HttpAsyncClients.createSystem();
    }

    public HttpComponentsAsyncClientHttpRequestFactory(HttpAsyncClient asyncClient) {
        this.setAsyncClient(asyncClient);
    }

    public HttpComponentsAsyncClientHttpRequestFactory(CloseableHttpAsyncClient asyncClient) {
        this.setAsyncClient((HttpAsyncClient)asyncClient);
    }

    public HttpComponentsAsyncClientHttpRequestFactory(HttpClient httpClient, HttpAsyncClient asyncClient) {
        super(httpClient);
        this.setAsyncClient(asyncClient);
    }

    public HttpComponentsAsyncClientHttpRequestFactory(CloseableHttpClient httpClient, CloseableHttpAsyncClient asyncClient) {
        super(httpClient);
        this.setAsyncClient((HttpAsyncClient)asyncClient);
    }

    public void setAsyncClient(HttpAsyncClient asyncClient) {
        Assert.notNull(asyncClient, "HttpAsyncClient must not be null");
        this.asyncClient = asyncClient;
    }

    public HttpAsyncClient getAsyncClient() {
        return this.asyncClient;
    }

    @Deprecated
    public void setHttpAsyncClient(CloseableHttpAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    @Deprecated
    public CloseableHttpAsyncClient getHttpAsyncClient() {
        Assert.state(this.asyncClient == null || this.asyncClient instanceof CloseableHttpAsyncClient, "No CloseableHttpAsyncClient - use getAsyncClient() instead");
        return (CloseableHttpAsyncClient)this.asyncClient;
    }

    @Override
    public void afterPropertiesSet() {
        this.startAsyncClient();
    }

    private void startAsyncClient() {
        CloseableHttpAsyncClient closeableAsyncClient;
        HttpAsyncClient asyncClient = this.getAsyncClient();
        if (asyncClient instanceof CloseableHttpAsyncClient && !(closeableAsyncClient = (CloseableHttpAsyncClient)asyncClient).isRunning()) {
            closeableAsyncClient.start();
        }
    }

    @Override
    public AsyncClientHttpRequest createAsyncRequest(URI uri, HttpMethod httpMethod) throws IOException {
        this.startAsyncClient();
        HttpUriRequest httpRequest = this.createHttpUriRequest(httpMethod, uri);
        this.postProcessHttpRequest(httpRequest);
        HttpContext context = this.createHttpContext(httpMethod, uri);
        if (context == null) {
            context = HttpClientContext.create();
        }
        if (context.getAttribute("http.request-config") == null) {
            RequestConfig config = null;
            if (httpRequest instanceof Configurable) {
                config = ((Configurable)((Object)httpRequest)).getConfig();
            }
            if (config == null) {
                config = this.createRequestConfig(this.getAsyncClient());
            }
            if (config != null) {
                context.setAttribute("http.request-config", config);
            }
        }
        return new HttpComponentsAsyncClientHttpRequest(this.getAsyncClient(), httpRequest, context);
    }

    @Override
    public void destroy() throws Exception {
        try {
            super.destroy();
        }
        finally {
            HttpAsyncClient asyncClient = this.getAsyncClient();
            if (asyncClient instanceof Closeable) {
                ((Closeable)asyncClient).close();
            }
        }
    }
}

