/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sns.AmazonSNSAsync;
import com.amazonaws.services.sns.AmazonSNSAsyncClientBuilder;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.model.AddPermissionRequest;
import com.amazonaws.services.sns.model.AddPermissionResult;
import com.amazonaws.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest;
import com.amazonaws.services.sns.model.CheckIfPhoneNumberIsOptedOutResult;
import com.amazonaws.services.sns.model.ConfirmSubscriptionRequest;
import com.amazonaws.services.sns.model.ConfirmSubscriptionResult;
import com.amazonaws.services.sns.model.CreatePlatformApplicationRequest;
import com.amazonaws.services.sns.model.CreatePlatformApplicationResult;
import com.amazonaws.services.sns.model.CreatePlatformEndpointRequest;
import com.amazonaws.services.sns.model.CreatePlatformEndpointResult;
import com.amazonaws.services.sns.model.CreateSMSSandboxPhoneNumberRequest;
import com.amazonaws.services.sns.model.CreateSMSSandboxPhoneNumberResult;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.services.sns.model.CreateTopicResult;
import com.amazonaws.services.sns.model.DeleteEndpointRequest;
import com.amazonaws.services.sns.model.DeleteEndpointResult;
import com.amazonaws.services.sns.model.DeletePlatformApplicationRequest;
import com.amazonaws.services.sns.model.DeletePlatformApplicationResult;
import com.amazonaws.services.sns.model.DeleteSMSSandboxPhoneNumberRequest;
import com.amazonaws.services.sns.model.DeleteSMSSandboxPhoneNumberResult;
import com.amazonaws.services.sns.model.DeleteTopicRequest;
import com.amazonaws.services.sns.model.DeleteTopicResult;
import com.amazonaws.services.sns.model.GetDataProtectionPolicyRequest;
import com.amazonaws.services.sns.model.GetDataProtectionPolicyResult;
import com.amazonaws.services.sns.model.GetEndpointAttributesRequest;
import com.amazonaws.services.sns.model.GetEndpointAttributesResult;
import com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest;
import com.amazonaws.services.sns.model.GetPlatformApplicationAttributesResult;
import com.amazonaws.services.sns.model.GetSMSAttributesRequest;
import com.amazonaws.services.sns.model.GetSMSAttributesResult;
import com.amazonaws.services.sns.model.GetSMSSandboxAccountStatusRequest;
import com.amazonaws.services.sns.model.GetSMSSandboxAccountStatusResult;
import com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest;
import com.amazonaws.services.sns.model.GetSubscriptionAttributesResult;
import com.amazonaws.services.sns.model.GetTopicAttributesRequest;
import com.amazonaws.services.sns.model.GetTopicAttributesResult;
import com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest;
import com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationResult;
import com.amazonaws.services.sns.model.ListOriginationNumbersRequest;
import com.amazonaws.services.sns.model.ListOriginationNumbersResult;
import com.amazonaws.services.sns.model.ListPhoneNumbersOptedOutRequest;
import com.amazonaws.services.sns.model.ListPhoneNumbersOptedOutResult;
import com.amazonaws.services.sns.model.ListPlatformApplicationsRequest;
import com.amazonaws.services.sns.model.ListPlatformApplicationsResult;
import com.amazonaws.services.sns.model.ListSMSSandboxPhoneNumbersRequest;
import com.amazonaws.services.sns.model.ListSMSSandboxPhoneNumbersResult;
import com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest;
import com.amazonaws.services.sns.model.ListSubscriptionsByTopicResult;
import com.amazonaws.services.sns.model.ListSubscriptionsRequest;
import com.amazonaws.services.sns.model.ListSubscriptionsResult;
import com.amazonaws.services.sns.model.ListTagsForResourceRequest;
import com.amazonaws.services.sns.model.ListTagsForResourceResult;
import com.amazonaws.services.sns.model.ListTopicsRequest;
import com.amazonaws.services.sns.model.ListTopicsResult;
import com.amazonaws.services.sns.model.OptInPhoneNumberRequest;
import com.amazonaws.services.sns.model.OptInPhoneNumberResult;
import com.amazonaws.services.sns.model.PublishBatchRequest;
import com.amazonaws.services.sns.model.PublishBatchResult;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import com.amazonaws.services.sns.model.PutDataProtectionPolicyRequest;
import com.amazonaws.services.sns.model.PutDataProtectionPolicyResult;
import com.amazonaws.services.sns.model.RemovePermissionRequest;
import com.amazonaws.services.sns.model.RemovePermissionResult;
import com.amazonaws.services.sns.model.SetEndpointAttributesRequest;
import com.amazonaws.services.sns.model.SetEndpointAttributesResult;
import com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest;
import com.amazonaws.services.sns.model.SetPlatformApplicationAttributesResult;
import com.amazonaws.services.sns.model.SetSMSAttributesRequest;
import com.amazonaws.services.sns.model.SetSMSAttributesResult;
import com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest;
import com.amazonaws.services.sns.model.SetSubscriptionAttributesResult;
import com.amazonaws.services.sns.model.SetTopicAttributesRequest;
import com.amazonaws.services.sns.model.SetTopicAttributesResult;
import com.amazonaws.services.sns.model.SubscribeRequest;
import com.amazonaws.services.sns.model.SubscribeResult;
import com.amazonaws.services.sns.model.TagResourceRequest;
import com.amazonaws.services.sns.model.TagResourceResult;
import com.amazonaws.services.sns.model.UnsubscribeRequest;
import com.amazonaws.services.sns.model.UnsubscribeResult;
import com.amazonaws.services.sns.model.UntagResourceRequest;
import com.amazonaws.services.sns.model.UntagResourceResult;
import com.amazonaws.services.sns.model.VerifySMSSandboxPhoneNumberRequest;
import com.amazonaws.services.sns.model.VerifySMSSandboxPhoneNumberResult;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonSNSAsyncClient
extends AmazonSNSClient
implements AmazonSNSAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonSNSAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonSNSAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonSNSAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonSNSAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonSNSAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonSNSAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonSNSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonSNSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonSNSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonSNSAsyncClientBuilder asyncBuilder() {
        return AmazonSNSAsyncClientBuilder.standard();
    }

    AmazonSNSAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonSNSAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super(asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(AddPermissionRequest request) {
        return this.addPermissionAsync(request, null);
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(AddPermissionRequest request, final AsyncHandler<AddPermissionRequest, AddPermissionResult> asyncHandler) {
        final AddPermissionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddPermissionResult>(){

            @Override
            public AddPermissionResult call() throws Exception {
                AddPermissionResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeAddPermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(String topicArn, String label, List<String> aWSAccountIds, List<String> actionNames) {
        return this.addPermissionAsync(new AddPermissionRequest().withTopicArn(topicArn).withLabel(label).withAWSAccountIds(aWSAccountIds).withActionNames(actionNames));
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(String topicArn, String label, List<String> aWSAccountIds, List<String> actionNames, AsyncHandler<AddPermissionRequest, AddPermissionResult> asyncHandler) {
        return this.addPermissionAsync(new AddPermissionRequest().withTopicArn(topicArn).withLabel(label).withAWSAccountIds(aWSAccountIds).withActionNames(actionNames), asyncHandler);
    }

    @Override
    public Future<CheckIfPhoneNumberIsOptedOutResult> checkIfPhoneNumberIsOptedOutAsync(CheckIfPhoneNumberIsOptedOutRequest request) {
        return this.checkIfPhoneNumberIsOptedOutAsync(request, null);
    }

    @Override
    public Future<CheckIfPhoneNumberIsOptedOutResult> checkIfPhoneNumberIsOptedOutAsync(CheckIfPhoneNumberIsOptedOutRequest request, final AsyncHandler<CheckIfPhoneNumberIsOptedOutRequest, CheckIfPhoneNumberIsOptedOutResult> asyncHandler) {
        final CheckIfPhoneNumberIsOptedOutRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CheckIfPhoneNumberIsOptedOutResult>(){

            @Override
            public CheckIfPhoneNumberIsOptedOutResult call() throws Exception {
                CheckIfPhoneNumberIsOptedOutResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeCheckIfPhoneNumberIsOptedOut(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ConfirmSubscriptionResult> confirmSubscriptionAsync(ConfirmSubscriptionRequest request) {
        return this.confirmSubscriptionAsync(request, null);
    }

    @Override
    public Future<ConfirmSubscriptionResult> confirmSubscriptionAsync(ConfirmSubscriptionRequest request, final AsyncHandler<ConfirmSubscriptionRequest, ConfirmSubscriptionResult> asyncHandler) {
        final ConfirmSubscriptionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ConfirmSubscriptionResult>(){

            @Override
            public ConfirmSubscriptionResult call() throws Exception {
                ConfirmSubscriptionResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeConfirmSubscription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ConfirmSubscriptionResult> confirmSubscriptionAsync(String topicArn, String token, String authenticateOnUnsubscribe) {
        return this.confirmSubscriptionAsync(new ConfirmSubscriptionRequest().withTopicArn(topicArn).withToken(token).withAuthenticateOnUnsubscribe(authenticateOnUnsubscribe));
    }

    @Override
    public Future<ConfirmSubscriptionResult> confirmSubscriptionAsync(String topicArn, String token, String authenticateOnUnsubscribe, AsyncHandler<ConfirmSubscriptionRequest, ConfirmSubscriptionResult> asyncHandler) {
        return this.confirmSubscriptionAsync(new ConfirmSubscriptionRequest().withTopicArn(topicArn).withToken(token).withAuthenticateOnUnsubscribe(authenticateOnUnsubscribe), asyncHandler);
    }

    @Override
    public Future<ConfirmSubscriptionResult> confirmSubscriptionAsync(String topicArn, String token) {
        return this.confirmSubscriptionAsync(new ConfirmSubscriptionRequest().withTopicArn(topicArn).withToken(token));
    }

    @Override
    public Future<ConfirmSubscriptionResult> confirmSubscriptionAsync(String topicArn, String token, AsyncHandler<ConfirmSubscriptionRequest, ConfirmSubscriptionResult> asyncHandler) {
        return this.confirmSubscriptionAsync(new ConfirmSubscriptionRequest().withTopicArn(topicArn).withToken(token), asyncHandler);
    }

    @Override
    public Future<CreatePlatformApplicationResult> createPlatformApplicationAsync(CreatePlatformApplicationRequest request) {
        return this.createPlatformApplicationAsync(request, null);
    }

    @Override
    public Future<CreatePlatformApplicationResult> createPlatformApplicationAsync(CreatePlatformApplicationRequest request, final AsyncHandler<CreatePlatformApplicationRequest, CreatePlatformApplicationResult> asyncHandler) {
        final CreatePlatformApplicationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePlatformApplicationResult>(){

            @Override
            public CreatePlatformApplicationResult call() throws Exception {
                CreatePlatformApplicationResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeCreatePlatformApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePlatformEndpointResult> createPlatformEndpointAsync(CreatePlatformEndpointRequest request) {
        return this.createPlatformEndpointAsync(request, null);
    }

    @Override
    public Future<CreatePlatformEndpointResult> createPlatformEndpointAsync(CreatePlatformEndpointRequest request, final AsyncHandler<CreatePlatformEndpointRequest, CreatePlatformEndpointResult> asyncHandler) {
        final CreatePlatformEndpointRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePlatformEndpointResult>(){

            @Override
            public CreatePlatformEndpointResult call() throws Exception {
                CreatePlatformEndpointResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeCreatePlatformEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSMSSandboxPhoneNumberResult> createSMSSandboxPhoneNumberAsync(CreateSMSSandboxPhoneNumberRequest request) {
        return this.createSMSSandboxPhoneNumberAsync(request, null);
    }

    @Override
    public Future<CreateSMSSandboxPhoneNumberResult> createSMSSandboxPhoneNumberAsync(CreateSMSSandboxPhoneNumberRequest request, final AsyncHandler<CreateSMSSandboxPhoneNumberRequest, CreateSMSSandboxPhoneNumberResult> asyncHandler) {
        final CreateSMSSandboxPhoneNumberRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSMSSandboxPhoneNumberResult>(){

            @Override
            public CreateSMSSandboxPhoneNumberResult call() throws Exception {
                CreateSMSSandboxPhoneNumberResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeCreateSMSSandboxPhoneNumber(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTopicResult> createTopicAsync(CreateTopicRequest request) {
        return this.createTopicAsync(request, null);
    }

    @Override
    public Future<CreateTopicResult> createTopicAsync(CreateTopicRequest request, final AsyncHandler<CreateTopicRequest, CreateTopicResult> asyncHandler) {
        final CreateTopicRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTopicResult>(){

            @Override
            public CreateTopicResult call() throws Exception {
                CreateTopicResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeCreateTopic(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTopicResult> createTopicAsync(String name) {
        return this.createTopicAsync(new CreateTopicRequest().withName(name));
    }

    @Override
    public Future<CreateTopicResult> createTopicAsync(String name, AsyncHandler<CreateTopicRequest, CreateTopicResult> asyncHandler) {
        return this.createTopicAsync(new CreateTopicRequest().withName(name), asyncHandler);
    }

    @Override
    public Future<DeleteEndpointResult> deleteEndpointAsync(DeleteEndpointRequest request) {
        return this.deleteEndpointAsync(request, null);
    }

    @Override
    public Future<DeleteEndpointResult> deleteEndpointAsync(DeleteEndpointRequest request, final AsyncHandler<DeleteEndpointRequest, DeleteEndpointResult> asyncHandler) {
        final DeleteEndpointRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEndpointResult>(){

            @Override
            public DeleteEndpointResult call() throws Exception {
                DeleteEndpointResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeDeleteEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePlatformApplicationResult> deletePlatformApplicationAsync(DeletePlatformApplicationRequest request) {
        return this.deletePlatformApplicationAsync(request, null);
    }

    @Override
    public Future<DeletePlatformApplicationResult> deletePlatformApplicationAsync(DeletePlatformApplicationRequest request, final AsyncHandler<DeletePlatformApplicationRequest, DeletePlatformApplicationResult> asyncHandler) {
        final DeletePlatformApplicationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePlatformApplicationResult>(){

            @Override
            public DeletePlatformApplicationResult call() throws Exception {
                DeletePlatformApplicationResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeDeletePlatformApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSMSSandboxPhoneNumberResult> deleteSMSSandboxPhoneNumberAsync(DeleteSMSSandboxPhoneNumberRequest request) {
        return this.deleteSMSSandboxPhoneNumberAsync(request, null);
    }

    @Override
    public Future<DeleteSMSSandboxPhoneNumberResult> deleteSMSSandboxPhoneNumberAsync(DeleteSMSSandboxPhoneNumberRequest request, final AsyncHandler<DeleteSMSSandboxPhoneNumberRequest, DeleteSMSSandboxPhoneNumberResult> asyncHandler) {
        final DeleteSMSSandboxPhoneNumberRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSMSSandboxPhoneNumberResult>(){

            @Override
            public DeleteSMSSandboxPhoneNumberResult call() throws Exception {
                DeleteSMSSandboxPhoneNumberResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeDeleteSMSSandboxPhoneNumber(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTopicResult> deleteTopicAsync(DeleteTopicRequest request) {
        return this.deleteTopicAsync(request, null);
    }

    @Override
    public Future<DeleteTopicResult> deleteTopicAsync(DeleteTopicRequest request, final AsyncHandler<DeleteTopicRequest, DeleteTopicResult> asyncHandler) {
        final DeleteTopicRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTopicResult>(){

            @Override
            public DeleteTopicResult call() throws Exception {
                DeleteTopicResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeDeleteTopic(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTopicResult> deleteTopicAsync(String topicArn) {
        return this.deleteTopicAsync(new DeleteTopicRequest().withTopicArn(topicArn));
    }

    @Override
    public Future<DeleteTopicResult> deleteTopicAsync(String topicArn, AsyncHandler<DeleteTopicRequest, DeleteTopicResult> asyncHandler) {
        return this.deleteTopicAsync(new DeleteTopicRequest().withTopicArn(topicArn), asyncHandler);
    }

    @Override
    public Future<GetDataProtectionPolicyResult> getDataProtectionPolicyAsync(GetDataProtectionPolicyRequest request) {
        return this.getDataProtectionPolicyAsync(request, null);
    }

    @Override
    public Future<GetDataProtectionPolicyResult> getDataProtectionPolicyAsync(GetDataProtectionPolicyRequest request, final AsyncHandler<GetDataProtectionPolicyRequest, GetDataProtectionPolicyResult> asyncHandler) {
        final GetDataProtectionPolicyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDataProtectionPolicyResult>(){

            @Override
            public GetDataProtectionPolicyResult call() throws Exception {
                GetDataProtectionPolicyResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeGetDataProtectionPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEndpointAttributesResult> getEndpointAttributesAsync(GetEndpointAttributesRequest request) {
        return this.getEndpointAttributesAsync(request, null);
    }

    @Override
    public Future<GetEndpointAttributesResult> getEndpointAttributesAsync(GetEndpointAttributesRequest request, final AsyncHandler<GetEndpointAttributesRequest, GetEndpointAttributesResult> asyncHandler) {
        final GetEndpointAttributesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEndpointAttributesResult>(){

            @Override
            public GetEndpointAttributesResult call() throws Exception {
                GetEndpointAttributesResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeGetEndpointAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPlatformApplicationAttributesResult> getPlatformApplicationAttributesAsync(GetPlatformApplicationAttributesRequest request) {
        return this.getPlatformApplicationAttributesAsync(request, null);
    }

    @Override
    public Future<GetPlatformApplicationAttributesResult> getPlatformApplicationAttributesAsync(GetPlatformApplicationAttributesRequest request, final AsyncHandler<GetPlatformApplicationAttributesRequest, GetPlatformApplicationAttributesResult> asyncHandler) {
        final GetPlatformApplicationAttributesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPlatformApplicationAttributesResult>(){

            @Override
            public GetPlatformApplicationAttributesResult call() throws Exception {
                GetPlatformApplicationAttributesResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeGetPlatformApplicationAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSMSAttributesResult> getSMSAttributesAsync(GetSMSAttributesRequest request) {
        return this.getSMSAttributesAsync(request, null);
    }

    @Override
    public Future<GetSMSAttributesResult> getSMSAttributesAsync(GetSMSAttributesRequest request, final AsyncHandler<GetSMSAttributesRequest, GetSMSAttributesResult> asyncHandler) {
        final GetSMSAttributesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSMSAttributesResult>(){

            @Override
            public GetSMSAttributesResult call() throws Exception {
                GetSMSAttributesResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeGetSMSAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSMSSandboxAccountStatusResult> getSMSSandboxAccountStatusAsync(GetSMSSandboxAccountStatusRequest request) {
        return this.getSMSSandboxAccountStatusAsync(request, null);
    }

    @Override
    public Future<GetSMSSandboxAccountStatusResult> getSMSSandboxAccountStatusAsync(GetSMSSandboxAccountStatusRequest request, final AsyncHandler<GetSMSSandboxAccountStatusRequest, GetSMSSandboxAccountStatusResult> asyncHandler) {
        final GetSMSSandboxAccountStatusRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSMSSandboxAccountStatusResult>(){

            @Override
            public GetSMSSandboxAccountStatusResult call() throws Exception {
                GetSMSSandboxAccountStatusResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeGetSMSSandboxAccountStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSubscriptionAttributesResult> getSubscriptionAttributesAsync(GetSubscriptionAttributesRequest request) {
        return this.getSubscriptionAttributesAsync(request, null);
    }

    @Override
    public Future<GetSubscriptionAttributesResult> getSubscriptionAttributesAsync(GetSubscriptionAttributesRequest request, final AsyncHandler<GetSubscriptionAttributesRequest, GetSubscriptionAttributesResult> asyncHandler) {
        final GetSubscriptionAttributesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSubscriptionAttributesResult>(){

            @Override
            public GetSubscriptionAttributesResult call() throws Exception {
                GetSubscriptionAttributesResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeGetSubscriptionAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSubscriptionAttributesResult> getSubscriptionAttributesAsync(String subscriptionArn) {
        return this.getSubscriptionAttributesAsync(new GetSubscriptionAttributesRequest().withSubscriptionArn(subscriptionArn));
    }

    @Override
    public Future<GetSubscriptionAttributesResult> getSubscriptionAttributesAsync(String subscriptionArn, AsyncHandler<GetSubscriptionAttributesRequest, GetSubscriptionAttributesResult> asyncHandler) {
        return this.getSubscriptionAttributesAsync(new GetSubscriptionAttributesRequest().withSubscriptionArn(subscriptionArn), asyncHandler);
    }

    @Override
    public Future<GetTopicAttributesResult> getTopicAttributesAsync(GetTopicAttributesRequest request) {
        return this.getTopicAttributesAsync(request, null);
    }

    @Override
    public Future<GetTopicAttributesResult> getTopicAttributesAsync(GetTopicAttributesRequest request, final AsyncHandler<GetTopicAttributesRequest, GetTopicAttributesResult> asyncHandler) {
        final GetTopicAttributesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTopicAttributesResult>(){

            @Override
            public GetTopicAttributesResult call() throws Exception {
                GetTopicAttributesResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeGetTopicAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTopicAttributesResult> getTopicAttributesAsync(String topicArn) {
        return this.getTopicAttributesAsync(new GetTopicAttributesRequest().withTopicArn(topicArn));
    }

    @Override
    public Future<GetTopicAttributesResult> getTopicAttributesAsync(String topicArn, AsyncHandler<GetTopicAttributesRequest, GetTopicAttributesResult> asyncHandler) {
        return this.getTopicAttributesAsync(new GetTopicAttributesRequest().withTopicArn(topicArn), asyncHandler);
    }

    @Override
    public Future<ListEndpointsByPlatformApplicationResult> listEndpointsByPlatformApplicationAsync(ListEndpointsByPlatformApplicationRequest request) {
        return this.listEndpointsByPlatformApplicationAsync(request, null);
    }

    @Override
    public Future<ListEndpointsByPlatformApplicationResult> listEndpointsByPlatformApplicationAsync(ListEndpointsByPlatformApplicationRequest request, final AsyncHandler<ListEndpointsByPlatformApplicationRequest, ListEndpointsByPlatformApplicationResult> asyncHandler) {
        final ListEndpointsByPlatformApplicationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEndpointsByPlatformApplicationResult>(){

            @Override
            public ListEndpointsByPlatformApplicationResult call() throws Exception {
                ListEndpointsByPlatformApplicationResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeListEndpointsByPlatformApplication(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOriginationNumbersResult> listOriginationNumbersAsync(ListOriginationNumbersRequest request) {
        return this.listOriginationNumbersAsync(request, null);
    }

    @Override
    public Future<ListOriginationNumbersResult> listOriginationNumbersAsync(ListOriginationNumbersRequest request, final AsyncHandler<ListOriginationNumbersRequest, ListOriginationNumbersResult> asyncHandler) {
        final ListOriginationNumbersRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListOriginationNumbersResult>(){

            @Override
            public ListOriginationNumbersResult call() throws Exception {
                ListOriginationNumbersResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeListOriginationNumbers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPhoneNumbersOptedOutResult> listPhoneNumbersOptedOutAsync(ListPhoneNumbersOptedOutRequest request) {
        return this.listPhoneNumbersOptedOutAsync(request, null);
    }

    @Override
    public Future<ListPhoneNumbersOptedOutResult> listPhoneNumbersOptedOutAsync(ListPhoneNumbersOptedOutRequest request, final AsyncHandler<ListPhoneNumbersOptedOutRequest, ListPhoneNumbersOptedOutResult> asyncHandler) {
        final ListPhoneNumbersOptedOutRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPhoneNumbersOptedOutResult>(){

            @Override
            public ListPhoneNumbersOptedOutResult call() throws Exception {
                ListPhoneNumbersOptedOutResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeListPhoneNumbersOptedOut(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPlatformApplicationsResult> listPlatformApplicationsAsync(ListPlatformApplicationsRequest request) {
        return this.listPlatformApplicationsAsync(request, null);
    }

    @Override
    public Future<ListPlatformApplicationsResult> listPlatformApplicationsAsync(ListPlatformApplicationsRequest request, final AsyncHandler<ListPlatformApplicationsRequest, ListPlatformApplicationsResult> asyncHandler) {
        final ListPlatformApplicationsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPlatformApplicationsResult>(){

            @Override
            public ListPlatformApplicationsResult call() throws Exception {
                ListPlatformApplicationsResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeListPlatformApplications(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPlatformApplicationsResult> listPlatformApplicationsAsync() {
        return this.listPlatformApplicationsAsync(new ListPlatformApplicationsRequest());
    }

    @Override
    public Future<ListPlatformApplicationsResult> listPlatformApplicationsAsync(AsyncHandler<ListPlatformApplicationsRequest, ListPlatformApplicationsResult> asyncHandler) {
        return this.listPlatformApplicationsAsync(new ListPlatformApplicationsRequest(), asyncHandler);
    }

    @Override
    public Future<ListSMSSandboxPhoneNumbersResult> listSMSSandboxPhoneNumbersAsync(ListSMSSandboxPhoneNumbersRequest request) {
        return this.listSMSSandboxPhoneNumbersAsync(request, null);
    }

    @Override
    public Future<ListSMSSandboxPhoneNumbersResult> listSMSSandboxPhoneNumbersAsync(ListSMSSandboxPhoneNumbersRequest request, final AsyncHandler<ListSMSSandboxPhoneNumbersRequest, ListSMSSandboxPhoneNumbersResult> asyncHandler) {
        final ListSMSSandboxPhoneNumbersRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSMSSandboxPhoneNumbersResult>(){

            @Override
            public ListSMSSandboxPhoneNumbersResult call() throws Exception {
                ListSMSSandboxPhoneNumbersResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeListSMSSandboxPhoneNumbers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSubscriptionsResult> listSubscriptionsAsync(ListSubscriptionsRequest request) {
        return this.listSubscriptionsAsync(request, null);
    }

    @Override
    public Future<ListSubscriptionsResult> listSubscriptionsAsync(ListSubscriptionsRequest request, final AsyncHandler<ListSubscriptionsRequest, ListSubscriptionsResult> asyncHandler) {
        final ListSubscriptionsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSubscriptionsResult>(){

            @Override
            public ListSubscriptionsResult call() throws Exception {
                ListSubscriptionsResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeListSubscriptions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSubscriptionsResult> listSubscriptionsAsync() {
        return this.listSubscriptionsAsync(new ListSubscriptionsRequest());
    }

    @Override
    public Future<ListSubscriptionsResult> listSubscriptionsAsync(AsyncHandler<ListSubscriptionsRequest, ListSubscriptionsResult> asyncHandler) {
        return this.listSubscriptionsAsync(new ListSubscriptionsRequest(), asyncHandler);
    }

    @Override
    public Future<ListSubscriptionsResult> listSubscriptionsAsync(String nextToken) {
        return this.listSubscriptionsAsync(new ListSubscriptionsRequest().withNextToken(nextToken));
    }

    @Override
    public Future<ListSubscriptionsResult> listSubscriptionsAsync(String nextToken, AsyncHandler<ListSubscriptionsRequest, ListSubscriptionsResult> asyncHandler) {
        return this.listSubscriptionsAsync(new ListSubscriptionsRequest().withNextToken(nextToken), asyncHandler);
    }

    @Override
    public Future<ListSubscriptionsByTopicResult> listSubscriptionsByTopicAsync(ListSubscriptionsByTopicRequest request) {
        return this.listSubscriptionsByTopicAsync(request, null);
    }

    @Override
    public Future<ListSubscriptionsByTopicResult> listSubscriptionsByTopicAsync(ListSubscriptionsByTopicRequest request, final AsyncHandler<ListSubscriptionsByTopicRequest, ListSubscriptionsByTopicResult> asyncHandler) {
        final ListSubscriptionsByTopicRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSubscriptionsByTopicResult>(){

            @Override
            public ListSubscriptionsByTopicResult call() throws Exception {
                ListSubscriptionsByTopicResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeListSubscriptionsByTopic(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSubscriptionsByTopicResult> listSubscriptionsByTopicAsync(String topicArn) {
        return this.listSubscriptionsByTopicAsync(new ListSubscriptionsByTopicRequest().withTopicArn(topicArn));
    }

    @Override
    public Future<ListSubscriptionsByTopicResult> listSubscriptionsByTopicAsync(String topicArn, AsyncHandler<ListSubscriptionsByTopicRequest, ListSubscriptionsByTopicResult> asyncHandler) {
        return this.listSubscriptionsByTopicAsync(new ListSubscriptionsByTopicRequest().withTopicArn(topicArn), asyncHandler);
    }

    @Override
    public Future<ListSubscriptionsByTopicResult> listSubscriptionsByTopicAsync(String topicArn, String nextToken) {
        return this.listSubscriptionsByTopicAsync(new ListSubscriptionsByTopicRequest().withTopicArn(topicArn).withNextToken(nextToken));
    }

    @Override
    public Future<ListSubscriptionsByTopicResult> listSubscriptionsByTopicAsync(String topicArn, String nextToken, AsyncHandler<ListSubscriptionsByTopicRequest, ListSubscriptionsByTopicResult> asyncHandler) {
        return this.listSubscriptionsByTopicAsync(new ListSubscriptionsByTopicRequest().withTopicArn(topicArn).withNextToken(nextToken), asyncHandler);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTopicsResult> listTopicsAsync(ListTopicsRequest request) {
        return this.listTopicsAsync(request, null);
    }

    @Override
    public Future<ListTopicsResult> listTopicsAsync(ListTopicsRequest request, final AsyncHandler<ListTopicsRequest, ListTopicsResult> asyncHandler) {
        final ListTopicsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTopicsResult>(){

            @Override
            public ListTopicsResult call() throws Exception {
                ListTopicsResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeListTopics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTopicsResult> listTopicsAsync() {
        return this.listTopicsAsync(new ListTopicsRequest());
    }

    @Override
    public Future<ListTopicsResult> listTopicsAsync(AsyncHandler<ListTopicsRequest, ListTopicsResult> asyncHandler) {
        return this.listTopicsAsync(new ListTopicsRequest(), asyncHandler);
    }

    @Override
    public Future<ListTopicsResult> listTopicsAsync(String nextToken) {
        return this.listTopicsAsync(new ListTopicsRequest().withNextToken(nextToken));
    }

    @Override
    public Future<ListTopicsResult> listTopicsAsync(String nextToken, AsyncHandler<ListTopicsRequest, ListTopicsResult> asyncHandler) {
        return this.listTopicsAsync(new ListTopicsRequest().withNextToken(nextToken), asyncHandler);
    }

    @Override
    public Future<OptInPhoneNumberResult> optInPhoneNumberAsync(OptInPhoneNumberRequest request) {
        return this.optInPhoneNumberAsync(request, null);
    }

    @Override
    public Future<OptInPhoneNumberResult> optInPhoneNumberAsync(OptInPhoneNumberRequest request, final AsyncHandler<OptInPhoneNumberRequest, OptInPhoneNumberResult> asyncHandler) {
        final OptInPhoneNumberRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<OptInPhoneNumberResult>(){

            @Override
            public OptInPhoneNumberResult call() throws Exception {
                OptInPhoneNumberResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeOptInPhoneNumber(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PublishResult> publishAsync(PublishRequest request) {
        return this.publishAsync(request, null);
    }

    @Override
    public Future<PublishResult> publishAsync(PublishRequest request, final AsyncHandler<PublishRequest, PublishResult> asyncHandler) {
        final PublishRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PublishResult>(){

            @Override
            public PublishResult call() throws Exception {
                PublishResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executePublish(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PublishResult> publishAsync(String topicArn, String message) {
        return this.publishAsync(new PublishRequest().withTopicArn(topicArn).withMessage(message));
    }

    @Override
    public Future<PublishResult> publishAsync(String topicArn, String message, AsyncHandler<PublishRequest, PublishResult> asyncHandler) {
        return this.publishAsync(new PublishRequest().withTopicArn(topicArn).withMessage(message), asyncHandler);
    }

    @Override
    public Future<PublishResult> publishAsync(String topicArn, String message, String subject) {
        return this.publishAsync(new PublishRequest().withTopicArn(topicArn).withMessage(message).withSubject(subject));
    }

    @Override
    public Future<PublishResult> publishAsync(String topicArn, String message, String subject, AsyncHandler<PublishRequest, PublishResult> asyncHandler) {
        return this.publishAsync(new PublishRequest().withTopicArn(topicArn).withMessage(message).withSubject(subject), asyncHandler);
    }

    @Override
    public Future<PublishBatchResult> publishBatchAsync(PublishBatchRequest request) {
        return this.publishBatchAsync(request, null);
    }

    @Override
    public Future<PublishBatchResult> publishBatchAsync(PublishBatchRequest request, final AsyncHandler<PublishBatchRequest, PublishBatchResult> asyncHandler) {
        final PublishBatchRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PublishBatchResult>(){

            @Override
            public PublishBatchResult call() throws Exception {
                PublishBatchResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executePublishBatch(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutDataProtectionPolicyResult> putDataProtectionPolicyAsync(PutDataProtectionPolicyRequest request) {
        return this.putDataProtectionPolicyAsync(request, null);
    }

    @Override
    public Future<PutDataProtectionPolicyResult> putDataProtectionPolicyAsync(PutDataProtectionPolicyRequest request, final AsyncHandler<PutDataProtectionPolicyRequest, PutDataProtectionPolicyResult> asyncHandler) {
        final PutDataProtectionPolicyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutDataProtectionPolicyResult>(){

            @Override
            public PutDataProtectionPolicyResult call() throws Exception {
                PutDataProtectionPolicyResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executePutDataProtectionPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(RemovePermissionRequest request) {
        return this.removePermissionAsync(request, null);
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(RemovePermissionRequest request, final AsyncHandler<RemovePermissionRequest, RemovePermissionResult> asyncHandler) {
        final RemovePermissionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemovePermissionResult>(){

            @Override
            public RemovePermissionResult call() throws Exception {
                RemovePermissionResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeRemovePermission(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(String topicArn, String label) {
        return this.removePermissionAsync(new RemovePermissionRequest().withTopicArn(topicArn).withLabel(label));
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(String topicArn, String label, AsyncHandler<RemovePermissionRequest, RemovePermissionResult> asyncHandler) {
        return this.removePermissionAsync(new RemovePermissionRequest().withTopicArn(topicArn).withLabel(label), asyncHandler);
    }

    @Override
    public Future<SetEndpointAttributesResult> setEndpointAttributesAsync(SetEndpointAttributesRequest request) {
        return this.setEndpointAttributesAsync(request, null);
    }

    @Override
    public Future<SetEndpointAttributesResult> setEndpointAttributesAsync(SetEndpointAttributesRequest request, final AsyncHandler<SetEndpointAttributesRequest, SetEndpointAttributesResult> asyncHandler) {
        final SetEndpointAttributesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SetEndpointAttributesResult>(){

            @Override
            public SetEndpointAttributesResult call() throws Exception {
                SetEndpointAttributesResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeSetEndpointAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetPlatformApplicationAttributesResult> setPlatformApplicationAttributesAsync(SetPlatformApplicationAttributesRequest request) {
        return this.setPlatformApplicationAttributesAsync(request, null);
    }

    @Override
    public Future<SetPlatformApplicationAttributesResult> setPlatformApplicationAttributesAsync(SetPlatformApplicationAttributesRequest request, final AsyncHandler<SetPlatformApplicationAttributesRequest, SetPlatformApplicationAttributesResult> asyncHandler) {
        final SetPlatformApplicationAttributesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SetPlatformApplicationAttributesResult>(){

            @Override
            public SetPlatformApplicationAttributesResult call() throws Exception {
                SetPlatformApplicationAttributesResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeSetPlatformApplicationAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetSMSAttributesResult> setSMSAttributesAsync(SetSMSAttributesRequest request) {
        return this.setSMSAttributesAsync(request, null);
    }

    @Override
    public Future<SetSMSAttributesResult> setSMSAttributesAsync(SetSMSAttributesRequest request, final AsyncHandler<SetSMSAttributesRequest, SetSMSAttributesResult> asyncHandler) {
        final SetSMSAttributesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SetSMSAttributesResult>(){

            @Override
            public SetSMSAttributesResult call() throws Exception {
                SetSMSAttributesResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeSetSMSAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetSubscriptionAttributesResult> setSubscriptionAttributesAsync(SetSubscriptionAttributesRequest request) {
        return this.setSubscriptionAttributesAsync(request, null);
    }

    @Override
    public Future<SetSubscriptionAttributesResult> setSubscriptionAttributesAsync(SetSubscriptionAttributesRequest request, final AsyncHandler<SetSubscriptionAttributesRequest, SetSubscriptionAttributesResult> asyncHandler) {
        final SetSubscriptionAttributesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SetSubscriptionAttributesResult>(){

            @Override
            public SetSubscriptionAttributesResult call() throws Exception {
                SetSubscriptionAttributesResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeSetSubscriptionAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetSubscriptionAttributesResult> setSubscriptionAttributesAsync(String subscriptionArn, String attributeName, String attributeValue) {
        return this.setSubscriptionAttributesAsync(new SetSubscriptionAttributesRequest().withSubscriptionArn(subscriptionArn).withAttributeName(attributeName).withAttributeValue(attributeValue));
    }

    @Override
    public Future<SetSubscriptionAttributesResult> setSubscriptionAttributesAsync(String subscriptionArn, String attributeName, String attributeValue, AsyncHandler<SetSubscriptionAttributesRequest, SetSubscriptionAttributesResult> asyncHandler) {
        return this.setSubscriptionAttributesAsync(new SetSubscriptionAttributesRequest().withSubscriptionArn(subscriptionArn).withAttributeName(attributeName).withAttributeValue(attributeValue), asyncHandler);
    }

    @Override
    public Future<SetTopicAttributesResult> setTopicAttributesAsync(SetTopicAttributesRequest request) {
        return this.setTopicAttributesAsync(request, null);
    }

    @Override
    public Future<SetTopicAttributesResult> setTopicAttributesAsync(SetTopicAttributesRequest request, final AsyncHandler<SetTopicAttributesRequest, SetTopicAttributesResult> asyncHandler) {
        final SetTopicAttributesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SetTopicAttributesResult>(){

            @Override
            public SetTopicAttributesResult call() throws Exception {
                SetTopicAttributesResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeSetTopicAttributes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetTopicAttributesResult> setTopicAttributesAsync(String topicArn, String attributeName, String attributeValue) {
        return this.setTopicAttributesAsync(new SetTopicAttributesRequest().withTopicArn(topicArn).withAttributeName(attributeName).withAttributeValue(attributeValue));
    }

    @Override
    public Future<SetTopicAttributesResult> setTopicAttributesAsync(String topicArn, String attributeName, String attributeValue, AsyncHandler<SetTopicAttributesRequest, SetTopicAttributesResult> asyncHandler) {
        return this.setTopicAttributesAsync(new SetTopicAttributesRequest().withTopicArn(topicArn).withAttributeName(attributeName).withAttributeValue(attributeValue), asyncHandler);
    }

    @Override
    public Future<SubscribeResult> subscribeAsync(SubscribeRequest request) {
        return this.subscribeAsync(request, null);
    }

    @Override
    public Future<SubscribeResult> subscribeAsync(SubscribeRequest request, final AsyncHandler<SubscribeRequest, SubscribeResult> asyncHandler) {
        final SubscribeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SubscribeResult>(){

            @Override
            public SubscribeResult call() throws Exception {
                SubscribeResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeSubscribe(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SubscribeResult> subscribeAsync(String topicArn, String protocol, String endpoint) {
        return this.subscribeAsync(new SubscribeRequest().withTopicArn(topicArn).withProtocol(protocol).withEndpoint(endpoint));
    }

    @Override
    public Future<SubscribeResult> subscribeAsync(String topicArn, String protocol, String endpoint, AsyncHandler<SubscribeRequest, SubscribeResult> asyncHandler) {
        return this.subscribeAsync(new SubscribeRequest().withTopicArn(topicArn).withProtocol(protocol).withEndpoint(endpoint), asyncHandler);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UnsubscribeResult> unsubscribeAsync(UnsubscribeRequest request) {
        return this.unsubscribeAsync(request, null);
    }

    @Override
    public Future<UnsubscribeResult> unsubscribeAsync(UnsubscribeRequest request, final AsyncHandler<UnsubscribeRequest, UnsubscribeResult> asyncHandler) {
        final UnsubscribeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UnsubscribeResult>(){

            @Override
            public UnsubscribeResult call() throws Exception {
                UnsubscribeResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeUnsubscribe(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UnsubscribeResult> unsubscribeAsync(String subscriptionArn) {
        return this.unsubscribeAsync(new UnsubscribeRequest().withSubscriptionArn(subscriptionArn));
    }

    @Override
    public Future<UnsubscribeResult> unsubscribeAsync(String subscriptionArn, AsyncHandler<UnsubscribeRequest, UnsubscribeResult> asyncHandler) {
        return this.unsubscribeAsync(new UnsubscribeRequest().withSubscriptionArn(subscriptionArn), asyncHandler);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<VerifySMSSandboxPhoneNumberResult> verifySMSSandboxPhoneNumberAsync(VerifySMSSandboxPhoneNumberRequest request) {
        return this.verifySMSSandboxPhoneNumberAsync(request, null);
    }

    @Override
    public Future<VerifySMSSandboxPhoneNumberResult> verifySMSSandboxPhoneNumberAsync(VerifySMSSandboxPhoneNumberRequest request, final AsyncHandler<VerifySMSSandboxPhoneNumberRequest, VerifySMSSandboxPhoneNumberResult> asyncHandler) {
        final VerifySMSSandboxPhoneNumberRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<VerifySMSSandboxPhoneNumberResult>(){

            @Override
            public VerifySMSSandboxPhoneNumberResult call() throws Exception {
                VerifySMSSandboxPhoneNumberResult result = null;
                try {
                    result = AmazonSNSAsyncClient.this.executeVerifySMSSandboxPhoneNumber(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

