/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.services.sns.model.PhoneNumberInformation;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class PhoneNumberInformationStaxUnmarshaller
implements Unmarshaller<PhoneNumberInformation, StaxUnmarshallerContext> {
    private static PhoneNumberInformationStaxUnmarshaller instance;

    @Override
    public PhoneNumberInformation unmarshall(StaxUnmarshallerContext context) throws Exception {
        PhoneNumberInformation phoneNumberInformation = new PhoneNumberInformation();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return phoneNumberInformation;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CreatedAt", targetDepth)) {
                    phoneNumberInformation.setCreatedAt(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("PhoneNumber", targetDepth)) {
                    phoneNumberInformation.setPhoneNumber(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    phoneNumberInformation.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Iso2CountryCode", targetDepth)) {
                    phoneNumberInformation.setIso2CountryCode(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RouteType", targetDepth)) {
                    phoneNumberInformation.setRouteType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NumberCapabilities", targetDepth)) {
                    phoneNumberInformation.withNumberCapabilities(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("NumberCapabilities/member", targetDepth)) continue;
                phoneNumberInformation.withNumberCapabilities(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return phoneNumberInformation;
    }

    public static PhoneNumberInformationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PhoneNumberInformationStaxUnmarshaller();
        }
        return instance;
    }
}

