/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.sns.model.UntagResourceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UntagResourceRequestMarshaller
implements Marshaller<Request<UntagResourceRequest>, UntagResourceRequest> {
    @Override
    public Request<UntagResourceRequest> marshall(UntagResourceRequest untagResourceRequest) {
        if (untagResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UntagResourceRequest> request = new DefaultRequest<UntagResourceRequest>(untagResourceRequest, "AmazonSNS");
        request.addParameter("Action", "UntagResource");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (untagResourceRequest.getResourceArn() != null) {
            request.addParameter("ResourceArn", StringUtils.fromString(untagResourceRequest.getResourceArn()));
        }
        if (!untagResourceRequest.getTagKeys().isEmpty() || !((SdkInternalList)untagResourceRequest.getTagKeys()).isAutoConstruct()) {
            SdkInternalList tagKeysList = (SdkInternalList)untagResourceRequest.getTagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.member." + tagKeysListIndex, StringUtils.fromString(tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        return request;
    }
}

