/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.notification;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.duracloud.account.config.AmaEndpoint;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.EmailTemplate;
import org.duracloud.account.db.model.UserInvitation;
import org.duracloud.account.db.util.EmailTemplateService;
import org.duracloud.account.db.util.error.UnsentEmailException;
import org.duracloud.account.db.util.util.EmailTemplateUtil;
import org.duracloud.notification.Emailer;

public class Notifier {
    private Emailer emailer;
    private AmaEndpoint amaEndpoint;
    private EmailTemplateService emailTemplateService;

    public Notifier(Emailer emailer, AmaEndpoint amaEndpoint, EmailTemplateService emailTemplateService) {
        this.emailer = emailer;
        this.amaEndpoint = amaEndpoint;
        this.emailTemplateService = emailTemplateService;
    }

    private Map<String, String> createParameters(DuracloudUser user, AmaEndpoint amaEndpoint) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", user.getUsername());
        params.put("firstName", user.getFirstName());
        params.put("lastName", user.getLastName());
        params.putAll(this.createParameters(amaEndpoint));
        return params;
    }

    private Map<String, String> createParameters(AmaEndpoint amaEndpoint) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("managementConsoleUrl", amaEndpoint.getUrl());
        params.put("domain", amaEndpoint.getDomain());
        return params;
    }

    private void sendEmail(EmailTemplate template, Map<String, String> parameters, String recipientEmail) {
        this.sendEmail(EmailTemplateUtil.format(parameters, template.getSubject()), EmailTemplateUtil.format(parameters, template.getBody()), recipientEmail);
    }

    public void sendNotificationCreateNewUser(DuracloudUser user) {
        EmailTemplate template = this.emailTemplateService.getTemplate(EmailTemplate.Templates.USER_CREATED);
        this.sendEmail(template, this.createParameters(user, this.amaEndpoint), user.getEmail());
    }

    public void sendNotificationPasswordReset(DuracloudUser user, String redemptionCode, Date date) {
        EmailTemplate template = this.emailTemplateService.getTemplate(EmailTemplate.Templates.PASSWORD_RESET);
        Map<String, String> parameters = this.createParameters(user, this.amaEndpoint);
        parameters.put("redemptionCode", redemptionCode);
        parameters.put("expirationDate", date.toString());
        this.sendEmail(template, parameters, user.getEmail());
    }

    public void sendNotificationRedeemedInvitation(DuracloudUser user, String adminEmail) {
        EmailTemplate template = this.emailTemplateService.getTemplate(EmailTemplate.Templates.INVITATION_REDEEMED);
        Map<String, String> parameters = this.createParameters(user, this.amaEndpoint);
        this.sendEmail(template, parameters, adminEmail);
    }

    public void sendNotificationUserAddedToAccount(DuracloudUser user, AccountInfo accountInfo) {
        EmailTemplate template = this.emailTemplateService.getTemplate(EmailTemplate.Templates.USER_ADDED_TO_ACCOUNT);
        Map<String, String> parameters = this.createParameters(user, this.amaEndpoint);
        parameters.putAll(this.createParameters(accountInfo));
        this.sendEmail(template, parameters, user.getEmail());
    }

    private void sendEmail(String subject, String message, String emailAddr) {
        try {
            this.emailer.send(subject, message, emailAddr);
        }
        catch (Exception e) {
            String msg = "Error: Unable to send email with subject: " + subject + " to address: " + emailAddr;
            throw new UnsentEmailException(msg, e);
        }
    }

    public void sendNotificationUserInvitation(UserInvitation invitation) {
        EmailTemplate template = this.emailTemplateService.getTemplate(EmailTemplate.Templates.USER_INVITATION);
        Map<String, String> parameters = this.createParameters(this.amaEndpoint);
        parameters.putAll(this.createParameters(invitation.getAccount()));
        parameters.put("redemptionUrl", this.amaEndpoint.getUrl() + "/users/redeem/" + invitation.getRedemptionCode());
        parameters.put("createUserProfileUrl", this.amaEndpoint.getUrl() + "/users/new");
        this.sendEmail(template, parameters, invitation.getUserEmail());
    }

    private Map<String, String> createParameters(AccountInfo accountInfo) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        StringBuilder organizationName = new StringBuilder(accountInfo.getOrgName());
        if (StringUtils.isNotBlank(accountInfo.getDepartment())) {
            organizationName.append(", ");
            organizationName.append(accountInfo.getDepartment());
        }
        parameters.put("organizationName", organizationName.toString());
        parameters.put("subdomain", accountInfo.getSubdomain());
        parameters.put("accountName", accountInfo.getAcctName());
        return parameters;
    }
}

