/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.security.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.duracloud.account.db.util.security.AnnotationParser;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;

public class AnnotationParserImpl
implements AnnotationParser {
    private Logger log = LoggerFactory.getLogger(AnnotationParserImpl.class);

    @Override
    public Map<String, Object[]> getMethodAnnotationsForClass(Class annotationClass, Class targetClass) {
        this.log.trace("Collecting annotations {} over {}", (Object)annotationClass.getName(), (Object)targetClass.getName());
        try {
            return this.doGetMethodAnnotationsForClass(annotationClass, targetClass);
        }
        catch (Exception e) {
            this.log.error("Error getting annotations {} over {}: {}", annotationClass.getName(), targetClass.getName(), e.getMessage());
            throw new DuraCloudRuntimeException(e);
        }
    }

    private Map<String, Object[]> doGetMethodAnnotationsForClass(Class annotationClass, Class targetClass) {
        HashMap<String, Object[]> methodAnnotations = new HashMap<String, Object[]>();
        Class iface = this.getAnnotatedInterface(annotationClass, targetClass);
        MetadataReader metadataReader = this.getMetadataReader(iface);
        AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
        Set<MethodMetadata> annotatedMethods = this.getAnnotatedMethods(annotationMetadata, annotationClass);
        Iterator itr = this.getAnnotatedMethodsIterator(annotatedMethods);
        while (itr.hasNext()) {
            MethodMetadata methodMetadata = (MethodMetadata)itr.next();
            Map<String, Object> annotationAtts = methodMetadata.getAnnotationAttributes(annotationClass.getName());
            Object[] values = this.getValues(annotationAtts);
            methodAnnotations.put(methodMetadata.getMethodName(), values);
        }
        return methodAnnotations;
    }

    private Class getAnnotatedInterface(Class annotationClass, Class targetClass) {
        if (this.hasAnnotatedMethods(annotationClass, targetClass)) {
            return targetClass;
        }
        for (Class<?> iface : targetClass.getInterfaces()) {
            if (!this.hasAnnotatedMethods(annotationClass, iface)) continue;
            return iface;
        }
        throw new DuraCloudRuntimeException("No annotationMetadata found of " + annotationClass.getName() + " over " + targetClass.getName());
    }

    private boolean hasAnnotatedMethods(Class annotationClass, Class targetClass) {
        MetadataReader metadataReader = this.getMetadataReader(targetClass);
        AnnotationMetadata annotationMd = metadataReader.getAnnotationMetadata();
        return annotationMd.hasAnnotatedMethods(annotationClass.getName());
    }

    private MetadataReader getMetadataReader(Class<?> targetClass) {
        SimpleMetadataReaderFactory metadataReaderFactory = new SimpleMetadataReaderFactory();
        try {
            return metadataReaderFactory.getMetadataReader(targetClass.getName());
        }
        catch (IOException e) {
            this.log.warn("Error reading metadata. {}", (Object)e.getMessage());
            throw new DuraCloudRuntimeException(e);
        }
    }

    private Set<MethodMetadata> getAnnotatedMethods(AnnotationMetadata metadata, Class<?> annotationClass) {
        if (null == metadata) {
            throw new DuraCloudRuntimeException("Arg metadata is null: {}", annotationClass.getName());
        }
        return metadata.getAnnotatedMethods(annotationClass.getName());
    }

    private Iterator getAnnotatedMethodsIterator(Set<MethodMetadata> annotatedMethods) {
        if (null == annotatedMethods) {
            throw new DuraCloudRuntimeException("Arg annotatedMethods null.");
        }
        return annotatedMethods.iterator();
    }

    private Object[] getValues(Map<String, Object> annotationAtts) {
        if (null == annotationAtts) {
            throw new DuraCloudRuntimeException("Arg annotationAtts is null.");
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (String key : annotationAtts.keySet()) {
            Object[] objects;
            for (Object obj : objects = (Object[])annotationAtts.get(key)) {
                values.add(obj);
            }
        }
        return values.toArray();
    }
}

