/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Set;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.lang.Nullable;

public class DefaultQueryEnhancer
implements QueryEnhancer {
    private final DeclaredQuery query;

    public DefaultQueryEnhancer(DeclaredQuery query2) {
        this.query = query2;
    }

    @Override
    public String applySorting(Sort sort, @Nullable String alias) {
        return QueryUtils.applySorting(this.query.getQueryString(), sort, alias);
    }

    @Override
    public String detectAlias() {
        return QueryUtils.detectAlias(this.query.getQueryString());
    }

    @Override
    public String createCountQueryFor(@Nullable String countProjection) {
        return QueryUtils.createCountQueryFor(this.query.getQueryString(), countProjection, this.query.isNativeQuery());
    }

    @Override
    public String getProjection() {
        return QueryUtils.getProjection(this.query.getQueryString());
    }

    @Override
    public Set<String> getJoinAliases() {
        return QueryUtils.getOuterJoinAliases(this.query.getQueryString());
    }

    @Override
    public DeclaredQuery getQuery() {
        return this.query;
    }
}

