/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import javax.persistence.LockModeType;
import javax.persistence.QueryHint;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.jpa.repository.support.MutableQueryHints;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class CrudMethodMetadataPostProcessor
implements RepositoryProxyPostProcessor,
BeanClassLoaderAware {
    @Nullable
    private ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    CrudMethodMetadataPostProcessor() {
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void postProcess(ProxyFactory factory, RepositoryInformation repositoryInformation) {
        factory.addAdvice(new CrudMethodMetadataPopulatingMethodInterceptor(repositoryInformation));
    }

    CrudMethodMetadata getCrudMethodMetadata() {
        ProxyFactory factory = new ProxyFactory();
        factory.addInterface(CrudMethodMetadata.class);
        factory.setTargetSource(new ThreadBoundTargetSource());
        return (CrudMethodMetadata)factory.getProxy(this.classLoader);
    }

    private static class ThreadBoundTargetSource
    implements TargetSource {
        private ThreadBoundTargetSource() {
        }

        @Override
        public Class<?> getTargetClass() {
            return CrudMethodMetadata.class;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public Object getTarget() {
            MethodInvocation invocation = CrudMethodMetadataPopulatingMethodInterceptor.currentInvocation();
            return TransactionSynchronizationManager.getResource(invocation.getMethod());
        }

        @Override
        public void releaseTarget(Object target) {
        }
    }

    private static class DefaultCrudMethodMetadata
    implements CrudMethodMetadata {
        @Nullable
        private final LockModeType lockModeType;
        private final org.springframework.data.jpa.repository.support.QueryHints queryHints;
        private final org.springframework.data.jpa.repository.support.QueryHints queryHintsForCount;
        private final Optional<EntityGraph> entityGraph;
        private final Method method;

        DefaultCrudMethodMetadata(Method method) {
            Assert.notNull((Object)method, "Method must not be null!");
            this.lockModeType = DefaultCrudMethodMetadata.findLockModeType(method);
            this.queryHints = DefaultCrudMethodMetadata.findQueryHints(method, it -> true);
            this.queryHintsForCount = DefaultCrudMethodMetadata.findQueryHints(method, QueryHints::forCounting);
            this.entityGraph = DefaultCrudMethodMetadata.findEntityGraph(method);
            this.method = method;
        }

        private static Optional<EntityGraph> findEntityGraph(Method method) {
            return Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation(method, EntityGraph.class));
        }

        @Nullable
        private static LockModeType findLockModeType(Method method) {
            Lock annotation = AnnotatedElementUtils.findMergedAnnotation(method, Lock.class);
            return annotation == null ? null : (LockModeType)((Object)AnnotationUtils.getValue(annotation));
        }

        private static org.springframework.data.jpa.repository.support.QueryHints findQueryHints(Method method, Predicate<QueryHints> annotationFilter) {
            QueryHint queryHintAnnotation;
            MutableQueryHints queryHints = new MutableQueryHints();
            QueryHints queryHintsAnnotation = AnnotatedElementUtils.findMergedAnnotation(method, QueryHints.class);
            if (queryHintsAnnotation != null && annotationFilter.test(queryHintsAnnotation)) {
                for (QueryHint hint : queryHintsAnnotation.value()) {
                    queryHints.add(hint.name(), hint.value());
                }
            }
            if ((queryHintAnnotation = AnnotationUtils.findAnnotation(method, QueryHint.class)) != null) {
                queryHints.add(queryHintAnnotation.name(), queryHintAnnotation.value());
            }
            return queryHints;
        }

        @Override
        @Nullable
        public LockModeType getLockModeType() {
            return this.lockModeType;
        }

        @Override
        public org.springframework.data.jpa.repository.support.QueryHints getQueryHints() {
            return this.queryHints;
        }

        @Override
        public org.springframework.data.jpa.repository.support.QueryHints getQueryHintsForCount() {
            return this.queryHintsForCount;
        }

        @Override
        public Optional<EntityGraph> getEntityGraph() {
            return this.entityGraph;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }
    }

    static class CrudMethodMetadataPopulatingMethodInterceptor
    implements MethodInterceptor {
        private static final ThreadLocal<MethodInvocation> currentInvocation = new NamedThreadLocal<MethodInvocation>("Current AOP method invocation");
        private final ConcurrentMap<Method, CrudMethodMetadata> metadataCache = new ConcurrentHashMap<Method, CrudMethodMetadata>();
        private final Set<Method> implementations = new HashSet<Method>();

        CrudMethodMetadataPopulatingMethodInterceptor(RepositoryInformation repositoryInformation) {
            ReflectionUtils.doWithMethods(repositoryInformation.getRepositoryInterface(), this.implementations::add, method -> !repositoryInformation.isQueryMethod(method));
        }

        static MethodInvocation currentInvocation() throws IllegalStateException {
            MethodInvocation mi = currentInvocation.get();
            if (mi == null) {
                throw new IllegalStateException("No MethodInvocation found: Check that an AOP invocation is in progress, and that the CrudMethodMetadataPopulatingMethodInterceptor is upfront in the interceptor chain.");
            }
            return mi;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            if (!this.implementations.contains(method)) {
                return invocation.proceed();
            }
            MethodInvocation oldInvocation = currentInvocation.get();
            currentInvocation.set(invocation);
            try {
                Object object;
                CrudMethodMetadata tmp;
                CrudMethodMetadata metadata = (CrudMethodMetadata)TransactionSynchronizationManager.getResource(method);
                if (metadata != null) {
                    Object object2 = invocation.proceed();
                    return object2;
                }
                CrudMethodMetadata methodMetadata = (CrudMethodMetadata)this.metadataCache.get(method);
                if (methodMetadata == null && (tmp = this.metadataCache.putIfAbsent(method, methodMetadata = new DefaultCrudMethodMetadata(method))) != null) {
                    methodMetadata = tmp;
                }
                TransactionSynchronizationManager.bindResource(method, methodMetadata);
                try {
                    object = invocation.proceed();
                }
                catch (Throwable throwable) {
                    TransactionSynchronizationManager.unbindResource(method);
                    throw throwable;
                }
                TransactionSynchronizationManager.unbindResource(method);
                return object;
            }
            finally {
                currentInvocation.set(oldInvocation);
            }
        }
    }
}

