/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.jpa.EclipseLinkTemplates;
import com.querydsl.jpa.HQLTemplates;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.querydsl.QSort;
import org.springframework.util.Assert;

public class Querydsl {
    private final EntityManager em;
    private final PersistenceProvider provider;
    private final PathBuilder<?> builder;

    public Querydsl(EntityManager em, PathBuilder<?> builder) {
        Assert.notNull((Object)em, "EntityManager must not be null!");
        Assert.notNull(builder, "PathBuilder must not be null!");
        this.em = em;
        this.provider = PersistenceProvider.fromEntityManager(em);
        this.builder = builder;
    }

    public <T> AbstractJPAQuery<T, JPAQuery<T>> createQuery() {
        switch (this.provider) {
            case ECLIPSELINK: {
                return new JPAQuery(this.em, (JPQLTemplates)EclipseLinkTemplates.DEFAULT);
            }
            case HIBERNATE: {
                return new JPAQuery(this.em, (JPQLTemplates)HQLTemplates.DEFAULT);
            }
        }
        return new JPAQuery(this.em);
    }

    public AbstractJPAQuery<Object, JPAQuery<Object>> createQuery(EntityPath<?> ... paths) {
        Assert.notNull(paths, "Paths must not be null!");
        return (AbstractJPAQuery)this.createQuery().from(paths);
    }

    public <T> JPQLQuery<T> applyPagination(Pageable pageable, JPQLQuery<T> query2) {
        Assert.notNull((Object)pageable, "Pageable must not be null!");
        Assert.notNull(query2, "JPQLQuery must not be null!");
        if (pageable.isUnpaged()) {
            return query2;
        }
        query2.offset(pageable.getOffset());
        query2.limit((long)pageable.getPageSize());
        return this.applySorting(pageable.getSort(), query2);
    }

    public <T> JPQLQuery<T> applySorting(Sort sort, JPQLQuery<T> query2) {
        Assert.notNull((Object)sort, "Sort must not be null!");
        Assert.notNull(query2, "Query must not be null!");
        if (sort.isUnsorted()) {
            return query2;
        }
        if (sort instanceof QSort) {
            return this.addOrderByFrom((QSort)sort, query2);
        }
        return this.addOrderByFrom(sort, query2);
    }

    private <T> JPQLQuery<T> addOrderByFrom(QSort qsort, JPQLQuery<T> query2) {
        List<OrderSpecifier<?>> orderSpecifiers = qsort.getOrderSpecifiers();
        return (JPQLQuery)query2.orderBy(orderSpecifiers.toArray(new OrderSpecifier[0]));
    }

    private <T> JPQLQuery<T> addOrderByFrom(Sort sort, JPQLQuery<T> query2) {
        Assert.notNull((Object)sort, "Sort must not be null!");
        Assert.notNull(query2, "Query must not be null!");
        for (Sort.Order order : sort) {
            query2.orderBy(new OrderSpecifier[]{this.toOrderSpecifier(order)});
        }
        return query2;
    }

    private OrderSpecifier<?> toOrderSpecifier(Sort.Order order) {
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, this.buildOrderPropertyPathFrom(order), this.toQueryDslNullHandling(order.getNullHandling()));
    }

    private OrderSpecifier.NullHandling toQueryDslNullHandling(Sort.NullHandling nullHandling) {
        Assert.notNull((Object)nullHandling, "NullHandling must not be null!");
        switch (nullHandling) {
            case NULLS_FIRST: {
                return OrderSpecifier.NullHandling.NullsFirst;
            }
            case NULLS_LAST: {
                return OrderSpecifier.NullHandling.NullsLast;
            }
        }
        return OrderSpecifier.NullHandling.Default;
    }

    private Expression<?> buildOrderPropertyPathFrom(Sort.Order order) {
        Assert.notNull((Object)order, "Order must not be null!");
        SimplePath sortPropertyExpression = this.builder;
        for (PropertyPath path = PropertyPath.from(order.getProperty(), this.builder.getType()); path != null; path = path.next()) {
            sortPropertyExpression = !path.hasNext() && order.isIgnoreCase() && String.class.equals(path.getType()) ? Expressions.stringPath((Path)((Path)sortPropertyExpression), (String)path.getSegment()).lower() : Expressions.path(path.getType(), (Path)((Path)sortPropertyExpression), (String)path.getSegment());
        }
        return sortPropertyExpression;
    }
}

