/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access;

import java.util.Collection;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletContextAware;

@Deprecated
public class DefaultWebInvocationPrivilegeEvaluator
implements WebInvocationPrivilegeEvaluator,
ServletContextAware {
    protected static final Log logger = LogFactory.getLog(DefaultWebInvocationPrivilegeEvaluator.class);
    private final AbstractSecurityInterceptor securityInterceptor;
    private ServletContext servletContext;

    public DefaultWebInvocationPrivilegeEvaluator(AbstractSecurityInterceptor securityInterceptor) {
        Assert.notNull((Object)securityInterceptor, "SecurityInterceptor cannot be null");
        Assert.isTrue(FilterInvocation.class.equals(securityInterceptor.getSecureObjectClass()), "AbstractSecurityInterceptor does not support FilterInvocations");
        Assert.notNull((Object)securityInterceptor.getAccessDecisionManager(), "AbstractSecurityInterceptor must provide a non-null AccessDecisionManager");
        this.securityInterceptor = securityInterceptor;
    }

    @Override
    public boolean isAllowed(String uri, Authentication authentication) {
        return this.isAllowed(null, uri, null, authentication);
    }

    @Override
    public boolean isAllowed(String contextPath, String uri, String method, Authentication authentication) {
        Assert.notNull((Object)uri, "uri parameter is required");
        FilterInvocation filterInvocation = new FilterInvocation(contextPath, uri, method, this.servletContext);
        Collection<ConfigAttribute> attributes = this.securityInterceptor.obtainSecurityMetadataSource().getAttributes(filterInvocation);
        if (attributes == null) {
            return !this.securityInterceptor.isRejectPublicInvocations();
        }
        if (authentication == null) {
            return false;
        }
        try {
            this.securityInterceptor.getAccessDecisionManager().decide(authentication, filterInvocation, attributes);
            return true;
        }
        catch (AccessDeniedException ex) {
            logger.debug(LogMessage.format("%s denied for %s", (Object)filterInvocation, (Object)authentication), ex);
            return false;
        }
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

