/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.security.vote;

import java.util.Collection;
import org.aopalliance.intercept.MethodInvocation;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.util.DuracloudInstanceManagerService;
import org.duracloud.account.security.domain.SecuredRule;
import org.duracloud.account.security.vote.AccountManagerAccessDecisionVoter;
import org.duracloud.account.security.vote.BaseAccessDecisionVoter;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;

public class InstanceManagerAccessDecisionVoter
extends BaseAccessDecisionVoter {
    private Logger log = LoggerFactory.getLogger(AccountManagerAccessDecisionVoter.class);
    private final int ACCT_ID_INDEX = 0;

    public InstanceManagerAccessDecisionVoter(DuracloudRepoMgr repoMgr) {
        super(repoMgr);
    }

    @Override
    protected Class<?> getTargetService() {
        return DuracloudInstanceManagerService.class;
    }

    @Override
    protected int voteImpl(Authentication authentication, MethodInvocation invocation, Collection<ConfigAttribute> attributes, Object[] methodArgs, DuracloudUser user, SecuredRule securedRule, String role, SecuredRule.Scope scope) {
        int decision = -1;
        if (scope.equals((Object)SecuredRule.Scope.ANY)) {
            Collection<String> userRoles = this.getUserRoles(authentication);
            decision = this.voteHasRole(role, userRoles);
        } else if (scope.equals((Object)SecuredRule.Scope.SELF_ACCT)) {
            Long acctId = this.getAccountIdArg(methodArgs);
            decision = this.voteUserHasRoleOnAccount(user, role, acctId);
        } else {
            String err = "Invalid scope: " + (Object)((Object)scope);
            this.log.error(err);
            throw new DuraCloudRuntimeException(err);
        }
        return this.castVote(decision, invocation);
    }

    private Long getAccountIdArg(Object[] arguments) {
        if (arguments.length != 1 && arguments.length != 2) {
            this.log.error("Illegal number of args: " + arguments.length);
        }
        return (Long)arguments[0];
    }
}

