/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.security.vote;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.duracloud.account.db.model.AccountRights;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.util.DuracloudInstanceService;
import org.duracloud.account.security.domain.SecuredRule;
import org.duracloud.account.security.vote.AccountAccessDecisionVoter;
import org.duracloud.account.security.vote.BaseAccessDecisionVoter;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;

public class InstanceAccessDecisionVoter
extends BaseAccessDecisionVoter {
    private Logger log = LoggerFactory.getLogger(AccountAccessDecisionVoter.class);
    private final int USER_INDEX = 0;

    public InstanceAccessDecisionVoter(DuracloudRepoMgr repoMgr) {
        super(repoMgr);
    }

    @Override
    protected Class<?> getTargetService() {
        return DuracloudInstanceService.class;
    }

    @Override
    protected int voteImpl(Authentication authentication, MethodInvocation invocation, Collection<ConfigAttribute> attributes, Object[] methodArgs, DuracloudUser user, SecuredRule securedRule, String role, SecuredRule.Scope scope) {
        int decision = -1;
        if (scope.equals((Object)SecuredRule.Scope.ANY)) {
            Collection<String> userRoles = this.getUserRoles(authentication);
            decision = super.voteHasRole(role, userRoles);
        } else if (scope.equals((Object)SecuredRule.Scope.SELF_ACCT)) {
            Long acctId = this.getAcctId(invocation);
            decision = this.voteUserHasRoleOnAccount(user, role, acctId);
        } else if (scope.equals((Object)SecuredRule.Scope.SELF_ACCT_PEER_UPDATE)) {
            Long acctId = this.getAcctId(invocation);
            if (this.hasVote(this.voteUserHasRoleOnAccount(user, role, acctId))) {
                Set<AccountRights> existingRights = this.getAllUserRightsForAcct(acctId);
                Set<AccountRights> updatedRights = this.getUpdatedRights(methodArgs, acctId);
                decision = this.voteUserHasRoleOnAcctToUpdateUsers(user.getId(), acctId, existingRights, updatedRights);
            }
        } else {
            String err = "Invalid scope: " + (Object)((Object)scope);
            this.log.error(err);
            throw new DuraCloudRuntimeException(err);
        }
        return this.castVote(decision, invocation);
    }

    private Set<AccountRights> getUpdatedRights(Object[] arguments, Long acctId) {
        HashSet<AccountRights> rights = new HashSet<AccountRights>();
        Set<DuracloudUser> users = this.getUsersArg(arguments);
        for (DuracloudUser user : users) {
            Set userRights = user.getAccountRights();
            for (AccountRights accountRights : userRights) {
                if (!accountRights.getAccount().getId().equals(acctId)) continue;
                rights.add(accountRights);
            }
        }
        return rights;
    }

    private int voteUserHasRoleOnAcctToUpdateUsers(Long userId, Long acctId, Set<AccountRights> existingRights, Set<AccountRights> updatedRights) {
        AccountRights userRights = this.getUserRightsForAcct(userId, acctId);
        Set userRoles = userRights.getRoles();
        for (AccountRights rights : existingRights) {
            if (this.hasVote(this.voteRolesAreSufficientToUpdateOther(userRoles, rights.getRoles()))) continue;
            return -1;
        }
        for (AccountRights rights : updatedRights) {
            if (this.hasVote(this.voteRolesAreSufficientToUpdateOther(userRoles, rights.getRoles()))) continue;
            return -1;
        }
        return 1;
    }

    private Set<DuracloudUser> getUsersArg(Object[] arguments) {
        if (arguments.length <= 0) {
            this.log.error("Illegal number of args: " + arguments.length);
        }
        return (Set)arguments[0];
    }

    private Long getAcctId(MethodInvocation invocation) {
        DuracloudInstanceService instanceService = (DuracloudInstanceService)invocation.getThis();
        return instanceService.getAccountId();
    }
}

