/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.security.vote;

import java.util.Collection;
import org.aopalliance.intercept.MethodInvocation;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.util.AccountManagerService;
import org.duracloud.account.security.domain.SecuredRule;
import org.duracloud.account.security.vote.BaseAccessDecisionVoter;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;

public class AccountManagerAccessDecisionVoter
extends BaseAccessDecisionVoter {
    private Logger log = LoggerFactory.getLogger(AccountManagerAccessDecisionVoter.class);

    public AccountManagerAccessDecisionVoter(DuracloudRepoMgr repoMgr) {
        super(repoMgr);
    }

    @Override
    protected Class<?> getTargetService() {
        return AccountManagerService.class;
    }

    @Override
    protected int voteImpl(Authentication authentication, MethodInvocation invocation, Collection<ConfigAttribute> attributes, Object[] methodArgs, DuracloudUser user, SecuredRule securedRule, String role, SecuredRule.Scope scope) {
        int decision = -1;
        Collection<String> userRoles = this.getUserRoles(authentication);
        if (scope.equals((Object)SecuredRule.Scope.ANY)) {
            decision = this.voteHasRole(role, userRoles);
        } else if (scope.equals((Object)SecuredRule.Scope.SELF_ACCT)) {
            Long acctId = this.getIntArg(invocation.getArguments());
            decision = this.voteUserHasRoleOnAccount(user, role, acctId);
        } else if (scope.equals((Object)SecuredRule.Scope.SELF_ID)) {
            if (this.voteHasRole(role, userRoles) == 1) {
                Long userId = this.getIntArg(invocation.getArguments());
                decision = this.voteMyUserId(user, userId);
            }
        } else {
            String err = "Invalid scope: " + (Object)((Object)scope);
            this.log.error(err);
            throw new DuraCloudRuntimeException(err);
        }
        return this.castVote(decision, invocation);
    }

    private Long getIntArg(Object[] arguments) {
        if (arguments.length != 1) {
            this.log.error("Illegal number of args: " + arguments.length);
        }
        return (Long)arguments[0];
    }
}

