/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.security.vote;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.duracloud.account.db.model.AccountRights;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.Role;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.util.DuracloudUserService;
import org.duracloud.account.security.domain.SecuredRule;
import org.duracloud.account.security.vote.BaseAccessDecisionVoter;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;

public class UserAccessDecisionVoter
extends BaseAccessDecisionVoter {
    private Logger log = LoggerFactory.getLogger(UserAccessDecisionVoter.class);
    private final int ACCT_ID_INDEX = 0;
    private final int USER_ID_INDEX = 0;
    private final int USER_NAME_INDEX = 0;
    private final int OTHER_USER_ID_INDEX = 1;
    private final int NEW_ROLES_INDEX = 2;

    public UserAccessDecisionVoter(DuracloudRepoMgr repoMgr) {
        super(repoMgr);
    }

    @Override
    protected Class<?> getTargetService() {
        return DuracloudUserService.class;
    }

    @Override
    protected int voteImpl(Authentication authentication, MethodInvocation invocation, Collection<ConfigAttribute> attributes, Object[] methodArgs, DuracloudUser user, SecuredRule securedRule, String role, SecuredRule.Scope scope) {
        int decision = -1;
        Collection<String> userRoles = this.getUserRoles(authentication);
        if (scope.equals((Object)SecuredRule.Scope.ANY)) {
            decision = this.voteHasRole(role, userRoles);
        } else if (scope.equals((Object)SecuredRule.Scope.SELF_ID)) {
            if (this.hasVote(this.voteHasRole(role, userRoles))) {
                Long userId = this.getUserIdArg(methodArgs);
                decision = this.voteMyUserId(user, userId);
            }
        } else if (scope.equals((Object)SecuredRule.Scope.SELF_NAME)) {
            if (this.hasVote(this.voteHasRole(role, userRoles))) {
                String username = this.getUsernameArg(methodArgs);
                decision = this.voteMyUsername(user, username);
            }
        } else if (scope.equals((Object)SecuredRule.Scope.SELF_ACCT)) {
            Long acctId = this.getAccountIdArg(methodArgs);
            decision = this.voteUserHasRoleOnAccount(user, role, acctId);
        } else if (scope.equals((Object)SecuredRule.Scope.SELF_ACCT_PEER)) {
            Long acctId = this.getAccountIdArg(methodArgs);
            if (this.hasVote(this.voteUserHasRoleOnAccount(user, role, acctId))) {
                Long otherUserId = this.getOtherUserIdArg(methodArgs);
                decision = this.voteUserHasRoleOnAcctToManageOther(user.getId(), acctId, otherUserId);
            }
        } else if (scope.equals((Object)SecuredRule.Scope.SELF_ACCT_PEER_UPDATE)) {
            Long acctId = this.getAccountIdArg(methodArgs);
            Long otherUserId = this.getOtherUserIdArg(methodArgs);
            Set<Role> otherRoles = this.getOtherRolesArg(methodArgs);
            decision = this.hasVote(this.voteUserHasRoleOnAccount(user, role, acctId)) ? this.voteUserHasRoleOnAcctToUpdateOthersRoles(user.getId(), acctId, otherUserId, otherRoles) : this.voteUserIsCreatingNewAcct(user, acctId, otherUserId, otherRoles);
        } else {
            String err = "Invalid scope: " + (Object)((Object)scope);
            this.log.error(err);
            throw new DuraCloudRuntimeException(err);
        }
        return this.castVote(decision, invocation);
    }

    private int voteUserHasRoleOnAcctToManageOther(Long userId, Long acctId, Long otherUserId) {
        this.log.trace("Voting if user {} has roles on acct {} to manage {}.", new Object[]{userId, acctId, otherUserId});
        AccountRights rights = this.getUserRightsForAcct(userId, acctId);
        AccountRights other = this.getUserRightsForAcct(otherUserId, acctId);
        if (null == rights || null == other) {
            this.log.warn("No rights found for users {}, {} on acct {}", new Object[]{userId, otherUserId, acctId});
            return -1;
        }
        return this.voteRolesAreSufficientToUpdateOther(rights.getRoles(), other.getRoles());
    }

    private int voteUserIsCreatingNewAcct(DuracloudUser user, Long acctId, Long otherUserId, Set<Role> otherRoles) {
        return this.hasVote(this.voteMyUserId(user, otherUserId)) && this.accountIsEmpty(acctId) && this.isOwner(otherRoles) ? 1 : -1;
    }

    private boolean accountIsEmpty(Long acctId) {
        return this.numUsersForAccount(acctId) == 0;
    }

    private boolean isOwner(Set<Role> roles) {
        return roles.contains(Role.ROLE_OWNER);
    }

    private Set<Role> getOtherRolesArg(Object[] arguments) {
        if (arguments.length <= 2) {
            this.log.error("Illegal number of args: " + arguments.length);
        }
        HashSet<Role> roles = new HashSet<Role>();
        Object[] rolesArray = (Object[])arguments[2];
        if (null != rolesArray && rolesArray.length > 0) {
            for (Object role : rolesArray) {
                roles.add((Role)role);
            }
        }
        return roles;
    }

    private Long getOtherUserIdArg(Object[] arguments) {
        if (arguments.length <= 1) {
            this.log.error("Illegal number of args: " + arguments.length);
        }
        return (Long)arguments[1];
    }

    private Long getUserIdArg(Object[] arguments) {
        if (arguments.length <= 0) {
            this.log.error("Illegal number of args: " + arguments.length);
        }
        return (Long)arguments[0];
    }

    private String getUsernameArg(Object[] arguments) {
        if (arguments.length <= 0) {
            this.log.error("Illegal number of args: " + arguments.length);
        }
        return (String)arguments[0];
    }

    private Long getAccountIdArg(Object[] arguments) {
        if (arguments.length <= 0) {
            this.log.error("Illegal number of args: " + arguments.length);
        }
        return (Long)arguments[0];
    }
}

