/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.security.vote;

import java.util.Collection;
import org.aopalliance.intercept.MethodInvocation;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.util.AccountService;
import org.duracloud.account.security.domain.SecuredRule;
import org.duracloud.account.security.vote.BaseAccessDecisionVoter;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;

public class AccountAccessDecisionVoter
extends BaseAccessDecisionVoter {
    private Logger log = LoggerFactory.getLogger(AccountAccessDecisionVoter.class);

    public AccountAccessDecisionVoter(DuracloudRepoMgr repoMgr) {
        super(repoMgr);
    }

    @Override
    protected Class<?> getTargetService() {
        return AccountService.class;
    }

    @Override
    protected int voteImpl(Authentication authentication, MethodInvocation invocation, Collection<ConfigAttribute> attributes, Object[] methodArgs, DuracloudUser user, SecuredRule securedRule, String role, SecuredRule.Scope scope) {
        int decision = -1;
        if (scope.equals((Object)SecuredRule.Scope.ANY)) {
            Collection<String> userRoles = this.getUserRoles(authentication);
            decision = super.voteHasRole(role, userRoles);
        } else if (scope.equals((Object)SecuredRule.Scope.SELF_ACCT)) {
            Long acctId = this.getAcctId(invocation);
            decision = this.voteUserHasRoleOnAccount(user, role, acctId);
        } else {
            String err = "Invalid scope: " + (Object)((Object)scope);
            this.log.error(err);
            throw new DuraCloudRuntimeException(err);
        }
        return this.castVote(decision, invocation);
    }

    private Long getAcctId(MethodInvocation invocation) {
        AccountService acctService = (AccountService)invocation.getThis();
        return acctService.getAccountId();
    }
}

