/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.security.domain;

import java.util.StringTokenizer;
import org.duracloud.account.db.model.Role;

public class SecuredRule {
    private Role role;
    private Scope scope;
    private static final String delim = ",";
    private static final String prefixRole = "role:";
    private static final String prefixScope = "scope:";

    public SecuredRule(String rule) {
        StringTokenizer tokenizer;
        if (null == rule) {
            this.doThrow("arg Rule may not be null.");
        }
        if ((tokenizer = new StringTokenizer(rule, delim)).countTokens() != 2) {
            this.doThrow("There must be two tokens. " + rule);
        }
        String fullRole = tokenizer.nextToken().trim();
        String fullScope = tokenizer.nextToken().trim();
        if (!fullRole.startsWith(prefixRole)) {
            this.doThrow("Role must begin with role:, " + rule);
        }
        if (!fullScope.startsWith(prefixScope)) {
            this.doThrow("Scope must begin with scope:, " + rule);
        }
        this.role = Role.valueOf((String)fullRole.substring(prefixRole.length()));
        this.scope = Scope.valueOf(fullScope.substring(prefixScope.length()));
    }

    public Role getRole() {
        return this.role;
    }

    public Scope getScope() {
        return this.scope;
    }

    private void doThrow(String msg) {
        throw new IllegalArgumentException("Invalid rule: " + msg);
    }

    public static enum Scope {
        ANY,
        SELF_ID,
        SELF_NAME,
        SELF_ACCT,
        SELF_ACCT_PEER,
        SELF_ACCT_PEER_UPDATE;

    }
}

