/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.security.vote;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.duracloud.account.db.model.AccountRights;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.Role;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.repo.DuracloudRightsRepo;
import org.duracloud.account.security.domain.SecuredRule;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public abstract class BaseAccessDecisionVoter
implements AccessDecisionVoter<MethodInvocation> {
    protected Logger log = LoggerFactory.getLogger(BaseAccessDecisionVoter.class);
    private DuracloudRepoMgr repoMgr;

    public BaseAccessDecisionVoter(DuracloudRepoMgr repoMgr) {
        this.repoMgr = repoMgr;
    }

    protected abstract Class<?> getTargetService();

    public boolean supports(ConfigAttribute attribute) {
        this.log.trace("supports attribute{}", (Object)attribute.getAttribute());
        return true;
    }

    public boolean supports(Class<?> clazz) {
        this.log.trace("supports {}", (Object)clazz.getName());
        return MethodInvocation.class.isAssignableFrom(clazz);
    }

    protected boolean supportsTarget(MethodInvocation invocation) {
        Class<?>[] interfaces = invocation.getThis().getClass().getInterfaces();
        if (null == interfaces || interfaces.length == 0) {
            return false;
        }
        for (Class<?> c : interfaces) {
            if (!c.equals(this.getTargetService())) continue;
            return true;
        }
        return false;
    }

    protected SecuredRule getRule(Collection<ConfigAttribute> atts) {
        if (null == atts || atts.size() != 1) {
            throw new DuraCloudRuntimeException("Invalid security att " + atts);
        }
        return new SecuredRule(atts.iterator().next().getAttribute());
    }

    protected Collection<String> getUserRoles(Authentication authentication) {
        HashSet<String> roles = new HashSet<String>();
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            roles.add(authority.getAuthority());
        }
        return roles;
    }

    protected int voteHasRole(String role, Collection<String> userRoles) {
        return userRoles.contains(role) ? 1 : -1;
    }

    protected int voteUserHasRoleOnAccount(DuracloudUser user, String role, Long acctId) {
        this.log.trace("Does user {} have role {} on acct {}?", new Object[]{user.getId(), role, acctId});
        AccountRights rights = this.getUserRightsForAcct(user.getId(), acctId);
        if (null == rights) {
            return -1;
        }
        Set acctRoles = rights.getRoles();
        this.log.trace("Roles found: {}", (Object)acctRoles);
        if (acctRoles != null && acctRoles.size() > 0) {
            for (Role acctRole : acctRoles) {
                if (!role.equals(acctRole.authority().getAuthority())) continue;
                return 1;
            }
        }
        return -1;
    }

    protected int voteUserHasRoleOnAcctToUpdateOthersRoles(Long userId, Long acctId, Long otherUserId, Set<Role> otherRoles) {
        this.log.trace("Voting if user {} has roles on acct {} to manage {}.", new Object[]{userId, acctId, otherUserId});
        AccountRights rights = this.getUserRightsForAcct(userId, acctId);
        AccountRights other = this.getUserRightsForAcct(otherUserId, acctId);
        if (null == rights || null == other) {
            this.log.warn("No rights found for users {}, {} on acct {}", new Object[]{userId, otherUserId, acctId});
            return -1;
        }
        boolean existing = this.hasVote(this.voteRolesAreSufficientToUpdateOther(rights.getRoles(), other.getRoles()));
        boolean updates = this.hasVote(this.voteRolesAreSufficientToUpdateOther(rights.getRoles(), otherRoles));
        this.log.trace("Are {} sufficient to update both {} and {}?", new Object[]{rights.getRoles(), other.getRoles(), otherRoles});
        return existing && updates ? 1 : -1;
    }

    protected int voteRolesAreSufficientToUpdateOther(Set<Role> roles, Set<Role> other) {
        if (null == roles || null == other) {
            this.log.warn("Null roles one or more {}, {}", roles, other);
            return -1;
        }
        Role otherHighestRole = Role.highestRole(other);
        if (null == otherHighestRole) {
            this.log.warn("No highest role found for {}", other);
            return -1;
        }
        boolean userHasRole = roles.contains(otherHighestRole);
        this.log.trace("Roles {} has permission to manage other {}", roles, (Object)otherHighestRole);
        return userHasRole ? 1 : -1;
    }

    protected boolean hasVote(int vote) {
        return vote == 1;
    }

    protected int numUsersForAccount(Long acctId) {
        HashSet rights = new HashSet(this.repoMgr.getRightsRepo().findByAccountId(acctId));
        return null != rights ? rights.size() : 0;
    }

    protected AccountRights getUserRightsForAcct(Long userId, Long acctId) {
        DuracloudRightsRepo rightsRepo = this.repoMgr.getRightsRepo();
        AccountRights rights = rightsRepo.findByAccountIdAndUserId(acctId, userId);
        return rights;
    }

    protected Set<AccountRights> getAllUserRightsForAcct(Long acctId) {
        DuracloudRightsRepo rightsRepo = this.repoMgr.getRightsRepo();
        Object rights = null;
        return new HashSet<AccountRights>(rightsRepo.findByAccountId(acctId));
    }

    protected int voteMyUserId(DuracloudUser user, Long userId) {
        return user.getId().equals(userId) ? 1 : -1;
    }

    protected int voteMyUsername(DuracloudUser user, String username) {
        return user.getUsername().equals(username) ? 1 : -1;
    }

    protected DuracloudUser getCurrentUser(Authentication authentication) {
        Object principal = authentication.getPrincipal();
        if (principal instanceof String) {
            this.log.trace("Unknown user {}", principal);
            DuracloudUser user = new DuracloudUser();
            user.setUsername((String)principal);
            return user;
        }
        return (DuracloudUser)principal;
    }

    protected String asString(int decision) {
        String s = "unknown";
        switch (decision) {
            case -1: {
                return "ACCESS_DENIED";
            }
            case 0: {
                return "ACCESS_ABSTAIN";
            }
            case 1: {
                return "ACCESS_GRANTED";
            }
        }
        return s;
    }

    public final int vote(Authentication authentication, MethodInvocation invocation, Collection<ConfigAttribute> attributes) {
        if (!this.supportsTarget(invocation)) {
            return this.castVote(0, invocation);
        }
        Object[] methodArgs = invocation.getArguments();
        DuracloudUser user = this.getCurrentUser(authentication);
        if (user.isRootUser()) {
            return 1;
        }
        SecuredRule securedRule = this.getRule(attributes);
        String role = securedRule.getRole().name();
        SecuredRule.Scope scope = securedRule.getScope();
        return this.voteImpl(authentication, invocation, attributes, methodArgs, user, securedRule, role, scope);
    }

    protected int castVote(int decision, MethodInvocation invocation) {
        String methodName = invocation.getMethod().getName();
        String className = invocation.getThis().getClass().getSimpleName();
        this.log.trace("{}.{}() = {}", new Object[]{className, methodName, this.asString(decision)});
        return decision;
    }

    protected abstract int voteImpl(Authentication var1, MethodInvocation var2, Collection<ConfigAttribute> var3, Object[] var4, DuracloudUser var5, SecuredRule var6, String var7, SecuredRule.Scope var8);
}

