/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.security.auth;

import org.duracloud.account.db.model.DuracloudUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

public class AuthProvider
extends DaoAuthenticationProvider {
    private final Logger log = LoggerFactory.getLogger(AuthProvider.class);

    public AuthProvider(UserDetailsService userDetailsService, PasswordEncoder passwordEncoder) {
        super.setUserDetailsService(userDetailsService);
        super.setPasswordEncoder(passwordEncoder);
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        super.additionalAuthenticationChecks(userDetails, authentication);
        DuracloudUser dcUser = (DuracloudUser)userDetails;
        String userIpLimits = dcUser.getAllowableIPAddressRange();
        if (null != userIpLimits && !userIpLimits.equals("")) {
            String[] ipLimits;
            WebAuthenticationDetails details = (WebAuthenticationDetails)authentication.getDetails();
            String requestIp = details.getRemoteAddress();
            for (String ipLimit : ipLimits = userIpLimits.split(";")) {
                if (!this.ipInRange(requestIp, ipLimit)) continue;
                this.log.debug("Allowing authentication check to continue for user " + dcUser.getUsername() + " because their IP " + requestIp + " exists in a valid range " + ipLimit);
                return;
            }
            this.log.debug("Denying authentication request for user " + dcUser.getUsername() + " because their IP " + requestIp + " does not match any valid ranges " + userIpLimits);
            throw new InsufficientAuthenticationException("Originating IP for authentication request" + requestIp + " is not in an accepted range.");
        }
        this.log.debug("Allowing authentication check to continue for user " + dcUser.getUsername() + " because no IP limits are defined");
    }

    protected boolean ipInRange(String ipAddress, String range) {
        IpAddressMatcher addressMatcher = new IpAddressMatcher(range);
        return addressMatcher.matches(ipAddress);
    }
}

