/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.instance.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.duracloud.account.config.AmaEndpoint;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.ComputeProviderAccount;
import org.duracloud.account.db.model.DuracloudInstance;
import org.duracloud.account.db.model.DuracloudMill;
import org.duracloud.account.db.model.ServerDetails;
import org.duracloud.account.db.model.ServerImage;
import org.duracloud.account.db.model.StorageProviderAccount;
import org.duracloud.account.db.repo.DuracloudAccountRepo;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.util.DuracloudMillConfigService;
import org.duracloud.account.db.util.instance.InstanceConfigUtil;
import org.duracloud.account.db.util.notification.NotificationMgrConfig;
import org.duracloud.appconfig.domain.DurabossConfig;
import org.duracloud.appconfig.domain.DuradminConfig;
import org.duracloud.appconfig.domain.DurastoreConfig;
import org.duracloud.appconfig.domain.NotificationConfig;
import org.duracloud.storage.domain.AuditConfig;
import org.duracloud.storage.domain.DatabaseConfig;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.domain.impl.StorageAccountImpl;

public class InstanceConfigUtilImpl
implements InstanceConfigUtil {
    protected static final String DEFAULT_SSL_PORT = "443";
    protected static final String NOTIFICATION_TYPE = "EMAIL";
    private DuracloudInstance instance;
    private DuracloudRepoMgr repoMgr;
    private NotificationMgrConfig notMgrConfig;
    private DuracloudMillConfigService duracloudMillService;
    private AmaEndpoint amaEndpoint;

    public InstanceConfigUtilImpl(DuracloudInstance instance, DuracloudRepoMgr repoMgr, NotificationMgrConfig notMgrConfig, AmaEndpoint amaEndpoint, DuracloudMillConfigService duracloudMillService) {
        this.instance = instance;
        this.repoMgr = repoMgr;
        this.notMgrConfig = notMgrConfig;
        this.amaEndpoint = amaEndpoint;
        this.duracloudMillService = duracloudMillService;
    }

    @Override
    public DuradminConfig getDuradminConfig() {
        DuradminConfig config = new DuradminConfig();
        config.setDurastoreHost(this.instance.getHostName());
        config.setDurastorePort(DEFAULT_SSL_PORT);
        config.setDurastoreContext("durastore");
        config.setAmaUrl(this.amaEndpoint.getUrl());
        config.setMillDbEnabled(true);
        return config;
    }

    @Override
    public DurastoreConfig getDurastoreConfig() {
        DurastoreConfig config = new DurastoreConfig();
        HashSet<StorageAccount> storageAccts = new HashSet<StorageAccount>();
        ServerDetails serverDetails = this.getAccount().getServerDetails();
        StorageProviderAccount primaryProviderAccount = serverDetails.getPrimaryStorageProviderAccount();
        storageAccts.add(this.getStorageAccount(primaryProviderAccount, true));
        Set storageProviderAccounts = serverDetails.getSecondaryStorageProviderAccounts();
        for (StorageProviderAccount storageProviderAccount : storageProviderAccounts) {
            storageAccts.add(this.getStorageAccount(storageProviderAccount, false));
        }
        config.setStorageAccounts(storageAccts);
        DuracloudMill mill = this.duracloudMillService.get();
        ComputeProviderAccount compute = serverDetails.getComputeProviderAccount();
        AuditConfig auditConfig = config.getAuditConfig();
        auditConfig.setAuditUsername(compute.getUsername());
        auditConfig.setAuditPassword(compute.getPassword());
        auditConfig.setAuditQueueName(mill.getAuditQueue());
        auditConfig.setAuditLogSpaceId(mill.getAuditLogSpaceId());
        config.setAuditConfig(auditConfig);
        DatabaseConfig milldbConfig = new DatabaseConfig();
        milldbConfig.setHost(mill.getDbHost());
        milldbConfig.setPort(mill.getDbPort().intValue());
        milldbConfig.setName(mill.getDbName());
        milldbConfig.setUsername(mill.getDbUsername());
        milldbConfig.setPassword(mill.getDbPassword());
        config.setMillDbConfig(milldbConfig);
        return config;
    }

    private AccountInfo getAccount() {
        DuracloudAccountRepo accountRepo = this.repoMgr.getAccountRepo();
        return (AccountInfo)accountRepo.findOne((Serializable)this.instance.getAccount().getId());
    }

    private StorageAccount getStorageAccount(StorageProviderAccount provider, boolean primary) {
        StorageAccountImpl storageAccount = new StorageAccountImpl(String.valueOf(provider.getId()), provider.getUsername(), provider.getPassword(), provider.getProviderType());
        storageAccount.setPrimary(primary);
        String storageClass = "rrs";
        if (!provider.isRrs()) {
            storageClass = "standard";
        }
        storageAccount.setOption(StorageAccount.OPTS.STORAGE_CLASS.name(), storageClass);
        Map providerProps = provider.getProperties();
        if (null != providerProps && providerProps.size() > 0) {
            for (String propKey : providerProps.keySet()) {
                String propValue = (String)providerProps.get(propKey);
                storageAccount.setOption(propKey, propValue);
            }
        }
        if (provider.getProviderType().equals((Object)StorageProviderType.AMAZON_S3)) {
            ServerImage image = this.instance.getImage();
            storageAccount.setOption(StorageAccount.OPTS.CF_KEY_PATH.name(), image.getCfKeyPath());
            storageAccount.setOption(StorageAccount.OPTS.CF_ACCOUNT_ID.name(), image.getCfAccountId());
            storageAccount.setOption(StorageAccount.OPTS.CF_KEY_ID.name(), image.getCfKeyId());
        }
        return storageAccount;
    }

    @Override
    public DurabossConfig getDurabossConfig() {
        DurabossConfig config = new DurabossConfig();
        config.setDurastoreHost(this.instance.getHostName());
        config.setDurastorePort(DEFAULT_SSL_PORT);
        config.setDurastoreContext("durastore");
        NotificationConfig notificationConfig = new NotificationConfig();
        notificationConfig.setType(NOTIFICATION_TYPE);
        notificationConfig.setUsername(this.notMgrConfig.getUsername());
        notificationConfig.setPassword(this.notMgrConfig.getPassword());
        notificationConfig.setOriginator(this.notMgrConfig.getFromAddress());
        ArrayList<String> admins = new ArrayList<String>();
        admins.add(this.notMgrConfig.getAdminAddress());
        notificationConfig.setAdmins(admins);
        HashMap<String, NotificationConfig> notificationConfigMap = new HashMap<String, NotificationConfig>();
        notificationConfigMap.put("0", notificationConfig);
        config.setNotificationConfigs(notificationConfigMap);
        config.setDurabossContext("duraboss");
        return config;
    }
}

