/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.duracloud.account.compute.ComputeProviderUtil;
import org.duracloud.account.compute.DuracloudComputeProvider;
import org.duracloud.account.compute.error.DuracloudInstanceNotAvailableException;
import org.duracloud.account.config.AmaEndpoint;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.ComputeProviderAccount;
import org.duracloud.account.db.model.DuracloudGroup;
import org.duracloud.account.db.model.DuracloudInstance;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.InstanceType;
import org.duracloud.account.db.model.Role;
import org.duracloud.account.db.model.ServerImage;
import org.duracloud.account.db.repo.DuracloudAccountRepo;
import org.duracloud.account.db.repo.DuracloudGroupRepo;
import org.duracloud.account.db.repo.DuracloudInstanceRepo;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.util.DuracloudInstanceService;
import org.duracloud.account.db.util.DuracloudMillConfigService;
import org.duracloud.account.db.util.error.DuracloudInstanceUpdateException;
import org.duracloud.account.db.util.instance.DurabossUpdater;
import org.duracloud.account.db.util.instance.InstanceConfigUtil;
import org.duracloud.account.db.util.instance.InstanceInitListener;
import org.duracloud.account.db.util.instance.InstanceUpdater;
import org.duracloud.account.db.util.instance.impl.DurabossUpdaterImpl;
import org.duracloud.account.db.util.instance.impl.InstanceAccessUtilImpl;
import org.duracloud.account.db.util.instance.impl.InstanceConfigUtilImpl;
import org.duracloud.account.db.util.instance.impl.InstanceUpdaterImpl;
import org.duracloud.account.db.util.notification.NotificationMgrConfig;
import org.duracloud.account.db.util.util.UserFinderUtil;
import org.duracloud.appconfig.domain.DurabossConfig;
import org.duracloud.appconfig.domain.DuradminConfig;
import org.duracloud.appconfig.domain.DurastoreConfig;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.model.Credential;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.security.domain.SecurityUserBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuracloudInstanceServiceImpl
implements DuracloudInstanceService,
InstanceInitListener {
    private Logger log = LoggerFactory.getLogger(DuracloudInstanceServiceImpl.class);
    private static final int MAX_INIT_RETRIES = 10;
    private Long accountId;
    private AccountInfo accountInfo;
    private DuracloudInstance instance;
    private DuracloudRepoMgr repoMgr;
    private UserFinderUtil userFinderUtil;
    private ComputeProviderUtil computeProviderUtil;
    private DuracloudComputeProvider computeProvider;
    private InstanceUpdater instanceUpdater;
    private InstanceConfigUtil instanceConfigUtil;
    private DurabossUpdater durabossUpdater;
    private Credential rootCredential;
    private NotificationMgrConfig notMgrConfig;
    private DuracloudMillConfigService duracloudMillService;
    private int timeoutMinutes = 20;

    public DuracloudInstanceServiceImpl(Long accountId, DuracloudInstance instance, DuracloudRepoMgr repoMgr, UserFinderUtil userFinderUtil, ComputeProviderUtil computeProviderUtil, NotificationMgrConfig notMgrConfig, AmaEndpoint amaEndpoint, DuracloudMillConfigService duracloudMillService) {
        this(accountId, instance, repoMgr, userFinderUtil, computeProviderUtil, null, null, null, null, notMgrConfig, amaEndpoint, duracloudMillService);
    }

    protected DuracloudInstanceServiceImpl(Long accountId, DuracloudInstance instance, DuracloudRepoMgr repoMgr, UserFinderUtil userFinderUtil, ComputeProviderUtil computeProviderUtil, DuracloudComputeProvider computeProvider, InstanceUpdater instanceUpdater, InstanceConfigUtil instanceConfigUtil, DurabossUpdater durabossUpdater, NotificationMgrConfig notMgrConfig, AmaEndpoint amaEndpoint, DuracloudMillConfigService duracloudMillService) {
        this.accountId = accountId;
        this.instance = instance;
        this.repoMgr = repoMgr;
        this.userFinderUtil = userFinderUtil;
        this.computeProviderUtil = computeProviderUtil;
        this.computeProvider = computeProvider;
        this.instanceUpdater = instanceUpdater;
        this.instanceConfigUtil = instanceConfigUtil;
        this.durabossUpdater = durabossUpdater;
        this.notMgrConfig = notMgrConfig;
        this.duracloudMillService = duracloudMillService;
        if (null == computeProvider) {
            this.initializeComputeProvider();
        }
        if (null == instanceUpdater) {
            this.instanceUpdater = new InstanceUpdaterImpl();
        }
        if (null == instanceConfigUtil) {
            this.instanceConfigUtil = new InstanceConfigUtilImpl(instance, repoMgr, notMgrConfig, amaEndpoint, duracloudMillService);
        }
        if (null == durabossUpdater) {
            this.durabossUpdater = new DurabossUpdaterImpl();
        }
    }

    @Override
    public Long getAccountId() {
        return this.accountId;
    }

    @Override
    public DuracloudInstance getInstanceInfo() {
        return this.instance;
    }

    @Override
    public String getInstanceVersion() {
        ServerImage serverImage = this.getServerImage();
        return serverImage.getVersion();
    }

    @Override
    public String getStatus() throws DuracloudInstanceNotAvailableException {
        return this.getStatusFromComputeProvider();
    }

    @Override
    public String getStatusInternal() throws DuracloudInstanceNotAvailableException {
        return this.getStatusFromComputeProvider();
    }

    @Override
    public InstanceType getInstanceType() throws DuracloudInstanceNotAvailableException {
        return this.computeProvider.getInstanceType(this.instance.getProviderInstanceId());
    }

    @Override
    public void stop() {
        this.log.info("Stopping instance with provider ID {} at host {}", (Object)this.instance.getProviderInstanceId(), (Object)this.instance.getHostName());
        String host = this.instance.getHostName();
        DurabossConfig durabossConfig = this.instanceConfigUtil.getDurabossConfig();
        RestHttpHelper restHelper = new RestHttpHelper(this.getRootCredential());
        try {
            this.durabossUpdater.stopDuraboss(host, durabossConfig, restHelper);
        }
        catch (Exception e) {
            this.log.error("Error stopping DuraBoss: {}", (Object)e.getMessage(), (Object)e);
        }
        this.computeProvider.stop(this.instance.getProviderInstanceId());
        DuracloudAccountRepo accountRepo = this.repoMgr.getAccountRepo();
        AccountInfo account = (AccountInfo)accountRepo.getOne((Serializable)this.instance.getAccount().getId());
        account.setInstance(null);
        accountRepo.saveAndFlush((Object)account);
        DuracloudInstanceRepo instanceRepo = this.repoMgr.getInstanceRepo();
        instanceRepo.delete((Serializable)this.instance.getId());
        instanceRepo.flush();
    }

    @Override
    public void initialize() {
        this.log.info("Initializing instance for account {} at host {}", (Object)this.accountId, (Object)this.instance.getHostName());
        this.doInitialize(true);
    }

    @Override
    public void reInitialize() {
        this.log.info("Re-Initializing instance for account {} at host {}", (Object)this.accountId, (Object)this.instance.getHostName());
        this.doInitialize(false);
    }

    @Override
    public void reInitializeUserRoles() {
        this.initializeUserRoles();
    }

    @Override
    public void restart() {
        this.log.info("Restarting instance with provider ID {} at host {}", (Object)this.instance.getProviderInstanceId(), (Object)this.instance.getHostName());
        this.computeProvider.restart(this.instance.getProviderInstanceId());
        this.doInitialize(true);
    }

    @Override
    public void handleInstanceInitFailure() {
        this.log.error("Failure attempting to initialize instance " + this.instance.getId() + " for account " + this.accountId);
    }

    protected void doInitialize(boolean wait) {
        if (wait && this.timeoutMinutes > 0) {
            new ThreadedInitializer(this.timeoutMinutes, this).start();
        } else {
            this.initializeUserRoles();
            this.initializeInstance();
            this.updateInstance();
        }
    }

    private void initializeInstance() {
        DuradminConfig duradminConfig = this.instanceConfigUtil.getDuradminConfig();
        DurastoreConfig durastoreConfig = this.instanceConfigUtil.getDurastoreConfig();
        DurabossConfig durabossConfig = this.instanceConfigUtil.getDurabossConfig();
        RestHttpHelper restHelper = new RestHttpHelper(this.getRootCredential());
        String host = this.instance.getHostName();
        this.instanceUpdater.initializeInstance(host, duradminConfig, durastoreConfig, durabossConfig, restHelper);
        this.durabossUpdater.startDuraboss(host, durabossConfig, restHelper);
    }

    private void updateInstance() {
        DuracloudInstance update = (DuracloudInstance)this.repoMgr.getInstanceRepo().findOne((Serializable)this.instance.getId());
        update.setInitialized(true);
        this.repoMgr.getInstanceRepo().save((Object)update);
    }

    private void initializeUserRoles() {
        Set<DuracloudUser> users = this.userFinderUtil.getAccountUsers(this.getAccount());
        this.setUserRoles(users);
    }

    @Override
    public void setUserRoles(Set<DuracloudUser> users) {
        this.log.info("Initializing user roles for account {} at host {}", (Object)this.accountId, (Object)this.instance.getHostName());
        if (null == users) {
            String msg = "arg users is null for instance in acct: " + this.accountId;
            this.log.warn(msg);
            throw new DuracloudInstanceUpdateException(msg);
        }
        DuracloudGroupRepo groupRepo = this.repoMgr.getGroupRepo();
        HashSet groups = new HashSet();
        groups.addAll(groupRepo.findByAccountId(this.accountId));
        HashSet<SecurityUserBean> userBeans = new HashSet<SecurityUserBean>();
        for (DuracloudUser user : users) {
            String username = user.getUsername();
            String password = user.getPassword();
            String email = user.getEmail();
            String ipLimits = this.annotateAddressRange(user.getAllowableIPAddressRange());
            HashSet<Role> roles = user.getRolesByAcct(this.accountId);
            if (roles == null) {
                roles = new HashSet<Role>();
            }
            if (roles.isEmpty()) {
                roles.add(Role.ROLE_USER);
            }
            if (StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password)) {
                StringBuilder msg = new StringBuilder("invalid user: ");
                msg.append(this.accountId + ", ");
                msg.append(username + ", ");
                msg.append(password + ", ");
                msg.append(roles);
                this.log.error(msg.toString());
                throw new DuracloudInstanceUpdateException(msg.toString());
            }
            ArrayList<String> grants = new ArrayList<String>();
            for (Role role : roles) {
                grants.add(role.name());
            }
            if (user.isRoot()) continue;
            SecurityUserBean bean = new SecurityUserBean(username, password, grants);
            bean.setEmail(email);
            bean.setIpLimits(ipLimits);
            if (groups != null) {
                for (DuracloudGroup group : groups) {
                    Set grpUsers = group.getUsers();
                    if (!grpUsers.contains(user)) continue;
                    bean.addGroup(group.getName());
                }
            }
            userBeans.add(bean);
        }
        this.updateUserDetails(userBeans);
    }

    private String annotateAddressRange(String baseRange) {
        if (null == baseRange || baseRange.equals("")) {
            return baseRange;
        }
        String elasticIp = this.getAccount().getServerDetails().getComputeProviderAccount().getElasticIp();
        String delimeter = ";";
        return baseRange + delimeter + elasticIp + "/32";
    }

    private void updateUserDetails(Set<SecurityUserBean> userBeans) {
        RestHttpHelper restHelper = new RestHttpHelper(this.getRootCredential());
        String host = this.instance.getHostName();
        this.instanceUpdater.updateUserDetails(host, userBeans, restHelper);
    }

    private AccountInfo getAccount() {
        if (null == this.accountInfo) {
            this.accountInfo = (AccountInfo)this.repoMgr.getAccountRepo().findOne((Serializable)this.accountId);
        }
        return this.accountInfo;
    }

    private ServerImage getServerImage() {
        return (ServerImage)this.repoMgr.getServerImageRepo().findOne((Serializable)this.instance.getImage().getId());
    }

    private String getStatusFromComputeProvider() throws DuracloudInstanceNotAvailableException {
        return this.computeProvider.getStatus(this.instance.getProviderInstanceId());
    }

    private Credential getRootCredential() {
        if (null == this.rootCredential) {
            ServerImage serverImage = this.getServerImage();
            String rootPassword = serverImage.getDcRootPassword();
            this.rootCredential = new Credential("root", rootPassword);
        }
        return this.rootCredential;
    }

    private void initializeComputeProvider() {
        AccountInfo account = this.getAccount();
        ComputeProviderAccount computeProviderAccount = account.getServerDetails().getComputeProviderAccount();
        this.computeProvider = this.computeProviderUtil.getComputeProvider(computeProviderAccount.getUsername(), computeProviderAccount.getPassword());
    }

    private class ThreadedInitializer
    extends Thread {
        private int timeoutMinutes;
        private InstanceInitListener listener;

        public ThreadedInitializer(int timeoutMinutes, InstanceInitListener listener) {
            this.timeoutMinutes = timeoutMinutes;
            this.listener = listener;
        }

        @Override
        public void run() {
            try {
                InstanceAccessUtilImpl accessUtil = new InstanceAccessUtilImpl();
                accessUtil.waitInstanceAvailable(DuracloudInstanceServiceImpl.this.instance.getHostName(), this.timeoutMinutes * 60000);
            }
            catch (Exception e) {
                this.logInitException(e);
            }
            this.retryInitialize();
        }

        public void retryInitialize() {
            for (int i = 0; i < 10; ++i) {
                this.wait(i * 60000);
                try {
                    DuracloudInstanceServiceImpl.this.doInitialize(false);
                    return;
                }
                catch (DuraCloudRuntimeException ex) {
                    this.logInitException((Exception)((Object)ex));
                    continue;
                }
            }
            this.listener.handleInstanceInitFailure();
        }

        private void logInitException(Exception e) {
            DuracloudInstanceServiceImpl.this.log.warn("Exception encountered attempting to initialize instance: " + e.getMessage(), (Throwable)e);
        }

        private void wait(int milliseconds) {
            try {
                ThreadedInitializer.sleep(milliseconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

