/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.duracloud.account.compute.error.DuracloudInstanceNotAvailableException;
import org.duracloud.account.db.model.DuracloudInstance;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.InstanceType;
import org.duracloud.account.db.util.DuracloudInstanceService;
import org.duracloud.account.db.util.error.AccessDeniedException;
import org.duracloud.account.db.util.security.AnnotationParser;
import org.duracloud.account.db.util.security.impl.MethodInvocationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.core.Authentication;

public class DuracloudInstanceServiceSecuredImpl
implements DuracloudInstanceService {
    private Logger log = LoggerFactory.getLogger(DuracloudInstanceServiceSecuredImpl.class);
    private DuracloudInstanceService instanceService;
    private Authentication authentication;
    private AccessDecisionVoter voter;
    private Map<String, Object[]> methodMap;

    public DuracloudInstanceServiceSecuredImpl(DuracloudInstanceService instanceService, Authentication authentication, AccessDecisionVoter voter, AnnotationParser annotationParser) {
        this.instanceService = instanceService;
        this.authentication = authentication;
        this.voter = voter;
        this.methodMap = annotationParser.getMethodAnnotationsForClass(Secured.class, this.getClass());
    }

    private void throwIfAccessDenied(Object ... args) {
        String methodName = this.getCurrentMethodName();
        HashSet<SecurityConfig> configAtts = new HashSet<SecurityConfig>();
        for (Object obj : this.methodMap.get(methodName)) {
            configAtts.add(new SecurityConfig((String)obj));
        }
        MethodInvocationImpl invocation = new MethodInvocationImpl(this, methodName, args);
        int decision = this.voter.vote(this.authentication, (Object)invocation, configAtts);
        if (decision != 1) {
            throw new AccessDeniedException("Access denied");
        }
    }

    private String getCurrentMethodName() {
        return Thread.currentThread().getStackTrace()[3].getMethodName();
    }

    @Override
    public Long getAccountId() {
        this.throwIfAccessDenied(new Object[0]);
        return this.instanceService.getAccountId();
    }

    @Override
    public DuracloudInstance getInstanceInfo() {
        this.throwIfAccessDenied(new Object[0]);
        return this.instanceService.getInstanceInfo();
    }

    @Override
    public String getInstanceVersion() {
        this.throwIfAccessDenied(new Object[0]);
        return this.instanceService.getInstanceVersion();
    }

    @Override
    public String getStatus() throws DuracloudInstanceNotAvailableException {
        this.throwIfAccessDenied(new Object[0]);
        return this.instanceService.getStatus();
    }

    @Override
    public String getStatusInternal() throws DuracloudInstanceNotAvailableException {
        return this.instanceService.getStatusInternal();
    }

    @Override
    public void stop() {
        this.throwIfAccessDenied(new Object[0]);
        this.instanceService.stop();
    }

    @Override
    public void restart() {
        this.throwIfAccessDenied(new Object[0]);
        this.instanceService.restart();
    }

    @Override
    public void initialize() {
        this.throwIfAccessDenied(new Object[0]);
        this.instanceService.initialize();
    }

    @Override
    public void reInitializeUserRoles() {
        this.throwIfAccessDenied(new Object[0]);
        this.instanceService.reInitializeUserRoles();
    }

    @Override
    public void reInitialize() {
        this.throwIfAccessDenied(new Object[0]);
        this.instanceService.reInitialize();
    }

    @Override
    public void setUserRoles(Set<DuracloudUser> users) {
        this.throwIfAccessDenied(users);
        this.instanceService.setUserRoles(users);
    }

    @Override
    public InstanceType getInstanceType() throws DuracloudInstanceNotAvailableException {
        this.throwIfAccessDenied(new Object[0]);
        return this.instanceService.getInstanceType();
    }
}

