/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.DuracloudGroup;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.util.DuracloudGroupService;
import org.duracloud.account.db.util.error.DuracloudGroupAlreadyExistsException;
import org.duracloud.account.db.util.error.DuracloudGroupNotFoundException;
import org.duracloud.account.db.util.error.InvalidGroupNameException;
import org.duracloud.account.db.util.usermgmt.UserDetailsPropagator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuracloudGroupServiceImpl
implements DuracloudGroupService {
    private Logger log = LoggerFactory.getLogger(DuracloudGroupServiceImpl.class);
    private DuracloudRepoMgr repoMgr;
    private UserDetailsPropagator propagator;

    public DuracloudGroupServiceImpl(DuracloudRepoMgr duracloudRepoMgr, UserDetailsPropagator propagator) {
        this.repoMgr = duracloudRepoMgr;
        this.propagator = propagator;
    }

    @Override
    public Set<DuracloudGroup> getGroups(Long acctId) {
        List listGroups = this.repoMgr.getGroupRepo().findByAccountId(acctId);
        HashSet groups = new HashSet();
        groups.addAll(listGroups);
        return Collections.unmodifiableSet(groups);
    }

    @Override
    public DuracloudGroup getGroup(String name, Long acctId) {
        return this.repoMgr.getGroupRepo().findByNameAndAccountId(name, acctId);
    }

    @Override
    public DuracloudGroup createGroup(String name, Long acctId) throws DuracloudGroupAlreadyExistsException, InvalidGroupNameException {
        if (!this.isGroupNameValid(name)) {
            throw new InvalidGroupNameException(name);
        }
        if (this.groupExistsInAccount(name, acctId)) {
            throw new DuracloudGroupAlreadyExistsException(name);
        }
        AccountInfo accountInfo = (AccountInfo)this.repoMgr.getAccountRepo().findOne((Serializable)acctId);
        DuracloudGroup group = new DuracloudGroup();
        group.setName(name);
        group.setAccount(accountInfo);
        group = (DuracloudGroup)this.repoMgr.getGroupRepo().save((Object)group);
        return group;
    }

    protected final boolean isGroupNameValid(String name) {
        if (name == null) {
            return false;
        }
        if (!name.startsWith("group-")) {
            return false;
        }
        if ("group-public".equalsIgnoreCase(name)) {
            return false;
        }
        return name.substring("group-".length()).matches("\\A(?![_.@\\-])[a-z0-9_.@\\-]+(?<![_.@\\-])\\Z");
    }

    private boolean groupExistsInAccount(String name, Long acctId) {
        DuracloudGroup group = this.getGroup(name, acctId);
        return group != null;
    }

    @Override
    public void deleteGroup(DuracloudGroup group, Long acctId) {
        if (null == group) {
            this.log.warn("Arg group is null.");
            return;
        }
        this.repoMgr.getGroupRepo().delete((Serializable)group.getId());
        this.propagateUpdate(acctId, group);
    }

    @Override
    public void updateGroupUsers(DuracloudGroup group, Set<DuracloudUser> users, Long acctId) throws DuracloudGroupNotFoundException {
        group.setUsers(users);
        this.repoMgr.getGroupRepo().save((Object)group);
        this.propagateUpdate(acctId, group);
    }

    private void propagateUpdate(Long acctId, DuracloudGroup group) {
        this.propagator.propagateGroupUpdate(acctId, group.getId());
    }
}

