/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.duracloud.account.config.AmaEndpoint;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.AccountRights;
import org.duracloud.account.db.model.ComputeProviderAccount;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.ServerDetails;
import org.duracloud.account.db.model.StorageProviderAccount;
import org.duracloud.account.db.model.UserInvitation;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.repo.DuracloudRightsRepo;
import org.duracloud.account.db.util.AccountService;
import org.duracloud.account.db.util.error.DuracloudProviderAccountNotAvailableException;
import org.duracloud.account.db.util.error.UnsentEmailException;
import org.duracloud.account.db.util.impl.InvitationMessageFormatter;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.notification.Emailer;
import org.duracloud.storage.domain.StorageProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountServiceImpl
implements AccountService {
    private Logger log = LoggerFactory.getLogger(AccountServiceImpl.class);
    private AccountInfo account;
    private DuracloudRepoMgr repoMgr;
    private AmaEndpoint amaEndpoint;

    public AccountServiceImpl(AmaEndpoint amaEndpoint, AccountInfo acct, DuracloudRepoMgr repoMgr) {
        this.amaEndpoint = amaEndpoint;
        this.account = acct;
        this.repoMgr = repoMgr;
    }

    @Override
    public Set<DuracloudUser> getUsers() {
        DuracloudRightsRepo rightsRepo = this.repoMgr.getRightsRepo();
        HashSet<DuracloudUser> users = new HashSet<DuracloudUser>();
        List rights = rightsRepo.findByAccountId(this.account.getId());
        for (AccountRights right : rights) {
            DuracloudUser user = right.getUser();
            user.getAccountRights().size();
            users.add(user);
        }
        return users;
    }

    @Override
    public Long getAccountId() {
        return this.account.getId();
    }

    @Override
    public AccountInfo retrieveAccountInfo() {
        return this.account;
    }

    @Override
    public ServerDetails retrieveServerDetails() {
        return this.account.getServerDetails();
    }

    @Override
    public void storeServerDetails(ServerDetails serverDetails) {
        this.repoMgr.getServerDetailsRepo().save((Object)serverDetails);
    }

    @Override
    public StorageProviderAccount getPrimaryStorageProvider() {
        ServerDetails serverDetails = this.retrieveServerDetails();
        return serverDetails.getPrimaryStorageProviderAccount();
    }

    @Override
    public ComputeProviderAccount getComputeProvider() {
        ServerDetails serverDetails = this.retrieveServerDetails();
        return serverDetails.getComputeProviderAccount();
    }

    @Override
    public Set<StorageProviderAccount> getSecondaryStorageProviders() {
        ServerDetails serverDetails = this.retrieveServerDetails();
        return serverDetails.getSecondaryStorageProviderAccounts();
    }

    @Override
    public void addStorageProvider(StorageProviderType storageProviderType) {
        this.log.info("Adding storage provider of type {} to account {}", (Object)storageProviderType, (Object)this.account.getSubdomain());
        StorageProviderAccount storageProviderAccount = new StorageProviderAccount();
        storageProviderAccount.setProviderType(storageProviderType);
        ServerDetails serverDetails = this.retrieveServerDetails();
        serverDetails.getSecondaryStorageProviderAccounts().add(storageProviderAccount);
        this.storeServerDetails(serverDetails);
    }

    @Override
    public void removeStorageProvider(Long storageProviderId) {
        this.log.info("Removing storage provider with ID {} from account {}", (Object)storageProviderId, (Object)this.account.getSubdomain());
        ServerDetails serverDetails = this.retrieveServerDetails();
        StorageProviderAccount storageProviderAccount = (StorageProviderAccount)this.repoMgr.getStorageProviderAccountRepo().findOne((Serializable)storageProviderId);
        if (!serverDetails.getSecondaryStorageProviderAccounts().remove(storageProviderAccount)) {
            throw new DuracloudProviderAccountNotAvailableException("The storage provider account with ID " + storageProviderId + " is not associated with account with id " + this.account.getId() + " as a secondary storage provider.");
        }
        this.storeServerDetails(serverDetails);
        this.repoMgr.getStorageProviderAccountRepo().delete((Serializable)storageProviderId);
    }

    @Override
    public void changePrimaryStorageProvider(Long storageProviderId) {
        this.log.info("Changing primary storage provider to {} from account {}", (Object)storageProviderId, (Object)this.account.getSubdomain());
        ServerDetails serverDetails = this.retrieveServerDetails();
        Set secondaryAccounts = serverDetails.getSecondaryStorageProviderAccounts();
        for (StorageProviderAccount secondary : secondaryAccounts) {
            if (!secondary.getId().equals(storageProviderId)) continue;
            secondaryAccounts.remove(secondary);
            secondaryAccounts.add(serverDetails.getPrimaryStorageProviderAccount());
            serverDetails.setPrimaryStorageProviderAccount(secondary);
            serverDetails.setSecondaryStorageProviderAccounts(secondaryAccounts);
            this.storeServerDetails(serverDetails);
            return;
        }
        throw new DuracloudProviderAccountNotAvailableException("The storage provider account with ID " + storageProviderId + " is not associated with account with id " + this.account.getId() + " as a secondary storage provider.");
    }

    @Override
    public void storeAccountInfo(String acctName, String orgName, String department) {
        Object[] logInfo = new String[]{this.account.getSubdomain(), acctName, orgName, department};
        this.log.info("Updating info for account {}. Account Name: {}, Org Name: {}, Department: {}", logInfo);
        this.account.setAcctName(acctName);
        this.account.setOrgName(orgName);
        this.account.setDepartment(department);
        this.repoMgr.getAccountRepo().save((Object)this.account);
    }

    @Override
    public void storeAccountStatus(AccountInfo.AccountStatus status) {
        this.log.info("Updating account status to {} for account {}", (Object)status.name(), (Object)this.account.getSubdomain());
        this.account.setStatus(status);
        this.repoMgr.getAccountRepo().save((Object)this.account);
    }

    @Override
    public void storeSubdomain(String subdomain) {
    }

    @Override
    public String getSubdomain() {
        return this.account.getSubdomain();
    }

    @Override
    public UserInvitation inviteUser(String emailAddress, String adminUsername, Emailer emailer) {
        this.log.info("Inviting user at address {} to account {}", (Object)emailAddress, (Object)this.account.getSubdomain());
        ChecksumUtil cksumUtil = new ChecksumUtil(ChecksumUtil.Algorithm.MD5);
        String code = emailAddress + System.currentTimeMillis();
        String redemptionCode = cksumUtil.generateChecksum(code);
        int expirationDays = 14;
        UserInvitation userInvitation = new UserInvitation(null, this.account, this.account.getAcctName(), this.account.getOrgName(), this.account.getDepartment(), this.account.getSubdomain(), adminUsername, emailAddress, expirationDays, redemptionCode);
        this.repoMgr.getUserInvitationRepo().save((Object)userInvitation);
        this.sendEmail(userInvitation, emailer);
        return userInvitation;
    }

    private void sendEmail(UserInvitation invitation, Emailer emailer) {
        try {
            InvitationMessageFormatter formatter = new InvitationMessageFormatter(invitation, this.amaEndpoint);
            emailer.send(formatter.getSubject(), formatter.getBody(), new String[]{invitation.getUserEmail()});
        }
        catch (Exception e) {
            String msg = "Error: Unable to send email to: " + invitation.getUserEmail();
            this.log.error(msg, (Throwable)e);
            throw new UnsentEmailException(msg, e);
        }
    }

    @Override
    public Set<UserInvitation> getPendingInvitations() {
        List invitations = this.repoMgr.getUserInvitationRepo().findByAccountId(this.account.getId());
        Date now = new Date();
        HashSet<UserInvitation> pendingInvitations = new HashSet<UserInvitation>();
        for (UserInvitation ui : invitations) {
            if (ui.getExpirationDate().before(now)) {
                this.repoMgr.getUserInvitationRepo().delete((Serializable)ui.getId());
                continue;
            }
            pendingInvitations.add(ui);
        }
        return pendingInvitations;
    }

    @Override
    public void deleteUserInvitation(Long invitationId) {
        this.log.info("Deleting user invitation with id {} from account {}", (Object)invitationId, (Object)this.account.getSubdomain());
        this.repoMgr.getUserInvitationRepo().delete((Serializable)invitationId);
    }
}

