/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.AccountRights;
import org.duracloud.account.db.model.DuracloudGroup;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.StorageProviderAccount;
import org.duracloud.account.db.repo.DuracloudAccountRepo;
import org.duracloud.account.db.repo.DuracloudGroupRepo;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.repo.DuracloudRightsRepo;
import org.duracloud.account.db.repo.DuracloudStorageProviderAccountRepo;
import org.duracloud.account.db.repo.DuracloudUserInvitationRepo;
import org.duracloud.account.db.repo.DuracloudUserRepo;
import org.duracloud.account.db.util.DuracloudUserService;
import org.duracloud.account.db.util.RootAccountManagerService;
import org.duracloud.account.db.util.error.DBNotFoundException;
import org.duracloud.account.db.util.error.InvalidPasswordException;
import org.duracloud.account.db.util.error.UnsentEmailException;
import org.duracloud.common.sns.AccountChangeNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component(value="rootAccountManagerService")
public class RootAccountManagerServiceImpl
implements RootAccountManagerService {
    private Logger log = LoggerFactory.getLogger(RootAccountManagerServiceImpl.class);
    private DuracloudRepoMgr repoMgr;
    private DuracloudUserService userService;
    private AccountChangeNotifier accountChangeNotifier;

    @Autowired
    public RootAccountManagerServiceImpl(DuracloudRepoMgr duracloudRepoMgr, DuracloudUserService userService, AccountChangeNotifier accountChangeNotifier) {
        this.repoMgr = duracloudRepoMgr;
        this.userService = userService;
        this.accountChangeNotifier = accountChangeNotifier;
    }

    @Override
    public void resetUsersPassword(Long userId) throws DBNotFoundException, UnsentEmailException {
        this.log.info("Resetting password for user with ID {}", (Object)userId);
        DuracloudUser user = (DuracloudUser)this.getUserRepo().findOne((Serializable)userId);
        if (user == null) {
            throw new DBNotFoundException("User with ID: " + userId + " does not exist");
        }
        try {
            this.userService.forgotPassword(user.getUsername(), user.getSecurityQuestion(), user.getSecurityAnswer());
        }
        catch (InvalidPasswordException e) {
            this.log.error("This should never happen!", (Throwable)((Object)e));
        }
    }

    @Override
    public void deleteUser(Long userId) {
        this.log.info("Deleting user with ID {}", (Object)userId);
        List accountRights = this.getRightsRepo().findByUserId(userId);
        for (AccountRights right : accountRights) {
            this.userService.revokeUserRights(right.getAccount().getId(), userId);
        }
        DuracloudUser user = (DuracloudUser)this.repoMgr.getUserRepo().findOne((Serializable)userId);
        DuracloudGroupRepo groupRepo = this.getGroupRepo();
        List allGroups = groupRepo.findAll();
        for (DuracloudGroup group : allGroups) {
            Set groupUsers = group.getUsers();
            if (!groupUsers.contains(user)) continue;
            groupUsers.remove(user);
            groupRepo.save((Object)group);
        }
        this.getUserRepo().delete((Serializable)userId);
        this.notifyUserChange(accountRights);
    }

    @Override
    public void setRootUser(Long userId) {
        this.log.info("Setting root on user with ID {}", (Object)userId);
        DuracloudUser user = (DuracloudUser)this.repoMgr.getUserRepo().findOne((Serializable)userId);
        user.setRoot(true);
        List accountRights = this.getRightsRepo().findByUserId(userId);
        this.notifyUserChange(accountRights);
    }

    @Override
    public void unsetRootUser(Long userId) {
        this.log.info("Unsetting root on user with ID {}", (Object)userId);
        DuracloudUser user = (DuracloudUser)this.repoMgr.getUserRepo().findOne((Serializable)userId);
        user.setRoot(false);
        List accountRights = this.getRightsRepo().findByUserId(userId);
        this.notifyUserChange(accountRights);
    }

    private void notifyUserChange(List<AccountRights> accountRights) {
        for (AccountRights right : accountRights) {
            try {
                this.accountChangeNotifier.userStoreChanged(right.getAccount().getSubdomain());
            }
            catch (Exception ex) {
                this.log.error("failed to notify of user change: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void notifyAccountChange(List<AccountRights> accountRights) {
        for (AccountRights right : accountRights) {
            try {
                this.accountChangeNotifier.accountChanged(right.getAccount().getSubdomain());
            }
            catch (Exception ex) {
                this.log.error("failed to notify of account change: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private AccountInfo getAccountByStorageProvider(Long providerId) {
        DuracloudAccountRepo accountRepo = this.repoMgr.getAccountRepo();
        AccountInfo account = accountRepo.findByPrimaryStorageProviderAccountId(providerId);
        if (account == null) {
            account = accountRepo.findBySecondaryStorageProviderAccountsId(providerId);
        }
        return account;
    }

    private void notifyStorageProviderChange(String accountId) {
        this.accountChangeNotifier.storageProvidersChanged(accountId);
    }

    @Override
    public void deleteAccount(Long accountId) {
        this.log.info("Deleting account with ID {}", (Object)accountId);
        List rightsList = this.getRightsRepo().findByAccountId(accountId);
        for (AccountRights rights : rightsList) {
            DuracloudUser user = rights.getUser();
            user.getAccountRights().remove(rights);
            rights.getRoles().clear();
            this.getRightsRepo().save((Object)rights);
        }
        this.getRightsRepo().deleteInBatch((Iterable)rightsList);
        DuracloudGroupRepo groupRepo = this.repoMgr.getGroupRepo();
        List groups = groupRepo.findByAccountId(accountId);
        groupRepo.deleteInBatch((Iterable)groups);
        DuracloudUserInvitationRepo invRepo = this.repoMgr.getUserInvitationRepo();
        invRepo.deleteInBatch((Iterable)invRepo.findByAccountId(accountId));
        this.getAccountRepo().delete((Serializable)accountId);
        this.notifyAccountChange(rightsList);
    }

    @Override
    public List<StorageProviderAccount> getSecondaryStorageProviders(Long accountId) {
        AccountInfo account = (AccountInfo)this.repoMgr.getAccountRepo().findOne((Serializable)accountId);
        return new ArrayList<StorageProviderAccount>(account.getSecondaryStorageProviderAccounts());
    }

    @Override
    public void setupStorageProvider(Long providerId, String username, String password, Map<String, String> properties, int storageLimit) {
        this.log.info("Setting up storage provider with ID {}", (Object)providerId);
        StorageProviderAccount storageProviderAccount = (StorageProviderAccount)this.getStorageRepo().findOne((Serializable)providerId);
        storageProviderAccount.setUsername(username);
        storageProviderAccount.setPassword(password);
        storageProviderAccount.getProperties().putAll(properties);
        storageProviderAccount.setStorageLimit(storageLimit);
        this.getStorageRepo().save((Object)storageProviderAccount);
        this.notifyStorageProviderChange(this.getAccountByStorageProvider(providerId).getSubdomain());
    }

    @Override
    public AccountInfo getAccount(Long id) {
        return (AccountInfo)this.getAccountRepo().findOne((Serializable)id);
    }

    @Override
    public void activateAccount(Long accountId) {
        this.log.info("Activating account with ID {}", (Object)accountId);
        AccountInfo accountInfo = (AccountInfo)this.getAccountRepo().findOne((Serializable)accountId);
        accountInfo.setStatus(AccountInfo.AccountStatus.ACTIVE);
        this.getAccountRepo().save((Object)accountInfo);
        this.accountChangeNotifier.accountChanged(accountInfo.getSubdomain());
    }

    @Override
    public Set<AccountInfo> listAllAccounts(String filter) {
        List accounts = this.getAccountRepo().findAll(new Sort(new String[]{"acctName"}));
        LinkedHashSet<AccountInfo> accountInfos = new LinkedHashSet<AccountInfo>();
        for (AccountInfo acct : accounts) {
            if (filter != null && !acct.getOrgName().startsWith(filter)) continue;
            accountInfos.add(acct);
        }
        return accountInfos;
    }

    @Override
    public Set<DuracloudUser> listAllUsers(String filter) {
        List usersList = this.getUserRepo().findAll(new Sort(new String[]{"username"}));
        LinkedHashSet<DuracloudUser> users = new LinkedHashSet<DuracloudUser>();
        for (DuracloudUser user : usersList) {
            if (filter != null && !user.getUsername().startsWith(filter) && !user.getFirstName().startsWith(filter) && !user.getLastName().startsWith(filter) && !user.getEmail().startsWith(filter)) continue;
            users.add(user);
        }
        return users;
    }

    @Override
    public Set<DuracloudUser> listAllRootUsers(String filter) {
        List usersList = this.getUserRepo().findAll(new Sort(new String[]{"username"}));
        LinkedHashSet<DuracloudUser> users = new LinkedHashSet<DuracloudUser>();
        for (DuracloudUser user : usersList) {
            if (!user.isRoot() || filter != null && !user.getUsername().startsWith(filter) && !user.getFirstName().startsWith(filter) && !user.getLastName().startsWith(filter) && !user.getEmail().startsWith(filter)) continue;
            users.add(user);
        }
        return users;
    }

    private DuracloudUserRepo getUserRepo() {
        return this.repoMgr.getUserRepo();
    }

    private DuracloudGroupRepo getGroupRepo() {
        return this.repoMgr.getGroupRepo();
    }

    private DuracloudAccountRepo getAccountRepo() {
        return this.repoMgr.getAccountRepo();
    }

    private DuracloudRightsRepo getRightsRepo() {
        return this.repoMgr.getRightsRepo();
    }

    private DuracloudStorageProviderAccountRepo getStorageRepo() {
        return this.repoMgr.getStorageProviderAccountRepo();
    }
}

