/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.util.impl;

import org.duracloud.account.config.AmaEndpoint;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.repo.DuracloudRepoMgr;
import org.duracloud.account.db.util.AccountService;
import org.duracloud.account.db.util.AccountServiceFactory;
import org.duracloud.account.db.util.EmailTemplateService;
import org.duracloud.account.db.util.error.AccountNotFoundException;
import org.duracloud.account.db.util.impl.AccountServiceImpl;
import org.duracloud.account.db.util.impl.AccountServiceSecuredImpl;
import org.duracloud.account.db.util.notification.NotificationMgr;
import org.duracloud.account.db.util.security.AnnotationParser;
import org.duracloud.account.db.util.security.SecurityContextUtil;
import org.duracloud.common.changenotifier.AccountChangeNotifier;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.error.NoUserLoggedInException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="accountServiceFactory")
public class AccountServiceFactoryImpl
implements AccountServiceFactory {
    private final Logger log = LoggerFactory.getLogger(AccountServiceFactoryImpl.class);
    private final DuracloudRepoMgr repoMgr;
    private final AccessDecisionVoter voter;
    private final SecurityContextUtil securityContext;
    private final AnnotationParser annotationParser;
    private final AmaEndpoint amaEndpoint;
    private final AccountChangeNotifier accountChangeNotifier;
    private final NotificationMgr notificationMgr;
    private final EmailTemplateService emailTemplateService;

    @Autowired
    public AccountServiceFactoryImpl(DuracloudRepoMgr repoMgr, @Qualifier(value="acctVoter") AccessDecisionVoter voter, SecurityContextUtil securityContext, AnnotationParser annotationParser, AmaEndpoint amaEndpoint, AccountChangeNotifier accountChangeNotifier, NotificationMgr notificationMgr, EmailTemplateService emailTemplateService) {
        this.repoMgr = repoMgr;
        this.voter = voter;
        this.securityContext = securityContext;
        this.annotationParser = annotationParser;
        this.amaEndpoint = amaEndpoint;
        this.accountChangeNotifier = accountChangeNotifier;
        this.notificationMgr = notificationMgr;
        this.emailTemplateService = emailTemplateService;
    }

    @Override
    public AccountService getAccount(Long acctId) throws AccountNotFoundException {
        AccountInfo acctInfo = (AccountInfo)this.repoMgr.getAccountRepo().findById((Object)acctId).orElseThrow(() -> new AccountNotFoundException(acctId));
        return this.getAccount(acctInfo);
    }

    @Override
    public AccountService getAccount(AccountInfo acctInfo) {
        AccountServiceImpl acctService = new AccountServiceImpl(this.amaEndpoint, acctInfo, this.repoMgr, this.accountChangeNotifier, this.notificationMgr, this.emailTemplateService);
        Authentication authentication = this.getAuthentication();
        return new AccountServiceSecuredImpl(acctService, authentication, this.voter, this.annotationParser);
    }

    private Authentication getAuthentication() {
        try {
            return this.securityContext.getAuthentication();
        }
        catch (NoUserLoggedInException e) {
            this.log.warn("No user found in security context.");
            throw new DuraCloudRuntimeException((Throwable)e);
        }
    }
}

