/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import org.duracloud.account.app.controller.AbstractAccountController;
import org.duracloud.account.app.controller.GroupForm;
import org.duracloud.account.app.controller.GroupsForm;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.DuracloudGroup;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.util.AccountService;
import org.duracloud.account.db.util.DuracloudGroupService;
import org.duracloud.account.db.util.error.DuracloudGroupAlreadyExistsException;
import org.duracloud.account.db.util.error.DuracloudGroupNotFoundException;
import org.duracloud.account.db.util.error.InvalidGroupNameException;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@Lazy
public class AccountGroupsController
extends AbstractAccountController {
    protected static final String AVAILABLE_USERS_KEY = "availableUsers";
    protected static final String GROUPS_VIEW_ID = "account-groups";
    protected static final String GROUP_VIEW_ID = "account-group";
    protected static final String GROUP_EDIT_VIEW_ID = "account-group-edit";
    protected static final String GROUPS_FORM_KEY = "groupsForm";
    protected static final String GROUP_FORM_KEY = "groupForm";
    protected static String GROUP_USERS_KEY = "groupUsers";
    protected static String GROUP_NAME_KEY = "groupName";
    protected static String GROUP_KEY = "group";
    protected static final String GROUPS_PATH = "/byid/{accountId}/groups";
    protected static final String GROUP_PATH = "/byid/{accountId}/groups/{groupName:[a-z0-9._\\-@]+}";
    protected static final String GROUP_EDIT_PATH = "/byid/{accountId}/groups/{groupName:[a-z0-9._\\-@]+}/edit";
    private static final String GROUP_NAME_RESERVED_ERROR_CODE = "error.groupName.reserved";
    private static final String GROUP_NAME_INVALID_ERROR_CODE = "error.groupName.invalid";
    private static final String GROUP_NAME_EXISTS_ERROR_CODE = "error.groupName.exists";
    private static final String GROUP_NAME_RESERVED_MESSAGE = "The group name you specified is a reserved name. Please try another.";
    private static final String GROUP_NAME_INVALID_MESSAGE = "Group names can contain only lowercase letters, numbers, '.', '@','-', or '_' and must start and end only with letters or numbers.";
    private static final String GROUP_NAME_EXISTS_MESSAGE = "This group already exists. Please choose another name.";
    @Autowired
    protected DuracloudGroupService duracloudGroupService;
    private static Comparator<DuracloudUser> USERNAME_COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;

    @RequestMapping(value={"/byid/{accountId}/groups"}, method={RequestMethod.GET})
    public String getGroups(@PathVariable Long accountId, Model model) throws Exception {
        this.addGroupsObjectsToModel(this.getAccountService(accountId), model);
        return GROUPS_VIEW_ID;
    }

    @RequestMapping(value={"/byid/{accountId}/groups"}, method={RequestMethod.POST})
    @Transactional
    public String modifyGroups(@PathVariable Long accountId, Model model, @ModelAttribute(value="groupsForm") @Valid GroupsForm form, BindingResult result) throws Exception {
        AccountService as = this.accountManagerService.getAccount(accountId);
        GroupsForm.Action action = form.getAction();
        if (action == GroupsForm.Action.ADD) {
            String name = form.getGroupName();
            String groupName = "group-" + name;
            try {
                this.duracloudGroupService.createGroup(groupName, accountId);
            }
            catch (InvalidGroupNameException e) {
                if (groupName.equalsIgnoreCase("group-public")) {
                    result.rejectValue(GROUP_NAME_KEY, GROUP_NAME_RESERVED_ERROR_CODE, GROUP_NAME_RESERVED_MESSAGE);
                } else {
                    result.rejectValue(GROUP_NAME_KEY, GROUP_NAME_INVALID_ERROR_CODE, GROUP_NAME_INVALID_MESSAGE);
                }
            }
            catch (DuracloudGroupAlreadyExistsException e) {
                result.rejectValue(GROUP_NAME_KEY, GROUP_NAME_EXISTS_ERROR_CODE, GROUP_NAME_EXISTS_MESSAGE);
            }
            if (!result.hasFieldErrors()) {
                return this.formatGroupRedirect(accountId, groupName, "/edit");
            }
        } else {
            String[] groups = form.getGroupNames();
            if (groups != null) {
                for (String name : groups) {
                    DuracloudGroup group = this.duracloudGroupService.getGroup(name, accountId);
                    this.removeGroup(group, accountId);
                }
            }
        }
        this.addGroupsObjectsToModel(as, model);
        return GROUPS_VIEW_ID;
    }

    @RequestMapping(value={"/byid/{accountId}/groups/{groupName:[a-z0-9._\\-@]+}"}, method={RequestMethod.GET})
    public String getGroup(@PathVariable Long accountId, @PathVariable String groupName, Model model) throws Exception {
        this.addUserToModel(model);
        model.addAttribute(GROUPS_FORM_KEY, (Object)new GroupsForm());
        AccountService as = this.getAccountService(accountId);
        List groups = this.getGroups(accountId);
        DuracloudGroup group = this.getGroup(groupName, groups);
        this.addGroupToModel(group, model);
        this.addGroupsObjectsToModel(as, groups, model);
        return GROUP_VIEW_ID;
    }

    private List<DuracloudGroup> getGroups(Long accountId) {
        Set set = this.duracloudGroupService.getGroups(accountId);
        LinkedList<DuracloudGroup> list = new LinkedList<DuracloudGroup>();
        if (set != null) {
            list.addAll(set);
        }
        return list;
    }

    @RequestMapping(value={"/byid/{accountId}/groups/{groupName:[a-z0-9._\\-@]+}/edit"}, method={RequestMethod.GET})
    public String editGroup(@PathVariable Long accountId, @PathVariable String groupName, HttpServletRequest request, Model model) throws Exception {
        AccountService as = this.getAccountService(accountId);
        List groups = this.getGroups(accountId);
        this.addGroupsObjectsToModel(as, groups, model);
        DuracloudGroup group = this.getGroup(groupName, groups);
        this.addGroupToModel(group, model);
        model.addAttribute(GROUP_FORM_KEY, (Object)new GroupForm());
        Set groupUsers = group.getUsers();
        this.addAvailableUsersToModel(as, (Collection)groupUsers, model);
        HttpSession session = request.getSession();
        session.removeAttribute(GROUP_USERS_KEY);
        this.addGroupUsersIfNotAlreadyInSession(group, model, session);
        return GROUP_EDIT_VIEW_ID;
    }

    @RequestMapping(value={"/byid/{accountId}/groups/{groupName:[a-z0-9._\\-@]+}/edit"}, method={RequestMethod.POST})
    @Transactional
    public String editGroup(@PathVariable Long accountId, @PathVariable String groupName, @ModelAttribute(value="groupForm") @Valid GroupForm form, HttpServletRequest request, Model model) throws Exception {
        GroupForm.Action action = form.getAction();
        AccountService as = this.getAccountService(accountId);
        List groups = this.getGroups(accountId);
        DuracloudGroup group = this.getGroup(groupName, groups);
        this.addGroupToModel(group, model);
        HttpSession session = request.getSession();
        List groupUsers = this.addGroupUsersIfNotAlreadyInSession(group, model, session);
        if (action == GroupForm.Action.SAVE) {
            HashSet users = new HashSet(groupUsers);
            this.save(group, users, accountId, form);
            session.removeAttribute(GROUP_USERS_KEY);
            return this.formatGroupRedirect(accountId, groupName, null);
        }
        Collection availableUsers = this.getAvailableUsers(as, (Collection)groupUsers);
        if (action == GroupForm.Action.ADD) {
            String[] availableUsernames = form.getAvailableUsernames();
            if (availableUsernames != null) {
                for (String username : availableUsernames) {
                    DuracloudUser user = this.getUser(username, availableUsers);
                    if (user == null) continue;
                    groupUsers.add(user);
                }
                form.setAvailableUsernames(null);
                form.setGroupUsernames(availableUsernames);
            }
        } else if (action == GroupForm.Action.REMOVE) {
            String[] groupUsernames = form.getGroupUsernames();
            if (groupUsernames != null) {
                for (String username : groupUsernames) {
                    DuracloudUser user = this.getUser(username, (Collection)groupUsers);
                    if (user == null) continue;
                    groupUsers.remove(user);
                    availableUsers.add(user);
                }
                form.setGroupUsernames(null);
                form.setAvailableUsernames(groupUsernames);
            }
        } else {
            throw new DuraCloudRuntimeException("[" + action + "] not supported.");
        }
        model.addAttribute(GROUP_FORM_KEY, (Object)form);
        this.addAvailableUsersToModel(availableUsers, (Collection)groupUsers, model);
        this.addGroupsObjectsToModel(as, groups, model);
        return GROUP_EDIT_VIEW_ID;
    }

    private String formatGroupRedirect(Long accountId, String groupName, String suffix) {
        String redirect = "redirect:/accounts/byid/{accountId}/groups/{groupName:[a-z0-9._\\-@]+}";
        redirect = redirect.replace("{accountId}", String.valueOf(accountId));
        redirect = redirect.replaceAll("\\{groupName.*\\}", String.valueOf(groupName));
        redirect = redirect + (suffix != null ? suffix : "");
        return redirect;
    }

    private void addAvailableUsersToModel(Collection<DuracloudUser> allUsers, Collection<DuracloudUser> groupUsers, Model model) {
        if (allUsers != null && groupUsers != null) {
            allUsers.removeAll(groupUsers);
        }
        model.addAttribute(AVAILABLE_USERS_KEY, allUsers);
    }

    private DuracloudUser getUser(String username, Collection<DuracloudUser> users) {
        for (DuracloudUser user : users) {
            if (!user.getUsername().equals(username)) continue;
            return user;
        }
        return null;
    }

    private List<DuracloudUser> addGroupUsersIfNotAlreadyInSession(DuracloudGroup group, Model model, HttpSession session) {
        LinkedList<DuracloudUser> groupUsers = (LinkedList<DuracloudUser>)session.getAttribute(GROUP_USERS_KEY);
        if (groupUsers == null) {
            groupUsers = new LinkedList<DuracloudUser>();
            groupUsers.addAll(group.getUsers());
            Collections.sort(groupUsers, USERNAME_COMPARATOR);
            session.setAttribute(GROUP_USERS_KEY, groupUsers);
        }
        model.addAttribute(GROUP_USERS_KEY, groupUsers);
        return groupUsers;
    }

    private void save(DuracloudGroup group, Set<DuracloudUser> groupUsers, Long accountId, GroupForm form) throws DuracloudGroupNotFoundException {
        this.duracloudGroupService.updateGroupUsers(group, groupUsers, accountId);
        form.reset();
    }

    private void removeGroup(DuracloudGroup group, Long accountId) {
        this.duracloudGroupService.deleteGroup(group, accountId);
    }

    private AccountService getAccountService(Long accountId) throws Exception {
        return this.accountManagerService.getAccount(accountId);
    }

    private void addGroupsObjectsToModel(AccountService as, Model model) throws Exception {
        AccountInfo account = as.retrieveAccountInfo();
        Long accountId = account.getId();
        model.addAttribute("accountInfo", (Object)account);
        this.addGroupsObjectsToModel(as, this.getGroups(accountId), model);
    }

    private void addGroupsObjectsToModel(AccountService as, List<DuracloudGroup> groups, Model model) throws Exception {
        this.addUserToModel(model);
        model.addAttribute("accountInfo", (Object)as.retrieveAccountInfo());
        model.addAttribute("accountId", (Object)as.getAccountId());
        if (!model.asMap().containsKey(GROUPS_FORM_KEY)) {
            model.addAttribute(GROUPS_FORM_KEY, (Object)new GroupsForm());
        }
        this.addGroupsToModel(model, groups);
    }

    private void addAvailableUsersToModel(AccountService as, Collection<DuracloudUser> groupUsers, Model model) {
        Collection availableUsers = this.getAvailableUsers(as, groupUsers);
        this.addAvailableUsersToModel(availableUsers, groupUsers, model);
    }

    private Collection<DuracloudUser> getAvailableUsers(AccountService as, Collection<DuracloudUser> groupUsers) {
        Set allUsers = as.getUsers();
        LinkedList<DuracloudUser> list = new LinkedList<DuracloudUser>();
        list.addAll(allUsers);
        for (DuracloudUser user : allUsers) {
            if (!user.isRoot()) continue;
            list.remove(user);
        }
        if (groupUsers != null) {
            list.removeAll(groupUsers);
        }
        Collections.sort(list, USERNAME_COMPARATOR);
        return list;
    }

    private void addGroupToModel(DuracloudGroup group, Model model) {
        model.addAttribute(GROUP_KEY, (Object)group);
        model.addAttribute(GROUP_USERS_KEY, (Object)group.getUsers());
    }

    private DuracloudGroup getGroup(String groupName, List<DuracloudGroup> groups) throws DuracloudGroupNotFoundException {
        for (DuracloudGroup g : groups) {
            if (!g.getName().equalsIgnoreCase(groupName)) continue;
            return g;
        }
        throw new DuracloudGroupNotFoundException("no group named '" + groupName + "' found in group set.");
    }

    private void addGroupsToModel(Model model, List<DuracloudGroup> groups) {
        model.addAttribute("groups", groups);
    }

    public void setDuracloudGroupService(DuracloudGroupService groupService) {
        this.duracloudGroupService = groupService;
    }
}

