/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import java.util.LinkedList;
import java.util.List;
import javax.validation.Valid;
import org.duracloud.account.app.controller.AccountSetupForm;
import org.duracloud.account.db.model.ComputeProviderAccount;
import org.duracloud.account.db.model.StorageProviderAccount;
import org.hibernate.validator.constraints.NotBlank;

public class AccountSetupForm {
    @Valid
    private StorageProviderSettings primaryStorageProviderSettings = new StorageProviderSettings();
    @Valid
    private List<StorageProviderSettings> secondaryStorageProviderSettingsList = new LinkedList();
    private boolean computeCredentialsSame;
    @NotBlank(message="Compute account's username is required")
    private String computeUsername;
    @NotBlank(message="Compute account's password is required")
    private String computePassword;
    @NotBlank(message="Elastic IP is required")
    private String computeElasticIP;
    @NotBlank(message="Keypair is required")
    private String computeKeypair;
    @NotBlank(message="Security group is required")
    private String computeSecurityGroup;

    public AccountSetupForm(StorageProviderAccount primary, List<StorageProviderAccount> secondaryList, ComputeProviderAccount compute) {
        this();
        this.primaryStorageProviderSettings = this.createStorageProviderSettings(primary);
        for (StorageProviderAccount spa : secondaryList) {
            this.secondaryStorageProviderSettingsList.add(this.createStorageProviderSettings(spa));
        }
        if (compute != null) {
            this.computeUsername = compute.getUsername();
            this.computePassword = compute.getPassword();
            this.computeElasticIP = compute.getElasticIp();
            this.computeKeypair = compute.getKeypair();
            this.computeSecurityGroup = compute.getSecurityGroup();
        }
    }

    private StorageProviderSettings createStorageProviderSettings(StorageProviderAccount spAccount) {
        return new StorageProviderSettings(spAccount);
    }

    public AccountSetupForm() {
    }

    public boolean isComputeCredentialsSame() {
        return this.computeCredentialsSame;
    }

    public void setComputeCredentialsSame(boolean computeCredentialsSame) {
        this.computeCredentialsSame = computeCredentialsSame;
    }

    public String getComputeUsername() {
        return this.computeUsername;
    }

    public void setComputeUsername(String computeUsername) {
        this.computeUsername = computeUsername;
    }

    public String getComputePassword() {
        return this.computePassword;
    }

    public void setComputePassword(String computePassword) {
        this.computePassword = computePassword;
    }

    public String getComputeElasticIP() {
        return this.computeElasticIP;
    }

    public void setComputeElasticIP(String computeElasticIP) {
        this.computeElasticIP = computeElasticIP;
    }

    public String getComputeKeypair() {
        return this.computeKeypair;
    }

    public void setComputeKeypair(String computeKeypair) {
        this.computeKeypair = computeKeypair;
    }

    public String getComputeSecurityGroup() {
        return this.computeSecurityGroup;
    }

    public void setComputeSecurityGroup(String computeSecurityGroup) {
        this.computeSecurityGroup = computeSecurityGroup;
    }

    public StorageProviderSettings getPrimaryStorageProviderSettings() {
        return this.primaryStorageProviderSettings;
    }

    public void setPrimaryStorageProviderSettings(StorageProviderSettings primaryStorageProviderSettings) {
        this.primaryStorageProviderSettings = primaryStorageProviderSettings;
    }

    public List<StorageProviderSettings> getSecondaryStorageProviderSettingsList() {
        return this.secondaryStorageProviderSettingsList;
    }

    public void setSecondaryStorageCredentailsList(List<StorageProviderSettings> secondaryStorageProviderSettingsList) {
        this.secondaryStorageProviderSettingsList = secondaryStorageProviderSettingsList;
    }
}

