/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.annotation;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang.StringUtils;
import org.duracloud.account.annotation.EmailAddressesConstraint;
import org.duracloud.account.util.EmailAddressesParser;
import org.hibernate.validator.constraints.impl.EmailValidator;

public class EmailAddressesValidator
implements ConstraintValidator<EmailAddressesConstraint, String> {
    private EmailAddressesConstraint constraintAnnotation;
    private static EmailValidator EMAIL_VALIDATOR = new EmailValidator();

    public boolean isValid(String value, ConstraintValidatorContext context) {
        List emailAddresses = EmailAddressesParser.parse((String)value);
        LinkedList<String> badAddresses = null;
        for (String ea : emailAddresses) {
            if (EMAIL_VALIDATOR.isValid(ea, null)) continue;
            if (badAddresses == null) {
                badAddresses = new LinkedList<String>();
            }
            badAddresses.add(ea);
        }
        if (badAddresses != null) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(MessageFormat.format(this.constraintAnnotation.message(), StringUtils.join(badAddresses, (String)", "))).addConstraintViolation();
        }
        return badAddresses == null;
    }

    public void initialize(EmailAddressesConstraint constraintAnnotation) {
        this.constraintAnnotation = constraintAnnotation;
    }
}

