/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import java.util.ArrayList;
import java.util.List;
import org.duracloud.account.app.controller.AbstractRootCrudController;
import org.duracloud.account.app.controller.ServerImageForm;
import org.duracloud.account.db.model.ServerImage;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/root/serverimages"})
public class ServerImageController
extends AbstractRootCrudController<ServerImageForm> {
    private static final String RELATIVE_MAPPING = "/serverimages";
    public static final String BASE_MAPPING = "/root/serverimages";

    public ServerImageController() {
        super(ServerImageForm.class);
    }

    protected String getBaseViewId() {
        return super.getBaseView() + RELATIVE_MAPPING;
    }

    @ModelAttribute(value="providerAccountIds")
    public List<String> getProviderAccounts() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        return list;
    }

    public ModelAndView get() {
        ModelAndView mav = new ModelAndView(this.getBaseViewId());
        mav.addObject("serverImages", (Object)this.getRootAccountManagerService().listAllServerImages(null));
        return mav;
    }

    protected void create(ServerImageForm form) {
        this.getRootAccountManagerService().createServerImage(form.getProviderImageId(), form.getVersion(), form.getDescription(), form.getPassword(), form.isLatest(), form.getIamRole(), form.getCfKeyPath(), form.getCfAccountId(), form.getCfKeyId());
    }

    protected Object getEntity(Long id) {
        return this.getRootAccountManagerService().getServerImage(id);
    }

    protected ServerImageForm loadForm(Object obj) {
        ServerImage entity = (ServerImage)obj;
        ServerImageForm form = (ServerImageForm)this.form();
        form.setProviderImageId(entity.getProviderImageId());
        form.setVersion(entity.getVersion());
        form.setDescription(entity.getDescription());
        form.setPassword(entity.getDcRootPassword());
        form.setLatest(entity.isLatest());
        form.setIamRole(entity.getIamRole());
        form.setCfKeyPath(entity.getCfKeyPath());
        form.setCfAccountId(entity.getCfAccountId());
        form.setCfKeyId(entity.getCfKeyId());
        return form;
    }

    protected void update(Long id, ServerImageForm form) {
        this.getRootAccountManagerService().editServerImage(id, form.getProviderImageId(), form.getVersion(), form.getDescription(), form.getPassword(), form.isLatest(), form.getIamRole(), form.getCfKeyPath(), form.getCfAccountId(), form.getCfKeyId());
    }

    protected void delete(Long id) {
        this.getRootAccountManagerService().deleteServerImage(id);
    }
}

