/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.flow.createaccount;

import java.util.HashSet;
import org.duracloud.account.app.controller.FullAccountForm;
import org.duracloud.account.app.controller.NewAccountForm;
import org.duracloud.account.db.model.util.AccountCreationInfo;
import org.duracloud.account.db.util.AccountManagerService;
import org.duracloud.account.db.util.AccountService;
import org.duracloud.account.util.MessageHelper;
import org.duracloud.account.util.UrlHelper;
import org.duracloud.storage.domain.StorageProviderType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.binding.message.Message;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@Component
public class CreateAccountAction
extends AbstractAction {
    @Autowired
    private AccountManagerService accountManagerService;
    @Autowired
    private MessageHelper messageHelper;
    @Autowired
    private MessageSource messageSource = null;

    @Transactional
    public Event doExecute(RequestContext context) throws Exception {
        NewAccountForm newAccountForm = (NewAccountForm)context.getFlowScope().get("newAccountForm");
        FullAccountForm fullAccountForm = (FullAccountForm)context.getFlowScope().get("fullAccountForm");
        boolean reducedRedundancy = false;
        HashSet secondaryStorageProviders = new HashSet();
        if (fullAccountForm.getSecondaryStorageProviders() != null) {
            secondaryStorageProviders.addAll(fullAccountForm.getSecondaryStorageProviders());
        }
        reducedRedundancy = fullAccountForm.isUseReducedRedundancy();
        AccountCreationInfo aci = new AccountCreationInfo(newAccountForm.getSubdomain(), newAccountForm.getAcctName(), newAccountForm.getOrgName(), newAccountForm.getDepartment(), StorageProviderType.AMAZON_S3, secondaryStorageProviders);
        AccountService as = this.accountManagerService.createAccount(aci);
        as.setPrimaryStorageProviderRrs(reducedRedundancy);
        String contextPath = context.getExternalContext().getContextPath();
        String accountName = newAccountForm.getAcctName();
        Long accountId = as.getAccountId();
        String pattern = contextPath + "/root/accounts" + "/byid/{id}/setup";
        String accountUri = UrlHelper.formatId((Long)accountId, (String)pattern);
        Object[] args = new Object[]{accountName, accountUri};
        Message message = this.messageHelper.createMessageSuccess(this.messageSource, "account.create.full.success", args);
        context.getFlowScope().put("message", (Object)message);
        return this.success();
    }

    public void setAccountManagerService(AccountManagerService accountManagerService) {
        this.accountManagerService = accountManagerService;
    }

    public void setMessageHelper(MessageHelper messageHelper) {
        this.messageHelper = messageHelper;
    }
}

