/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import java.util.Set;
import javax.validation.Valid;
import org.duracloud.account.app.controller.AbstractAccountController;
import org.duracloud.account.app.controller.AccountInstanceForm;
import org.duracloud.account.app.controller.UserController;
import org.duracloud.account.compute.error.DuracloudInstanceNotAvailableException;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.InstanceType;
import org.duracloud.account.db.util.AccountService;
import org.duracloud.account.db.util.DuracloudInstanceService;
import org.duracloud.account.db.util.error.AccountNotFoundException;
import org.duracloud.account.db.util.error.DBNotFoundException;
import org.duracloud.account.db.util.notification.NotificationMgr;
import org.duracloud.account.util.UserFeedbackUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@Lazy
public class AccountController
extends AbstractAccountController {
    public static final String NEW_ACCOUNT_FORM_KEY = "newAccountForm";
    public static final String NEW_INSTANCE_FORM = "instanceForm";
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private NotificationMgr notificationMgr;

    @RequestMapping(value={"/byid/{accountId}"}, method={RequestMethod.GET})
    public String getHome(@PathVariable Long accountId, Model model) throws AccountNotFoundException {
        this.loadAccountInfo(accountId, model);
        return "account-home";
    }

    @RequestMapping(value={"/byid/{accountId}/statement"}, method={RequestMethod.GET})
    public String getStatement(@PathVariable Long accountId, Model model) throws AccountNotFoundException {
        this.loadAccountInfo(accountId, model);
        return "account-statement";
    }

    @RequestMapping(value={"/byid/{accountId}/instance"}, method={RequestMethod.GET})
    public String getInstance(@PathVariable Long accountId, Model model) throws AccountNotFoundException, DBNotFoundException, DuracloudInstanceNotAvailableException {
        this.populateAccountInModel(accountId, model);
        this.addUserToModel(model);
        return "account-instance";
    }

    private void populateAccountInModel(Long accountId, Model model) throws AccountNotFoundException, DuracloudInstanceNotAvailableException {
        AccountInfo acctInfo = this.loadAccountInfo(accountId, model);
        this.loadAccountInstances(acctInfo, model);
    }

    private void loadAccountInstances(AccountInfo accountInfo, Model model) throws DuracloudInstanceNotAvailableException {
        Set instanceServices = this.instanceManagerService.getInstanceServices(accountInfo.getId());
        if (instanceServices.size() > 0) {
            DuracloudInstanceService instanceService = (DuracloudInstanceService)instanceServices.iterator().next();
            model.addAttribute("instanceInfo", (Object)instanceService.getInstanceInfo());
            model.addAttribute("instanceStatus", (Object)instanceService.getStatus());
        } else if (accountInfo.getStatus().equals((Object)AccountInfo.AccountStatus.ACTIVE) || accountInfo.getStatus().equals((Object)AccountInfo.AccountStatus.INACTIVE)) {
            Set versions = this.instanceManagerService.getVersions();
            model.addAttribute("dcVersions", (Object)versions);
            AccountInstanceForm accountInstanceForm = new AccountInstanceForm();
            accountInstanceForm.setVersion(this.instanceManagerService.getLatestVersion());
            model.addAttribute(NEW_INSTANCE_FORM, (Object)accountInstanceForm);
        }
    }

    @RequestMapping(value={"/byid/{accountId}/instance/start"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView startInstance(@PathVariable Long accountId, @ModelAttribute(value="instanceForm") @Valid AccountInstanceForm instanceForm, RedirectAttributes redirectAttributes) throws AccountNotFoundException, DuracloudInstanceNotAvailableException {
        if (instanceForm.getVersion() == null) {
            instanceForm.setVersion(this.instanceManagerService.getLatestVersion());
        }
        try {
            this.startInstance(accountId, instanceForm.getVersion(), instanceForm.getInstanceType());
            redirectAttributes.addFlashAttribute("actionStatus", (Object)"Instance STARTED successfully, it will be available for use in 5 minutes.");
        }
        catch (RuntimeException ex) {
            this.setError((Exception)ex, redirectAttributes);
        }
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.createUserRedirectModelAndView(username);
    }

    @RequestMapping(value={"/byid/{accountId}/instance/available"}, method={RequestMethod.POST})
    public ModelAndView instanceAvailable(@PathVariable Long accountId, Model model) throws AccountNotFoundException, DuracloudInstanceNotAvailableException {
        DuracloudInstanceService instanceService = null;
        long start = System.currentTimeMillis();
        do {
            Set instanceServices;
            if (instanceService != null) {
                long now = System.currentTimeMillis();
                if (now - start > 300000L) {
                    return null;
                }
                this.sleep(10000);
            }
            if ((instanceServices = this.instanceManagerService.getInstanceServices(accountId)).size() <= 0) continue;
            instanceService = (DuracloudInstanceService)instanceServices.iterator().next();
        } while (!instanceService.getInstanceInfo().isInitialized());
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.createUserRedirectModelAndView(username);
    }

    private void sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected DuracloudInstanceService startInstance(Long accountId, String version, InstanceType instanceType) {
        DuracloudInstanceService instanceService = this.instanceManagerService.createInstance(accountId, version, instanceType);
        return instanceService;
    }

    @RequestMapping(value={"/byid/{accountId}/instance/byid/{instanceId}/upgrade"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView upgradeInstance(@PathVariable Long accountId, @PathVariable Long instanceId, Model model) throws AccountNotFoundException, DuracloudInstanceNotAvailableException {
        InstanceType instanceType = this.instanceManagerService.getInstanceService(instanceId).getInstanceType();
        this.stopInstance(instanceId);
        this.startInstance(accountId, this.instanceManagerService.getLatestVersion(), instanceType);
        this.populateAccountInModel(accountId, model);
        model.addAttribute("actionStatus", (Object)"Instance UPGRADED successfully, it will be available for use in 5 minutes.");
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.createUserRedirectModelAndView(username);
    }

    @RequestMapping(value={"/byid/{accountId}/instance/byid/{instanceId}/restart"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView restartInstance(@PathVariable Long accountId, @PathVariable Long instanceId, Model model) throws AccountNotFoundException, DuracloudInstanceNotAvailableException {
        this.restartInstance(instanceId);
        this.populateAccountInModel(accountId, model);
        model.addAttribute("actionStatus", (Object)"Instance RESTARTED successfully, it will be available for use in 5 minutes.");
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.createUserRedirectModelAndView(username);
    }

    protected void restartInstance(Long instanceId) throws DuracloudInstanceNotAvailableException {
        DuracloudInstanceService instanceService = this.instanceManagerService.getInstanceService(instanceId);
        instanceService.restart();
    }

    @RequestMapping(value={"/byid/{accountId}/instance/byid/{instanceId}/reinitusers"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView reInitializeUserRoles(@PathVariable Long accountId, @PathVariable Long instanceId, Model model, RedirectAttributes redirectAttributes) throws AccountNotFoundException, DuracloudInstanceNotAvailableException {
        this.log.info("ReInit UserRoles for acct: {}, instance: {}", (Object)accountId, (Object)instanceId);
        try {
            DuracloudInstanceService instanceService = this.instanceManagerService.getInstanceService(instanceId);
            instanceService.reInitializeUserRoles();
            UserFeedbackUtil.addSuccessFlash((String)"Successfully reinitialized users!", (RedirectAttributes)redirectAttributes);
        }
        catch (Exception ex) {
            this.log.error("failed to reinitialize service", (Throwable)ex);
            UserFeedbackUtil.addFailureFlash((String)"Unable to  reinitialize users. Please try again in a few minutes.", (RedirectAttributes)redirectAttributes);
        }
        return this.reInitResult(accountId, model, redirectAttributes);
    }

    @RequestMapping(value={"/byid/{accountId}/instance/byid/{instanceId}/reinit"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView reInitialize(@PathVariable Long accountId, @PathVariable Long instanceId, Model model, RedirectAttributes redirectAttributes) throws AccountNotFoundException, DuracloudInstanceNotAvailableException {
        this.log.info("ReInit Instance for acct: {}, instance: {}", (Object)accountId, (Object)instanceId);
        try {
            DuracloudInstanceService instanceService = this.instanceManagerService.getInstanceService(instanceId);
            instanceService.reInitialize();
            UserFeedbackUtil.addSuccessFlash((String)"Successfully reinitialized instance!", (RedirectAttributes)redirectAttributes);
        }
        catch (Exception ex) {
            this.log.error("failed to reinitialize service", (Throwable)ex);
            UserFeedbackUtil.addFailureFlash((String)"Unable to  reinitialize instance. Please try again in a few minutes.", (RedirectAttributes)redirectAttributes);
        }
        return this.reInitResult(accountId, model, redirectAttributes);
    }

    private ModelAndView reInitResult(Long accountId, Model model, RedirectAttributes redirectAttributes) throws AccountNotFoundException, DuracloudInstanceNotAvailableException {
        this.populateAccountInModel(accountId, model);
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.createUserRedirectModelAndView(username);
    }

    @RequestMapping(value={"/byid/{accountId}/instance/byid/{instanceId}/stop"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView stopInstance(@PathVariable Long accountId, @PathVariable Long instanceId, Model model) throws AccountNotFoundException, DuracloudInstanceNotAvailableException {
        this.stopInstance(instanceId);
        this.populateAccountInModel(accountId, model);
        model.addAttribute("actionStatus", (Object)"Instance STOPPED successfully.");
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.createUserRedirectModelAndView(username);
    }

    protected void stopInstance(Long instanceId) throws DuracloudInstanceNotAvailableException {
        DuracloudInstanceService instanceService = this.instanceManagerService.getInstanceService(instanceId);
        instanceService.stop();
    }

    @RequestMapping(value={"/byid/{accountId}/activate"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView activate(@PathVariable Long accountId) throws AccountNotFoundException {
        AccountService accountService = this.accountManagerService.getAccount(accountId);
        accountService.storeAccountStatus(AccountInfo.AccountStatus.ACTIVE);
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.createUserRedirectModelAndView(username);
    }

    @RequestMapping(value={"/byid/{accountId}/deactivate"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView deactivate(@PathVariable Long accountId, Model model) throws AccountNotFoundException {
        AccountService accountService = this.accountManagerService.getAccount(accountId);
        accountService.storeAccountStatus(AccountInfo.AccountStatus.INACTIVE);
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.createUserRedirectModelAndView(username);
    }

    private ModelAndView createUserRedirectModelAndView(String username) {
        RedirectView view = UserController.formatUserRedirect((String)username);
        return new ModelAndView((View)view);
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

