/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import javax.validation.Valid;
import org.duracloud.account.app.controller.GlobalPropertiesForm;
import org.duracloud.account.db.model.GlobalProperties;
import org.duracloud.account.db.util.GlobalPropertiesConfigService;
import org.duracloud.account.util.UserFeedbackUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/root/globalproperties"})
public class GlobalPropertiesController {
    private static final String GLOBAL_PROPERTIES_ATTRIBUTE = "globalProperties";
    @Autowired
    private GlobalPropertiesConfigService globalPropertiesConfigService;
    public static final String BASE_MAPPING = "/root/globalproperties";

    public void setGlobalPropertiesConfigService(GlobalPropertiesConfigService globalPropertiesConfigService) {
        this.globalPropertiesConfigService = globalPropertiesConfigService;
    }

    @RequestMapping(value={""})
    public ModelAndView get() {
        ModelAndView mav = new ModelAndView(BASE_MAPPING);
        return mav;
    }

    @ModelAttribute(value="globalProperties")
    public GlobalPropertiesForm form() {
        GlobalPropertiesForm form = new GlobalPropertiesForm();
        GlobalProperties entity = this.globalPropertiesConfigService.get();
        if (entity == null) {
            return new GlobalPropertiesForm();
        }
        form.setInstanceNotificationTopicArn(entity.getInstanceNotificationTopicArn());
        form.setCloudFrontAccountId(entity.getCloudFrontAccountId());
        form.setCloudFrontKeyId(entity.getCloudFrontKeyId());
        form.setCloudFrontKeyPath(entity.getCloudFrontKeyPath());
        return form;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public ModelAndView edit() {
        return new ModelAndView("/root/globalproperties/edit");
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView update(@ModelAttribute(value="globalProperties") @Valid GlobalPropertiesForm form, BindingResult bindingResult, Model model, RedirectAttributes redirectAttributes) {
        boolean hasErrors = bindingResult.hasErrors();
        if (hasErrors) {
            return new ModelAndView("/root/globalproperties/edit");
        }
        this.globalPropertiesConfigService.set(form.getInstanceNotificationTopicArn(), form.getCloudFrontAccountId(), form.getCloudFrontKeyId(), form.getCloudFrontKeyPath());
        UserFeedbackUtil.addSuccessFlash((String)"Successfully updated!", (RedirectAttributes)redirectAttributes);
        return new ModelAndView((View)new RedirectView(BASE_MAPPING, true));
    }
}

