/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import javax.validation.Valid;
import org.duracloud.account.app.controller.AbstractAccountController;
import org.duracloud.account.app.controller.AccountEditForm;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.util.error.AccountNotFoundException;
import org.duracloud.account.db.util.error.DBNotFoundException;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@Lazy
public class AccountInfoController
extends AbstractAccountController {
    public static final String ACCOUNT_DETAILS_VIEW_ID = "account-details";
    public static final String ACCOUNT_INFO_EDIT_ID = "account-info-edit";
    public static final String EDIT_ACCOUNT_INFO_FORM_KEY = "accountInfoEditForm";
    public static final String INFO_EDIT_MAPPING = "/byid/{accountId}/details/edit";

    @RequestMapping(value={"/byid/{accountId}/details/edit"}, method={RequestMethod.GET})
    public String getEditForm(@PathVariable Long accountId, Model model) throws AccountNotFoundException {
        this.log.info("getEditForm account {}", (Object)accountId);
        this.loadAccountInfo(accountId, model);
        AccountInfo accountInfo = (AccountInfo)model.asMap().get("accountInfo");
        AccountEditForm editForm = new AccountEditForm();
        editForm.setDepartment(accountInfo.getDepartment());
        editForm.setOrgName(accountInfo.getOrgName());
        editForm.setAcctName(accountInfo.getAcctName());
        model.addAttribute(EDIT_ACCOUNT_INFO_FORM_KEY, (Object)editForm);
        return ACCOUNT_INFO_EDIT_ID;
    }

    @Transactional
    @RequestMapping(value={"/byid/{accountId}/details/edit"}, method={RequestMethod.POST})
    public ModelAndView editInfo(@PathVariable Long accountId, @ModelAttribute(value="accountInfoEditForm") @Valid AccountEditForm accountEditForm, BindingResult result, Model model) throws AccountNotFoundException, DBNotFoundException {
        this.log.info("editInfo account {}", (Object)accountId);
        if (result.hasErrors()) {
            return new ModelAndView(ACCOUNT_INFO_EDIT_ID, model.asMap());
        }
        this.getAccountManagerService().getAccount(accountId).storeAccountInfo(accountEditForm.getAcctName(), accountEditForm.getOrgName(), accountEditForm.getDepartment());
        return this.createAccountRedirectModelAndView(accountId, "/details");
    }
}

