/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import org.duracloud.account.app.controller.AbstractAccountController;
import org.duracloud.account.app.controller.UserController;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.util.AccountService;
import org.duracloud.account.db.util.error.AccountNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@Lazy
public class AccountController
extends AbstractAccountController {
    public static final String NEW_ACCOUNT_FORM_KEY = "newAccountForm";
    @Autowired
    private AuthenticationManager authenticationManager;

    @RequestMapping(value={"/byid/{accountId}"}, method={RequestMethod.GET})
    public String getHome(@PathVariable Long accountId, Model model) throws AccountNotFoundException {
        this.loadAccountInfo(accountId, model);
        return "account-home";
    }

    @RequestMapping(value={"/byid/{accountId}/statement"}, method={RequestMethod.GET})
    public String getStatement(@PathVariable Long accountId, Model model) throws AccountNotFoundException {
        this.loadAccountInfo(accountId, model);
        return "account-statement";
    }

    @RequestMapping(value={"/byid/{accountId}/activate"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView activate(@PathVariable Long accountId) throws AccountNotFoundException {
        AccountService accountService = this.accountManagerService.getAccount(accountId);
        accountService.storeAccountStatus(AccountInfo.AccountStatus.ACTIVE);
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.createUserRedirectModelAndView(username);
    }

    @RequestMapping(value={"/byid/{accountId}/deactivate"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView deactivate(@PathVariable Long accountId, Model model) throws AccountNotFoundException {
        AccountService accountService = this.accountManagerService.getAccount(accountId);
        accountService.storeAccountStatus(AccountInfo.AccountStatus.INACTIVE);
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.createUserRedirectModelAndView(username);
    }

    private ModelAndView createUserRedirectModelAndView(String username) {
        RedirectView view = UserController.formatUserRedirect((String)username);
        return new ModelAndView((View)view);
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

