/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import java.util.Set;
import javax.validation.Valid;
import org.duracloud.account.app.controller.AbstractAccountController;
import org.duracloud.account.app.controller.ProviderForm;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.StorageProviderAccount;
import org.duracloud.account.db.util.AccountService;
import org.duracloud.account.db.util.error.AccountNotFoundException;
import org.duracloud.account.db.util.error.DBNotFoundException;
import org.duracloud.account.util.UserFeedbackUtil;
import org.duracloud.storage.domain.StorageProviderType;
import org.springframework.binding.message.Severity;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@Lazy
public class AccountDetailsController
extends AbstractAccountController {
    public static final String ACCOUNT_DETAILS_VIEW_ID = "account-details";
    public static final String ACCOUNT_DETAILS_PATH = "/details";
    public static final String ACCOUNT_DETAILS_MAPPING = "/byid/{accountId}/details";

    @RequestMapping(value={"/byid/{accountId}/details"}, method={RequestMethod.GET})
    public String get(@PathVariable Long accountId, Model model) throws AccountNotFoundException, DBNotFoundException {
        AccountInfo accountInfo = this.loadAccountInfo(accountId, model);
        this.loadBillingInfo(accountId, model);
        this.loadProviderInfo(accountId, model);
        DuracloudUser user = this.getUser();
        model.addAttribute("user", (Object)user);
        model.addAttribute("userRole", (Object)user.getRoleByAcct(accountId));
        return ACCOUNT_DETAILS_VIEW_ID;
    }

    @RequestMapping(value={"/byid/{accountId}/details/providers/add"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView addProvider(@PathVariable Long accountId, @ModelAttribute(value="providerForm") @Valid ProviderForm providerForm, BindingResult result, Model model) throws AccountNotFoundException {
        this.log.info("addProvider account {}", (Object)accountId);
        AccountService accountService = this.accountManagerService.getAccount(accountId);
        accountService.addStorageProvider(StorageProviderType.fromString((String)providerForm.getProvider()));
        return this.createAccountRedirectModelAndView(accountId, ACCOUNT_DETAILS_PATH);
    }

    @RequestMapping(value={"/byid/{accountId}/details/providers/{providerType}/remove"}, method={RequestMethod.POST})
    @Transactional
    public View removeProvider(@PathVariable Long accountId, @PathVariable String providerType, RedirectAttributes redirectAttributes) throws AccountNotFoundException {
        this.log.debug("attempting to remove provider {} from  account {}", (Object)providerType, (Object)accountId);
        AccountService accountService = this.accountManagerService.getAccount(accountId);
        StorageProviderType spType = StorageProviderType.fromString((String)providerType);
        Set ssps = accountService.getSecondaryStorageProviders();
        boolean removed = false;
        for (StorageProviderAccount spa : ssps) {
            if (!spa.getProviderType().equals((Object)spType)) continue;
            accountService.removeStorageProvider(spa.getId());
            String message = "Successfully removed provider (" + providerType + ")!";
            this.log.info(message + " from account " + accountId);
            UserFeedbackUtil.addFlash((String)message, (Severity)Severity.INFO, (RedirectAttributes)redirectAttributes);
            removed = true;
            break;
        }
        if (!removed) {
            String message = "Unable to remove provider (" + providerType + ").  A provider of that type is not a secondary provider associated with this account.";
            this.log.info(message + " from account " + accountId);
            UserFeedbackUtil.addFlash((String)message, (Severity)Severity.ERROR, (RedirectAttributes)redirectAttributes);
        }
        return this.createAccountRedirectView(accountId, ACCOUNT_DETAILS_PATH);
    }

    @RequestMapping(value={"/byid/{accountId}/details/providers/{providerType}/make-primary"}, method={RequestMethod.POST})
    @Transactional
    public View makePrimary(@PathVariable Long accountId, @PathVariable String providerType, RedirectAttributes redirectAttributes) throws AccountNotFoundException {
        this.log.debug("attempting to changed primary provider {} from  account {}", (Object)providerType, (Object)accountId);
        AccountService accountService = this.accountManagerService.getAccount(accountId);
        StorageProviderType spType = StorageProviderType.fromString((String)providerType);
        Set ssps = accountService.getSecondaryStorageProviders();
        boolean changed = false;
        for (StorageProviderAccount spa : ssps) {
            if (!spa.getProviderType().equals((Object)spType)) continue;
            accountService.changePrimaryStorageProvider(spa.getId());
            String message = "Successfully made provider (" + providerType + ") primary!";
            this.log.info(message + " from account " + accountId);
            UserFeedbackUtil.addFlash((String)message, (Severity)Severity.INFO, (RedirectAttributes)redirectAttributes);
            changed = true;
            break;
        }
        if (!changed) {
            String message = "Unable to make provider (" + providerType + ") primary.  A provider of that type is not a secondary provider associated with this account.";
            this.log.info(message + " from account " + accountId);
            UserFeedbackUtil.addFlash((String)message, (Severity)Severity.ERROR, (RedirectAttributes)redirectAttributes);
        }
        return this.createAccountRedirectView(accountId, ACCOUNT_DETAILS_PATH);
    }
}

