/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import javax.validation.Valid;
import org.duracloud.account.app.controller.AbstractAccountController;
import org.duracloud.account.app.controller.ProviderForm;
import org.duracloud.account.db.util.AccountService;
import org.duracloud.account.db.util.error.AccountNotFoundException;
import org.duracloud.account.db.util.error.DBNotFoundException;
import org.duracloud.storage.domain.StorageProviderType;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@Lazy
public class ProviderController
extends AbstractAccountController {
    public static final String PROVIDER_PATH = "/byid/{accountId}/providers";

    @RequestMapping(value={"/byid/{accountId}/providers"}, method={RequestMethod.GET})
    public String getProviders(@PathVariable Long accountId, Model model) throws AccountNotFoundException, DBNotFoundException {
        this.loadAccountInfo(accountId, model);
        this.loadProviderInfo(accountId, model);
        this.addUserToModel(model);
        return "account-providers";
    }

    @Transactional
    @RequestMapping(value={"/byid/{accountId}/providers/add"}, method={RequestMethod.POST})
    public ModelAndView addProvider(@PathVariable Long accountId, @ModelAttribute(value="providerForm") @Valid ProviderForm providerForm, BindingResult result, Model model) throws AccountNotFoundException {
        this.log.info("addProvider account {}", (Object)accountId);
        AccountService accountService = this.accountManagerService.getAccount(accountId);
        accountService.addStorageProvider(StorageProviderType.fromString((String)providerForm.getProvider()));
        return this.createAccountRedirectModelAndView(accountId, "/providers");
    }

    @Transactional
    @RequestMapping(value={"/byid/{accountId}/providers/byid/{providerId}/delete"}, method={RequestMethod.POST})
    public ModelAndView deleteProviderFromAccount(@PathVariable Long accountId, @PathVariable Long providerId, Model model) throws AccountNotFoundException {
        this.log.info("delete provider {} from account {}", (Object)providerId, (Object)accountId);
        AccountService accountService = this.accountManagerService.getAccount(accountId);
        accountService.removeStorageProvider(providerId);
        return this.createAccountRedirectModelAndView(accountId, "/providers");
    }
}

