/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.validation.Valid;
import org.duracloud.account.app.controller.AbstractRootController;
import org.duracloud.account.app.controller.AccountUserEditForm;
import org.duracloud.account.app.model.Account;
import org.duracloud.account.app.model.User;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.AccountRights;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.Role;
import org.duracloud.account.db.util.DuracloudUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/root/users"})
public class UsersController
extends AbstractRootController {
    public static final String BASE_MAPPING = "/root/users";
    private static final String BASE_VIEW = "/root/users";
    public static final String EDIT_ACCOUNT_USERS_FORM_KEY = "accountUsersEditForm";
    @Autowired
    private DuracloudUserService userService;

    @RequestMapping(value={""})
    public ModelAndView get() {
        ArrayList<User> u = new ArrayList<User>();
        Set users = this.getRootAccountManagerService().listAllUsers(null);
        for (DuracloudUser user : users) {
            HashSet<Account> accounts = new HashSet<Account>();
            if (user.getAccountRights() != null) {
                for (AccountRights account : user.getAccountRights()) {
                    AccountInfo accountInfo = account.getAccount();
                    accounts.add(new Account(account.getAccount().getId(), accountInfo.getAcctName(), accountInfo.getSubdomain(), user.getRoleByAcct(account.getAccount().getId())));
                }
            }
            u.add(new User(user.getId(), user.getUsername(), user.getFirstName(), user.getLastName(), user.getEmail(), user.getAllowableIPAddressRange(), accounts, user.isRoot()));
        }
        Collections.sort(u);
        ModelAndView mav = new ModelAndView("/root/users");
        mav.addObject("users", u);
        mav.addObject(EDIT_ACCOUNT_USERS_FORM_KEY, (Object)new AccountUserEditForm());
        return mav;
    }

    @Transactional
    @RequestMapping(value={"/byid/{id}/reset"}, method={RequestMethod.POST})
    public ModelAndView resetUsersPassword(@PathVariable Long id, RedirectAttributes redirectAttributes) throws Exception {
        this.log.debug("resetting user {}'s password.", (Object)id);
        this.getRootAccountManagerService().resetUsersPassword(id);
        DuracloudUser user = this.getUserService().loadDuracloudUserByIdInternal(id);
        String message = MessageFormat.format("{0}'s password has been reset.", user.getUsername());
        this.setSuccessFeedback(message, redirectAttributes);
        return this.createRedirectMav("/root/users");
    }

    @Transactional
    @RequestMapping(value={"/byid/{id}/delete"}, method={RequestMethod.POST})
    public ModelAndView deleteUser(@PathVariable Long id, RedirectAttributes redirectAttributes) throws Exception {
        this.log.info("delete user {}", (Object)id);
        this.getRootAccountManagerService().deleteUser(id);
        this.setSuccessFeedback("Successfully deleted user.", redirectAttributes);
        return this.createRedirectMav("/root/users");
    }

    @Transactional
    @RequestMapping(value={"/byid/{id}/revoke"}, method={RequestMethod.POST})
    public ModelAndView revokeUserRightsFromAccount(@PathVariable(value="id") Long userId, @RequestParam(required=true) Long accountId, RedirectAttributes redirectAttributes) throws Exception {
        this.log.info("revoking user {}'s rights from account {}", (Object)userId, (Object)accountId);
        String username = this.getUserService().loadDuracloudUserByIdInternal(userId).getUsername();
        String accountName = this.getAccountManagerService().getAccount(accountId).retrieveAccountInfo().getAcctName();
        this.getUserService().revokeUserRights(accountId, userId);
        String message = MessageFormat.format("Removed {0} from {1}", username, accountName);
        this.setSuccessFeedback(message, redirectAttributes);
        return this.createRedirectMav("/root/users");
    }

    @Transactional
    @RequestMapping(value={"/byid/{id}/changerole"}, method={RequestMethod.POST})
    public ModelAndView changeUserRole(@PathVariable(value="id") Long userId, @ModelAttribute @Valid AccountUserEditForm accountUserEditForm, BindingResult result, RedirectAttributes redirectAttributes) throws Exception {
        Long accountId = accountUserEditForm.getAccountId();
        this.log.debug("editUser account {}", (Object)accountId);
        boolean hasErrors = result.hasErrors();
        if (!hasErrors) {
            Role role = Role.valueOf((String)accountUserEditForm.getRole());
            this.log.info("New role: {}", (Object)role);
            this.setUserRights(this.userService, accountId, userId, role);
            this.setSuccessFeedback("Successfully changed user role.", redirectAttributes);
        } else {
            this.setFailureFeedback("Unable to change the user role.", redirectAttributes);
        }
        return this.createRedirectMav("/root/users");
    }

    protected DuracloudUserService getUserService() {
        return this.userService;
    }

    public void setUserService(DuracloudUserService userService) {
        this.userService = userService;
    }
}

