/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import javax.validation.Valid;
import org.duracloud.account.app.controller.EmailTemplateForm;
import org.duracloud.account.db.model.EmailTemplate;
import org.duracloud.account.db.util.EmailTemplateService;
import org.duracloud.account.util.UserFeedbackUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/root/notifications"})
public class NotificationsController {
    public static final String BASE_MAPPING = "/root/notifications";
    private static final String EMAIL_TEMPLATE_FORM = "emailTemplateForm";
    private static final String EMAIL_TEMPLATE = "emailTemplate";
    @Autowired
    private EmailTemplateService emailTemplateService;

    @RequestMapping(value={""})
    public ModelAndView get() {
        ModelAndView mav = new ModelAndView(BASE_MAPPING);
        mav.addObject("emailTemplates", (Object)this.emailTemplateService.list());
        return mav;
    }

    @RequestMapping(value={"/edit/{templateId}"}, method={RequestMethod.GET})
    public ModelAndView edit(@PathVariable Long templateId) {
        EmailTemplate emailTemplate = this.emailTemplateService.getTemplate(templateId);
        EmailTemplateForm form = new EmailTemplateForm();
        form.setSubject(emailTemplate.getSubject());
        form.setBody(emailTemplate.getBody());
        return new ModelAndView("/root/notifications/edit").addObject(EMAIL_TEMPLATE_FORM, (Object)form).addObject(EMAIL_TEMPLATE, (Object)emailTemplate);
    }

    @RequestMapping(value={"/edit/{templateId}"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView update(@PathVariable long templateId, @ModelAttribute(value="emailTemplateForm") @Valid EmailTemplateForm form, BindingResult bindingResult, RedirectAttributes redirectAttributes) {
        EmailTemplate template = this.emailTemplateService.getTemplate(Long.valueOf(templateId));
        boolean hasErrors = bindingResult.hasErrors();
        if (hasErrors) {
            return new ModelAndView("/root/notifications/edit").addObject(EMAIL_TEMPLATE_FORM, (Object)form).addObject(EMAIL_TEMPLATE, (Object)template);
        }
        this.emailTemplateService.update(Long.valueOf(templateId), form.getSubject(), form.getBody());
        UserFeedbackUtil.addSuccessFlash((String)"Successfully updated email template!", (RedirectAttributes)redirectAttributes);
        return new ModelAndView((View)new RedirectView(BASE_MAPPING, true));
    }
}

