/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.annotation;

import java.text.MessageFormat;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.duracloud.account.annotation.UsernameConstraint;
import org.duracloud.account.db.util.DuracloudUserService;
import org.duracloud.account.db.util.error.InvalidUsernameException;
import org.duracloud.account.db.util.error.ReservedPrefixException;
import org.duracloud.account.db.util.error.ReservedUsernameException;
import org.duracloud.account.db.util.error.UserAlreadyExistsException;
import org.springframework.beans.factory.annotation.Autowired;

public class UsernameValidator
implements ConstraintValidator<UsernameConstraint, String> {
    private static final String INVALID_USERNAME_MESSAGE = "The username \"{0}\" is invalid. Usernames must contain only lowercase letters, numbers, '-', '_', '.', and start and end with a letter or number.";
    private static final String RESERVED_USERNAME_MESSAGE = "\"{0}\" is a reserved name. Please choose another username.";
    private static final String RESERVED_PREFIX_MESSAGE = "Usernames may not be prefixed by \"group-\". Please choose another username.";
    @Autowired(required=true)
    private DuracloudUserService duracloudUserService;

    public boolean isValid(String value, ConstraintValidatorContext context) {
        try {
            this.duracloudUserService.checkUsername(value);
        }
        catch (InvalidUsernameException ex) {
            context.disableDefaultConstraintViolation();
            String message = ex instanceof ReservedUsernameException ? RESERVED_USERNAME_MESSAGE : (ex instanceof ReservedPrefixException ? RESERVED_PREFIX_MESSAGE : INVALID_USERNAME_MESSAGE);
            message = MessageFormat.format(message, value);
            ConstraintValidatorContext.ConstraintViolationBuilder cvb = context.buildConstraintViolationWithTemplate(message);
            cvb.addConstraintViolation();
            return false;
        }
        catch (UserAlreadyExistsException ex) {
            return false;
        }
        return true;
    }

    public void initialize(UsernameConstraint constraintAnnotation) {
    }

    public DuracloudUserService getUserService() {
        return this.duracloudUserService;
    }

    public void setUserService(DuracloudUserService duracloudUserService) {
        this.duracloudUserService = duracloudUserService;
    }
}

