/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import javax.validation.Valid;
import org.duracloud.account.app.controller.DuracloudMillForm;
import org.duracloud.account.db.model.DuracloudMill;
import org.duracloud.account.db.util.DuracloudMillConfigService;
import org.duracloud.account.util.UserFeedbackUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/root/duracloudmill"})
public class DuracloudMillController {
    @Autowired
    private DuracloudMillConfigService duracloudMillConfigService;
    public static final String BASE_MAPPING = "/root/duracloudmill";

    public void setDuracloudMillConfigService(DuracloudMillConfigService duracloudMillConfigService) {
        this.duracloudMillConfigService = duracloudMillConfigService;
    }

    @RequestMapping(value={""})
    public ModelAndView get() {
        ModelAndView mav = new ModelAndView(BASE_MAPPING);
        return mav;
    }

    @ModelAttribute(value="duracloudMill")
    public DuracloudMillForm form() {
        DuracloudMillForm form = new DuracloudMillForm();
        DuracloudMill entity = this.duracloudMillConfigService.get();
        if (entity == null) {
            return new DuracloudMillForm();
        }
        form.setDbHost(entity.getDbHost());
        form.setDbPort(entity.getDbPort());
        form.setDbName(entity.getDbName());
        form.setDbUsername(entity.getDbUsername());
        form.setDbPassword(entity.getDbPassword());
        form.setAuditQueue(entity.getAuditQueue());
        form.setAuditLogSpaceId(entity.getAuditLogSpaceId());
        return form;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public ModelAndView edit() {
        return new ModelAndView("/root/duracloudmill/edit");
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView update(@ModelAttribute(value="duracloudMill") @Valid DuracloudMillForm form, BindingResult bindingResult, Model model, RedirectAttributes redirectAttributes) {
        boolean hasErrors = bindingResult.hasErrors();
        if (hasErrors) {
            return new ModelAndView("/root/duracloudmill/edit");
        }
        this.duracloudMillConfigService.set(form.getDbHost(), form.getDbPort(), form.getDbName(), form.getDbUsername(), form.getDbPassword(), form.getAuditQueue(), form.getAuditLogSpaceId());
        UserFeedbackUtil.addSuccessFlash((String)"Successfully updated!", (RedirectAttributes)redirectAttributes);
        return new ModelAndView((View)new RedirectView(BASE_MAPPING, true));
    }
}

