/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import java.util.Set;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.Role;
import org.duracloud.account.db.util.DuracloudUserService;
import org.duracloud.account.util.UserFeedbackUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

public abstract class AbstractController {
    protected Logger log = LoggerFactory.getLogger(AbstractController.class);
    public static final String USERS_MAPPING = "/users";
    public static final String USER_MAPPING = "/byid/{username:[a-z0-9.\\-_@]*}";
    public static final String NEW_MAPPING = "/new";
    public static final String EDIT_MAPPING = "/edit";
    public static final String BY_ID_MAPPING = "/byid/{id}";
    public static final String BY_ID_EDIT_MAPPING = "/byid/{id}/edit";
    public static final String BY_ID_DELETE_MAPPING = "/byid/{id}/delete";

    public void init() {
        this.log.info("initializing " + this.toString());
    }

    public void destroy() {
        this.log.info("destroying " + this.toString());
    }

    @ModelAttribute(value="ownerRole")
    public Role getOwnerRole() {
        return Role.ROLE_OWNER;
    }

    @ModelAttribute(value="adminRole")
    public Role getAdminRole() {
        return Role.ROLE_ADMIN;
    }

    @ModelAttribute(value="userRole")
    public Role getUserRole() {
        return Role.ROLE_USER;
    }

    protected void setUserRights(DuracloudUserService userService, Long accountId, Long userId, Role role) {
        Set roles = role.getRoleHierarchy();
        userService.setUserRights(accountId, userId, roles.toArray(new Role[roles.size()]));
    }

    protected boolean accountHasMoreThanOneOwner(Set<DuracloudUser> users, Long accountId) {
        int ownerCount = 0;
        for (DuracloudUser u : users) {
            if (!u.isOwnerForAcct(accountId) || u.isRoot() || ++ownerCount <= 1) continue;
            return true;
        }
        return false;
    }

    @ExceptionHandler(value={Exception.class})
    public ModelAndView handleException(Exception e) {
        this.log.error(e.getMessage(), (Throwable)e);
        return new ModelAndView("exception", "ex", (Object)e);
    }

    protected static String formatUserUrl(String username) {
        String url = "/users/byid/{username:[a-z0-9.\\-_@]*}";
        url = url.replaceAll("\\{username.*\\}", username);
        return url;
    }

    protected void setError(Exception e) {
        this.setError(e, null);
    }

    protected void setError(Exception e, RedirectAttributes redirectAttributes) {
        this.log.error(e.getMessage(), (Throwable)e);
        UserFeedbackUtil.addFailureFlash((String)e.getMessage(), (RedirectAttributes)redirectAttributes);
    }

    protected ModelAndView createRedirectMav(String url) {
        RedirectView view = new RedirectView(url, true);
        view.setExposeModelAttributes(false);
        return new ModelAndView((View)view);
    }

    protected void setSuccessFeedback(String message, RedirectAttributes redirectAttributes) {
        UserFeedbackUtil.addSuccessFlash((String)message, (RedirectAttributes)redirectAttributes);
    }

    protected void setFailureFeedback(String message, RedirectAttributes redirectAttributes) {
        UserFeedbackUtil.addFailureFlash((String)message, (RedirectAttributes)redirectAttributes);
    }
}

