/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.validation.Valid;
import org.duracloud.account.app.controller.AbstractAccountController;
import org.duracloud.account.app.controller.AccountUserEditForm;
import org.duracloud.account.app.controller.AccountUsersController;
import org.duracloud.account.app.controller.InvitationForm;
import org.duracloud.account.app.controller.UserController;
import org.duracloud.account.app.controller.UsernameForm;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.Role;
import org.duracloud.account.db.model.UserInvitation;
import org.duracloud.account.db.model.util.DuracloudAccount;
import org.duracloud.account.db.util.AccountService;
import org.duracloud.account.db.util.error.AccountNotFoundException;
import org.duracloud.account.db.util.error.UnsentEmailException;
import org.duracloud.account.util.EmailAddressesParser;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@Lazy
public class AccountUsersController
extends AbstractAccountController {
    public static final String ACCOUNT_USERS_VIEW_ID = "account-users";
    public static final String ACCOUNT_USERS_EDIT_ID = "account-users-edit";
    public static final String EDIT_ACCOUNT_USERS_FORM_KEY = "accountUsersEditForm";
    private static final String USERNAME_FORM_KEY = "usernameForm";
    private static final String INVITATION_FORM_KEY = "invitationForm";
    public static final String ACCOUNT_USERS_PATH = "/users";
    public static final String ACCOUNT_USERS_MAPPING = "/byid/{accountId}/users";
    public static final String USERS_INVITATIONS_DELETE_MAPPING = "/byid/{accountId}/users/invitations/byid/{invitationId}/delete";
    public static final String USERS_DELETE_MAPPING = "/byid/{accountId}/users/byid/{userId}/delete";
    public static final String USERS_EDIT_MAPPING = "/byid/{accountId}/users/byid/{userId}/edit";
    public static final String USERS_KEY = "users";

    @ModelAttribute(value="invitationForm")
    public InvitationForm invitationForm() {
        return new InvitationForm();
    }

    @ModelAttribute(value="usernameForm")
    public UsernameForm usernameForm() {
        return new UsernameForm();
    }

    @ModelAttribute(value="accountUsersEditForm")
    public AccountUserEditForm accountUserEditForm() {
        return new AccountUserEditForm();
    }

    @RequestMapping(value={"/byid/{accountId}/users"}, method={RequestMethod.GET})
    public String get(@PathVariable Long accountId, Model model) throws Exception {
        this.addUserToModel(model);
        return this.get(this.getAccountService(accountId), model);
    }

    @Transactional
    @RequestMapping(value={"/byid/{accountId}/users/adduser"}, method={RequestMethod.POST})
    public ModelAndView addUser(@PathVariable Long accountId, @ModelAttribute(value="usernameForm") @Valid UsernameForm usernameForm, BindingResult result, Model model, RedirectAttributes redirectAttributes) throws Exception {
        String username = usernameForm.getUsername();
        this.log.debug("entering addUser: adding {} to account {}", (Object)username, (Object)accountId);
        if (result.hasErrors()) {
            this.addUserToModel(model);
            this.get(this.getAccountService(accountId), model);
            return new ModelAndView(ACCOUNT_USERS_VIEW_ID, model.asMap());
        }
        DuracloudUser user = this.userService.loadDuracloudUserByUsernameInternal(username);
        if (this.userService.addUserToAccount(accountId, user.getId())) {
            this.log.info("added user {} to account {}", new Object[]{username, accountId});
            String message = MessageFormat.format("Successfully added {0} to account.", username);
            this.setSuccessFeedback(message, redirectAttributes);
        }
        return this.createAccountRedirectModelAndView(accountId, ACCOUNT_USERS_PATH);
    }

    protected String get(AccountService accountService, Model model) throws Exception {
        this.loadAccountUsers(accountService, model);
        return ACCOUNT_USERS_VIEW_ID;
    }

    @Transactional
    @RequestMapping(value={"/byid/{accountId}/users"}, method={RequestMethod.POST})
    public ModelAndView sendInvitations(@PathVariable Long accountId, @ModelAttribute(value="invitationForm") @Valid InvitationForm invitationForm, BindingResult result, Model model, RedirectAttributes redirectAttributes) throws Exception {
        this.log.info("sending invitations from account {}", (Object)accountId);
        boolean hasErrors = result.hasErrors();
        AccountService service = this.getAccountService(accountId);
        if (!hasErrors) {
            List emailAddresses = EmailAddressesParser.parse((String)invitationForm.getEmailAddresses());
            ArrayList<String> failedEmailAddresses = new ArrayList<String>();
            String adminUsername = this.getUser().getUsername();
            for (String emailAddress : emailAddresses) {
                try {
                    UserInvitation ui = service.inviteUser(emailAddress, adminUsername);
                    String template = "Successfully created user invitation on account {0} for {1} expiring on {2}";
                    String message = MessageFormat.format(template, ui.getAccount().getId(), ui.getUserEmail(), ui.getExpirationDate());
                    this.log.info(message);
                }
                catch (UnsentEmailException e) {
                    failedEmailAddresses.add(emailAddress);
                }
            }
            if (!failedEmailAddresses.isEmpty()) {
                String template = "Unable to send an email to the following recipients, but the user has been added: {0}";
                String message = MessageFormat.format(template, failedEmailAddresses);
                result.addError(new ObjectError("emailAddresses", message));
                hasErrors = true;
            }
        }
        if (hasErrors) {
            this.addUserToModel(model);
            this.get(service, model);
            return new ModelAndView(ACCOUNT_USERS_VIEW_ID);
        }
        this.setSuccessFeedback("Successfully sent invitations.", redirectAttributes);
        return this.createAccountRedirectModelAndView(accountId, ACCOUNT_USERS_PATH);
    }

    @Transactional
    @RequestMapping(value={"/byid/{accountId}/users/invitations/byid/{invitationId}/delete"}, method={RequestMethod.POST})
    public ModelAndView deleteUserInvitation(@PathVariable Long accountId, @PathVariable Long invitationId, Model model) throws Exception {
        this.log.info("remove invitation {} from account {}", (Object)invitationId, (Object)accountId);
        AccountService service = this.getAccountService(accountId);
        service.deleteUserInvitation(invitationId);
        return this.createAccountRedirectModelAndView(accountId, ACCOUNT_USERS_PATH);
    }

    @Transactional
    @RequestMapping(value={"/byid/{accountId}/users/byid/{userId}/delete"}, method={RequestMethod.POST})
    public ModelAndView deleteUserFromAccount(@PathVariable Long accountId, @PathVariable Long userId, Model model) throws Exception {
        this.log.info("delete user {} from account {}", (Object)userId, (Object)accountId);
        this.userService.revokeUserRights(accountId, userId);
        DuracloudUser user = this.getUser();
        if (user.getId() == userId) {
            RedirectView redirect = UserController.formatUserRedirect((String)user.getUsername());
            return new ModelAndView((View)redirect);
        }
        return this.createAccountRedirectModelAndView(accountId, ACCOUNT_USERS_PATH);
    }

    @RequestMapping(value={"/byid/{accountId}/users/byid/{userId}/edit"}, method={RequestMethod.GET})
    public String getEditUserForm(@PathVariable Long accountId, @PathVariable Long userId, Model model) throws Exception {
        this.log.info("getEditUserForm user {} account {}", (Object)userId, (Object)accountId);
        AccountService accountService = this.getAccountService(accountId);
        Set users = accountService.getUsers();
        for (DuracloudUser u : users) {
            if (u.getId() != userId) continue;
            AccountUser au = new AccountUser(this, u.getId(), u.getUsername(), u.getFirstName(), u.getLastName(), u.getEmail(), InvitationStatus.ACTIVE, u.getRoleByAcct(accountId), u.getAllowableIPAddressRange(), false);
            model.addAttribute("user", (Object)au);
            break;
        }
        this.loadAccountInfo(accountId, model);
        return ACCOUNT_USERS_EDIT_ID;
    }

    @Transactional
    @RequestMapping(value={"/byid/{accountId}/users/byid/{userId}/edit"}, method={RequestMethod.POST})
    public ModelAndView editUser(@PathVariable Long accountId, @PathVariable Long userId, @ModelAttribute(value="accountUsersEditForm") AccountUserEditForm accountUserEditForm, BindingResult result, Model model, RedirectAttributes redirectAttributes) throws Exception {
        this.log.debug("editUser account {}", (Object)accountId);
        boolean hasErrors = result.hasErrors();
        if (!hasErrors) {
            Role role = Role.valueOf((String)accountUserEditForm.getRole());
            this.log.info("New role: {}", (Object)role);
            try {
                this.setUserRights(this.userService, accountId, userId, role);
                this.setSuccessFeedback("Successfully changed user role.", redirectAttributes);
            }
            catch (AccessDeniedException e) {
                result.addError(new ObjectError("role", "You are unauthorized to set the role for this user"));
                hasErrors = true;
            }
        }
        if (hasErrors) {
            this.addUserToModel(model);
            return new ModelAndView(ACCOUNT_USERS_VIEW_ID, model.asMap());
        }
        return this.createAccountRedirectModelAndView(accountId, ACCOUNT_USERS_PATH);
    }

    private AccountService getAccountService(Long accountId) throws AccountNotFoundException {
        return this.accountManagerService.getAccount(accountId);
    }

    private void loadAccountUsers(AccountService accountService, Model model) throws Exception {
        AccountInfo accountInfo = accountService.retrieveAccountInfo();
        model.addAttribute("accountInfo", (Object)accountInfo);
        Set users = accountService.getUsers();
        Set pendingUserInvitations = accountService.getPendingInvitations();
        DuracloudUser caller = this.getUser();
        DuracloudAccount duracloudAccount = new DuracloudAccount();
        duracloudAccount.setAccountInfo(accountInfo);
        duracloudAccount.setUserRole(caller.getRoleByAcct(accountInfo.getId()));
        model.addAttribute("account", (Object)duracloudAccount);
        List accountUsers = this.buildUserList(accountInfo.getId(), users, caller);
        Collections.sort(accountUsers);
        this.addInvitationsToModel(pendingUserInvitations, accountService, model);
        model.addAttribute(USERS_KEY, (Object)accountUsers);
    }

    private void addInvitationsToModel(Set<UserInvitation> pendingUserInvitations, AccountService accountService, Model model) throws Exception {
        TreeSet<PendingAccountUser> pendingUsers = new TreeSet<PendingAccountUser>();
        for (UserInvitation ui : pendingUserInvitations) {
            pendingUsers.add(new PendingAccountUser(this, ui, Role.ROLE_USER));
        }
        model.addAttribute("pendingUserInvitations", pendingUsers);
    }

    private List<AccountUser> buildUserList(Long accountId, Set<DuracloudUser> users, DuracloudUser caller) {
        LinkedList<AccountUser> list = new LinkedList<AccountUser>();
        for (DuracloudUser u : users) {
            Role role = u.getRoleByAcct(accountId);
            AccountUser au = new AccountUser(this, u.getId(), u.getUsername(), u.getFirstName(), u.getLastName(), u.getEmail(), InvitationStatus.ACTIVE, role, u.getAllowableIPAddressRange(), caller.isRoot() || caller.isOwnerForAcct(accountId) || caller.isAdminForAcct(accountId) && (role.equals((Object)Role.ROLE_USER) || role.equals((Object)Role.ROLE_ADMIN)));
            list.add(au);
        }
        return list;
    }
}

