/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.validation.Valid;
import org.duracloud.account.app.controller.AbstractRootController;
import org.duracloud.account.app.controller.UsernameForm;
import org.duracloud.account.app.model.User;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.util.DuracloudUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@Lazy
@RequestMapping(value={"/root/rootusers"})
public class RootUsersController
extends AbstractRootController {
    public static final String BASE_MAPPING = "/root/rootusers";
    private static final String BASE_VIEW = "/root/rootusers";
    private static final String USERNAME_FORM_KEY = "usernameForm";
    public static final String EDIT_ACCOUNT_ROOT_USERS_FORM_KEY = "accountRootUsersEditForm";
    @Autowired
    private DuracloudUserService userService;

    @ModelAttribute(value="usernameForm")
    public UsernameForm usernameForm() {
        return new UsernameForm();
    }

    @RequestMapping(value={""})
    public ModelAndView get() {
        ArrayList<User> u = new ArrayList<User>();
        Set root_users = this.getRootAccountManagerService().listAllRootUsers(null);
        for (DuracloudUser root_user : root_users) {
            HashSet accounts = new HashSet();
            u.add(new User(root_user.getId(), root_user.getUsername(), root_user.getFirstName(), root_user.getLastName(), root_user.getEmail(), root_user.getAllowableIPAddressRange(), accounts, root_user.isRoot()));
        }
        Collections.sort(u);
        ModelAndView mav = new ModelAndView("/root/rootusers");
        mav.addObject("rootusers", u);
        return mav;
    }

    @Transactional
    @RequestMapping(value={"/set-root"}, method={RequestMethod.POST})
    public ModelAndView setRootUser(@ModelAttribute(value="usernameForm") @Valid UsernameForm usernameForm, BindingResult result, RedirectAttributes redirectAttributes) throws Exception {
        String username = usernameForm.getUsername();
        this.log.debug("set root on user {}.", (Object)username);
        if (result.hasErrors()) {
            return new ModelAndView("/root/rootusers");
        }
        DuracloudUser user = this.userService.loadDuracloudUserByUsernameInternal(username);
        this.getRootAccountManagerService().setRootUser(user.getId());
        if (user.isRoot()) {
            this.log.info("user {} is now root", new Object[]{username});
            String message = MessageFormat.format("Successfully set root on user {0}.", username);
            this.setSuccessFeedback(message, redirectAttributes);
        }
        return this.createRedirectMav("/root/rootusers");
    }

    @Transactional
    @RequestMapping(value={"/byid/{id}/unset-root"}, method={RequestMethod.POST})
    public ModelAndView unsetRootUser(@PathVariable Long id, RedirectAttributes redirectAttributes) throws Exception {
        this.log.debug("unset root on user {}.", (Object)id);
        this.getRootAccountManagerService().unsetRootUser(id);
        DuracloudUser user = this.getUserService().loadDuracloudUserByIdInternal(id);
        String message = MessageFormat.format("{0} is no longer root.", user.getUsername());
        this.setSuccessFeedback(message, redirectAttributes);
        return this.createRedirectMav("/root/rootusers");
    }

    protected DuracloudUserService getUserService() {
        return this.userService;
    }

    public void setUserService(DuracloudUserService userService) {
        this.userService = userService;
    }
}

