/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.annotation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.duracloud.account.annotation.UsernameExists;
import org.duracloud.account.db.util.DuracloudUserService;
import org.duracloud.account.db.util.error.InvalidUsernameException;
import org.duracloud.account.db.util.error.UserAlreadyExistsException;
import org.springframework.beans.factory.annotation.Autowired;

public class UsernameExistsValidator
implements ConstraintValidator<UsernameExists, String> {
    @Autowired(required=true)
    private DuracloudUserService duracloudUserService;

    public boolean isValid(String value, ConstraintValidatorContext context) {
        try {
            this.duracloudUserService.checkUsername(value);
            return false;
        }
        catch (InvalidUsernameException ex) {
            return false;
        }
        catch (UserAlreadyExistsException ex) {
            return true;
        }
    }

    public void initialize(UsernameExists constraintAnnotation) {
    }

    public DuracloudUserService getUserService() {
        return this.duracloudUserService;
    }

    public void setUserService(DuracloudUserService duracloudUserService) {
        this.duracloudUserService = duracloudUserService;
    }
}

