/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import java.text.MessageFormat;
import java.util.List;
import javax.validation.Valid;
import org.duracloud.account.app.controller.AbstractRootController;
import org.duracloud.account.app.controller.AccountSetupForm;
import org.duracloud.account.config.AmaEndpoint;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.StorageProviderAccount;
import org.duracloud.account.db.util.AccountService;
import org.duracloud.account.db.util.RootAccountManagerService;
import org.duracloud.account.db.util.error.AccountNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/root/accounts"})
public class AccountsController
extends AbstractRootController {
    public static final String BASE_MAPPING = "/root/accounts";
    private static final String BASE_VIEW = "/root/accounts";
    private static final String ACCOUNT_SETUP_VIEW = "/root/accounts/setup";
    public static final String ACCOUNT_SETUP_MAPPING = "/byid/{id}/setup";
    private static final String SETUP_ACCOUNT_FORM_KEY = "setupAccountForm";
    @Autowired
    private AmaEndpoint amaEndpoint;

    @RequestMapping(value={""})
    public ModelAndView get() {
        ModelAndView mav = new ModelAndView("/root/accounts", "accounts", (Object)this.getRootAccountManagerService().listAllAccounts(null));
        mav.addObject("mcDomain", (Object)this.amaEndpoint.getDomain());
        return mav;
    }

    @RequestMapping(value={"/byid/{id}/delete"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView delete(@PathVariable Long id, RedirectAttributes redirectAttributes) throws AccountNotFoundException {
        AccountService accountService = this.getAccountManagerService().getAccount(id);
        String accountName = accountService.retrieveAccountInfo().getAcctName();
        this.getRootAccountManagerService().deleteAccount(id);
        String message = MessageFormat.format("Successfully deleted account ({0}).", accountName);
        this.setSuccessFeedback(message, redirectAttributes);
        return this.createRedirectMav("/root/accounts");
    }

    @RequestMapping(value={"/byid/{id}/activate"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView activate(@PathVariable Long id, RedirectAttributes redirectAttributes) throws AccountNotFoundException {
        AccountService accountService = this.getAccountManagerService().getAccount(id);
        accountService.storeAccountStatus(AccountInfo.AccountStatus.ACTIVE);
        String accountName = accountService.retrieveAccountInfo().getAcctName();
        String message = MessageFormat.format("Successfully activated account ({0}).", accountName);
        this.setSuccessFeedback(message, redirectAttributes);
        return this.createRedirectMav("/root/accounts");
    }

    @RequestMapping(value={"/byid/{id}/deactivate"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView deactivate(@PathVariable Long id, RedirectAttributes redirectAttributes) throws AccountNotFoundException {
        AccountService accountService = this.getAccountManagerService().getAccount(id);
        accountService.storeAccountStatus(AccountInfo.AccountStatus.INACTIVE);
        String accountName = accountService.retrieveAccountInfo().getAcctName();
        String message = MessageFormat.format("Successfully deactivated account ({0}).", accountName);
        this.setSuccessFeedback(message, redirectAttributes);
        return this.createRedirectMav("/root/accounts");
    }

    @RequestMapping(value={"/byid/{id}/setup"}, method={RequestMethod.GET})
    public String getSetupAccount(@PathVariable Long id, Model model) throws Exception {
        this.log.info("setup account {}", (Object)id);
        AccountService as = this.getAccountManagerService().getAccount(id);
        StorageProviderAccount primary = as.getPrimaryStorageProvider();
        RootAccountManagerService rams = this.getRootAccountManagerService();
        AccountInfo info = rams.getAccount(id);
        List secondary = rams.getSecondaryStorageProviders(id);
        AccountSetupForm form = new AccountSetupForm(primary, secondary);
        model.addAttribute("accountInfo", (Object)info);
        model.addAttribute(SETUP_ACCOUNT_FORM_KEY, (Object)form);
        model.addAttribute("pending", (Object)info.getStatus().equals((Object)AccountInfo.AccountStatus.PENDING));
        return ACCOUNT_SETUP_VIEW;
    }

    @RequestMapping(value={"/byid/{id}/setup"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView setupAccount(@PathVariable Long id, @ModelAttribute(value="setupAccountForm") @Valid AccountSetupForm accountSetupForm, BindingResult result, Model model, RedirectAttributes redirectAttributes) throws Exception {
        this.log.info("setup account {}", (Object)id);
        RootAccountManagerService rams = this.getRootAccountManagerService();
        AccountInfo info = rams.getAccount(id);
        model.addAttribute("accountInfo", (Object)info);
        if (result.hasErrors()) {
            model.addAttribute("pending", (Object)info.getStatus().equals((Object)AccountInfo.AccountStatus.PENDING));
            return new ModelAndView(ACCOUNT_SETUP_VIEW, model.asMap());
        }
        this.saveStorageProvider(accountSetupForm.getPrimaryStorageProviderSettings());
        for (AccountSetupForm.StorageProviderSettings sp : accountSetupForm.getSecondaryStorageProviderSettingsList()) {
            this.saveStorageProvider(sp);
        }
        Object message = MessageFormat.format("Successfully configured providers for {0}", info.getAcctName());
        AccountInfo.AccountStatus status = info.getStatus();
        if (AccountInfo.AccountStatus.PENDING.equals((Object)status)) {
            this.getRootAccountManagerService().activateAccount(id);
            message = (String)message + " and activated acccount";
        }
        this.setSuccessFeedback((String)message, redirectAttributes);
        return this.createRedirectMav("/root/accounts");
    }

    private void saveStorageProvider(AccountSetupForm.StorageProviderSettings storageProviderSettings) {
        this.getRootAccountManagerService().setupStorageProvider(storageProviderSettings.getId(), storageProviderSettings.getUsername(), storageProviderSettings.getPassword(), storageProviderSettings.getProperties(), Integer.parseInt(storageProviderSettings.getStorageLimit()));
    }

    public void setAmaEndpoint(AmaEndpoint amaEndpoint) {
        this.amaEndpoint = amaEndpoint;
    }
}

