/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.duracloud.account.app.controller.AbstractController;
import org.duracloud.account.app.controller.AnonymousChangePasswordForm;
import org.duracloud.account.app.controller.ChangePasswordForm;
import org.duracloud.account.app.controller.ForgotPasswordForm;
import org.duracloud.account.app.controller.NewUserForm;
import org.duracloud.account.app.controller.UserProfileEditForm;
import org.duracloud.account.config.AmaEndpoint;
import org.duracloud.account.db.model.AccountInfo;
import org.duracloud.account.db.model.DuracloudUser;
import org.duracloud.account.db.model.InstanceType;
import org.duracloud.account.db.model.UserInvitation;
import org.duracloud.account.db.model.util.DuracloudAccount;
import org.duracloud.account.db.util.AccountManagerService;
import org.duracloud.account.db.util.DuracloudUserService;
import org.duracloud.account.db.util.error.DBNotFoundException;
import org.duracloud.account.db.util.error.InvalidPasswordException;
import org.duracloud.account.db.util.error.InvalidRedemptionCodeException;
import org.duracloud.account.db.util.error.UnsentEmailException;
import org.duracloud.account.util.UserFeedbackUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.binding.message.Severity;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@Lazy
@RequestMapping(value={"/users"})
public class UserController
extends AbstractController {
    protected static final String FORGOT_PASSWORD_SUCCESS_VIEW = "forgot-password-success";
    private static final String ANONYMOUS_CHANGE_PASSWORD_VIEW = "anonymous-change-password";
    private static final String ANONYMOUS_CHANGE_PASSWORD_FAILURE_VIEW = "anonymous-change-password-failure";
    public static final String USER_KEY = "user";
    public static final String NEW_USER_VIEW = "user-new";
    public static final String FORGOT_PASSWORD_VIEW = "forgot-password";
    public static final String USER_HOME = "user-home";
    public static final String FORGOT_PASSWORD_MAPPING = "/forgot-password";
    public static final String USER_ACCOUNTS = "user-accounts";
    public static final String USER_EDIT_MAPPING = "/byid/{username:[a-z0-9.\\-_@]*}/edit";
    public static final String USER_ACCOUNTS_MAPPING = "/byid/{username:[a-z0-9.\\-_@]*}/accounts";
    public static final String USER_EDIT_VIEW = "user-edit";
    public static final String CHANGE_PASSWORD_MAPPING = "/byid/{username:[a-z0-9.\\-_@]*}/change-password";
    public static final String CHANGE_PASSWORD_VIEW = "user-change-password";
    public static final String USER_PROFILE_FORM_KEY = "userProfileEditForm";
    public static final String CHANGE_PASSWORD_FORM_KEY = "changePasswordForm";
    public static final String FORGOT_PASSWORD_FORM_KEY = "forgotPasswordForm";
    public static final String NEW_USER_FORM_KEY = "newUserForm";
    public static final String NEW_INSTANCE_FORM = "instanceForm";
    @Autowired
    private AccountManagerService accountManagerService;
    @Autowired
    private DuracloudUserService userService;
    @Autowired
    private AmaEndpoint amaEndpoint;

    public void setUserService(DuracloudUserService userService) {
        if (userService == null) {
            throw new NullPointerException("userService must be non-null");
        }
        this.userService = userService;
        this.log.info("new instance created: " + this.getClass().getName());
    }

    public DuracloudUserService getUserService() {
        return this.userService;
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public ModelAndView getNewForm(HttpServletRequest request) {
        this.log.info("serving up NewUserForm");
        NewUserForm newUserForm = new NewUserForm();
        newUserForm.setRedemptionCode(this.removeRedemptionCodeFromSession(request));
        return new ModelAndView("user-new", "newUserForm", (Object)newUserForm);
    }

    @RequestMapping(value={"/forgot-password"}, method={RequestMethod.GET})
    public ModelAndView getForgotPasswordForm(HttpServletRequest request) {
        this.log.info("serving up ForgotPasswordForm");
        ForgotPasswordForm forgotPasswordForm = new ForgotPasswordForm();
        return new ModelAndView("forgot-password", "forgotPasswordForm", (Object)forgotPasswordForm);
    }

    @ModelAttribute(value="instanceTypes")
    public InstanceType[] instanceTypes() {
        return InstanceType.values();
    }

    @RequestMapping(value={"/profile"}, method={RequestMethod.GET})
    public ModelAndView profileRedirect() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth.isAuthenticated() && auth instanceof AnonymousAuthenticationToken) {
            auth.setAuthenticated(false);
            return new ModelAndView("redirect:/users/profile");
        }
        String username = auth.getName();
        return new ModelAndView((View)UserController.formatUserRedirect((String)username));
    }

    @RequestMapping(value={"/byid/{username:[a-z0-9.\\-_@]*}"}, method={RequestMethod.GET})
    public ModelAndView getUser(@PathVariable String username, HttpServletRequest request) throws DBNotFoundException {
        this.log.debug("getting user {}", (Object)username);
        String redemptionCode = this.removeRedemptionCodeFromSession(request);
        if (redemptionCode != null) {
            this.log.debug("redemption code found in session: {}", (Object)redemptionCode);
            DuracloudUser user = this.userService.loadDuracloudUserByUsername(username);
            try {
                this.userService.redeemAccountInvitation(user.getId(), redemptionCode);
                user = this.userService.loadDuracloudUserByUsername(username);
            }
            catch (InvalidRedemptionCodeException e) {
                this.log.error("redemption failed for {} on redemption {}", (Object)username, (Object)redemptionCode);
                this.addRedemptionFailedMessage();
            }
        }
        return this.getUserAccounts(username);
    }

    private void addRedemptionFailedMessage() {
        this.addErrorMessage("The redemption code you supplied is invalid. We are unable to add you to an account.");
    }

    private String removeRedemptionCodeFromSession(HttpServletRequest request) {
        String redemptionCode = (String)request.getSession().getAttribute("redemptionCode");
        if (redemptionCode != null) {
            request.getSession().removeAttribute("redemptionCode");
        }
        return redemptionCode;
    }

    @RequestMapping(value={"/byid/{username:[a-z0-9.\\-_@]*}/accounts"}, method={RequestMethod.GET})
    public ModelAndView getUserAccounts(@PathVariable String username) throws DBNotFoundException {
        this.log.debug("getting user accounts for {}", (Object)username);
        ModelAndView mav = new ModelAndView("user-accounts");
        this.prepareModel(username, mav);
        return mav;
    }

    @RequestMapping(value={"/byid/{username:[a-z0-9.\\-_@]*}/edit"}, method={RequestMethod.GET})
    public String edit(@PathVariable String username, Model model) throws DBNotFoundException {
        this.log.debug("getting user accounts for {}", (Object)username);
        UserProfileEditForm form = new UserProfileEditForm();
        DuracloudUser user = this.userService.loadDuracloudUserByUsername(username);
        form.setFirstName(user.getFirstName());
        form.setLastName(user.getLastName());
        form.setEmail(user.getEmail());
        form.setAllowableIPAddressRange(user.getAllowableIPAddressRange());
        form.setSecurityQuestion(user.getSecurityQuestion());
        form.setSecurityAnswer(user.getSecurityAnswer());
        model.addAttribute("userProfileEditForm", (Object)form);
        model.addAttribute("changePasswordForm", (Object)new ChangePasswordForm());
        this.addUserToModel(user, model);
        return "user-edit";
    }

    @Transactional
    @RequestMapping(value={"/byid/{username:[a-z0-9.\\-_@]*}/edit"}, method={RequestMethod.POST})
    public ModelAndView update(@PathVariable String username, @ModelAttribute(value="userProfileEditForm") @Valid UserProfileEditForm form, BindingResult result, Model model) throws Exception {
        if (result.hasErrors()) {
            this.log.debug("profile form has errors for {}: returning...", (Object)username);
            model.addAttribute("changePasswordForm", (Object)new ChangePasswordForm());
            DuracloudUser user = this.userService.loadDuracloudUserByUsername(username);
            this.addUserToModel(user, model);
            return new ModelAndView("user-edit", model.asMap());
        }
        this.log.info("updating user profile for {}", (Object)username);
        Long id = this.userService.loadDuracloudUserByUsername(username).getId();
        this.userService.storeUserDetails(id, form.getFirstName(), form.getLastName(), form.getEmail(), form.getSecurityQuestion(), form.getSecurityAnswer(), form.getAllowableIPAddressRange());
        return new ModelAndView((View)UserController.formatUserRedirect((String)username));
    }

    @RequestMapping(value={"/byid/{username:[a-z0-9.\\-_@]*}/change-password"}, method={RequestMethod.GET})
    public String changePassword(@PathVariable String username, Model model) throws DBNotFoundException {
        this.log.debug("opening change password form  for {}", (Object)username);
        model.addAttribute("changePasswordForm", (Object)new ChangePasswordForm());
        this.addUserToModel(this.userService.loadDuracloudUserByUsername(username), model);
        return "user-change-password";
    }

    @Transactional
    @RequestMapping(value={"/byid/{username:[a-z0-9.\\-_@]*}/change-password"}, method={RequestMethod.POST})
    public ModelAndView changePassword(@PathVariable String username, @ModelAttribute(value="changePasswordForm") @Valid ChangePasswordForm form, BindingResult result, Model model) throws Exception {
        DuracloudUser user = this.userService.loadDuracloudUserByUsername(username);
        if (!result.hasErrors()) {
            this.log.info("changing user password for {}", (Object)username);
            Long id = user.getId();
            try {
                this.userService.changePassword(id, form.getOldPassword(), false, form.getPassword());
                return new ModelAndView((View)UserController.formatUserRedirect((String)username));
            }
            catch (InvalidPasswordException e) {
                result.addError((ObjectError)new FieldError("changePasswordForm", "oldPassword", "The old password is not correct"));
            }
        }
        this.log.debug("password form has errors for {}: returning...", (Object)username);
        this.addUserToModel(user, model);
        UserProfileEditForm editForm = new UserProfileEditForm();
        editForm.setFirstName(user.getFirstName());
        editForm.setLastName(user.getLastName());
        editForm.setEmail(user.getEmail());
        editForm.setSecurityQuestion(user.getSecurityQuestion());
        editForm.setSecurityAnswer(user.getSecurityAnswer());
        model.addAttribute("userProfileEditForm", (Object)editForm);
        return new ModelAndView("user-edit", model.asMap());
    }

    @RequestMapping(value={"/change-password/{redemptionCode}"}, method={RequestMethod.GET})
    public String anonymousPasswordChange(@PathVariable String redemptionCode, Model model) throws DBNotFoundException {
        this.log.debug("opening change password form  for invitation {}", (Object)redemptionCode);
        if (this.checkRedemptionCode(redemptionCode, model) == null) {
            return "anonymous-change-password-failure";
        }
        model.addAttribute("changePasswordForm", (Object)new AnonymousChangePasswordForm());
        return "anonymous-change-password";
    }

    protected UserInvitation checkRedemptionCode(String redemptionCode, Model model) {
        try {
            return this.userService.retrievePassordChangeInvitation(redemptionCode);
        }
        catch (DBNotFoundException ex) {
            model.addAttribute("message", (Object)UserFeedbackUtil.create((Severity)Severity.ERROR, (String)"This invitation is not valid."));
            return null;
        }
    }

    @Transactional
    @RequestMapping(value={"/change-password/{redemptionCode}"}, method={RequestMethod.POST})
    public String anonymousPasswordChange(@PathVariable String redemptionCode, @ModelAttribute(value="changePasswordForm") @Valid AnonymousChangePasswordForm form, BindingResult result, Model model) throws Exception {
        UserInvitation invitation = this.checkRedemptionCode(redemptionCode, model);
        if (invitation == null) {
            return "anonymous-change-password-failure";
        }
        String username = invitation.getAdminUsername();
        DuracloudUser user = this.userService.loadDuracloudUserByUsernameInternal(username);
        if (!result.hasErrors()) {
            this.log.info("changing user password for {}", (Object)username);
            Long id = user.getId();
            try {
                this.userService.changePasswordInternal(id, user.getPassword(), true, form.getPassword());
                this.userService.redeemPasswordChangeRequest(user.getId(), redemptionCode);
                model.addAttribute("adminUrl", (Object)this.amaEndpoint.getUrl());
                return "anonymous-change-password-success";
            }
            catch (InvalidPasswordException e) {
                result.addError((ObjectError)new FieldError("changePasswordForm", "oldPassword", "The old password is not correct"));
            }
        }
        return "anonymous-change-password";
    }

    private void prepareModel(DuracloudUser user, ModelAndView mav) {
        mav.addObject("user", (Object)user);
        Set accounts = this.accountManagerService.findAccountsByUserId(user.getId());
        ArrayList<DuracloudAccount> activeAccounts = new ArrayList<DuracloudAccount>();
        ArrayList<DuracloudAccount> inactiveAccounts = new ArrayList<DuracloudAccount>();
        ArrayList<DuracloudAccount> pendingAccounts = new ArrayList<DuracloudAccount>();
        for (AccountInfo acctInfo : accounts) {
            DuracloudAccount duracloudAccount = this.loadAccountInstances(acctInfo, user);
            AccountInfo.AccountStatus status = acctInfo.getStatus();
            if (AccountInfo.AccountStatus.ACTIVE.equals((Object)status)) {
                activeAccounts.add(duracloudAccount);
                continue;
            }
            if (AccountInfo.AccountStatus.INACTIVE.equals((Object)status)) {
                inactiveAccounts.add(duracloudAccount);
                continue;
            }
            if (!AccountInfo.AccountStatus.PENDING.equals((Object)status)) continue;
            pendingAccounts.add(duracloudAccount);
        }
        Collections.sort(activeAccounts);
        Collections.sort(inactiveAccounts);
        Collections.sort(pendingAccounts);
        mav.addObject("activeAccounts", activeAccounts);
        mav.addObject("inactiveAccounts", inactiveAccounts);
        mav.addObject("pendingAccounts", pendingAccounts);
        mav.addObject("mcDomain", (Object)this.amaEndpoint.getDomain());
    }

    private DuracloudAccount loadAccountInstances(AccountInfo accountInfo, DuracloudUser user) {
        DuracloudAccount duracloudAccount = new DuracloudAccount();
        duracloudAccount.setAccountInfo(accountInfo);
        duracloudAccount.setUserRole(user.getRoleByAcct(accountInfo.getId()));
        return duracloudAccount;
    }

    private void addUserToModel(DuracloudUser user, Model model) {
        model.addAttribute("user", (Object)user);
    }

    private void prepareModel(String username, ModelAndView mav) {
        try {
            DuracloudUser user = this.userService.loadDuracloudUserByUsernameInternal(username);
            this.prepareModel(user, mav);
        }
        catch (DBNotFoundException e) {
            throw new AccessDeniedException("Access is denied", (Throwable)e);
        }
    }

    @Transactional
    @RequestMapping(value={"/new"}, method={RequestMethod.POST})
    public ModelAndView add(@ModelAttribute(value="newUserForm") @Valid NewUserForm newUserForm, BindingResult result, Model model, RedirectAttributes redirectAttributes) throws Exception {
        String name = null == newUserForm ? "null" : newUserForm.getUsername();
        this.log.debug("Add new user: {}", (Object)name);
        if (result.hasErrors()) {
            return new ModelAndView("user-new", model.asMap());
        }
        DuracloudUser user = this.userService.createNewUser(newUserForm.getUsername(), newUserForm.getPassword(), newUserForm.getFirstName(), newUserForm.getLastName(), newUserForm.getEmail(), newUserForm.getSecurityQuestion(), newUserForm.getSecurityAnswer());
        String redemptionCode = newUserForm.getRedemptionCode();
        Long accountId = -1L;
        if (!StringUtils.isEmpty((String)redemptionCode)) {
            try {
                accountId = this.userService.redeemAccountInvitation(user.getId(), redemptionCode);
            }
            catch (InvalidRedemptionCodeException ex) {
                this.addRedemptionFailedMessage();
            }
        }
        Object userUrl = UserController.formatUserUrl((String)newUserForm.getUsername());
        if (accountId > -1L) {
            userUrl = (String)userUrl + "?accountId=" + accountId;
        }
        ModelAndView mav = new ModelAndView("user-new-success");
        mav.addObject("userUrl", userUrl);
        return mav;
    }

    protected static RedirectView formatUserRedirect(String username) {
        String redirect = UserController.formatUserUrl((String)username);
        RedirectView view = new RedirectView(redirect, true);
        view.setExposeModelAttributes(false);
        return view;
    }

    @Transactional
    @RequestMapping(value={"/forgot-password"}, method={RequestMethod.POST})
    public String forgotPassword(@ModelAttribute(value="forgotPasswordForm") @Valid ForgotPasswordForm forgotPasswordForm, BindingResult result, Model model, HttpServletRequest request) throws Exception {
        model.addAttribute("forgotPasswordForm", (Object)forgotPasswordForm);
        if (!result.hasErrors()) {
            try {
                String username = forgotPasswordForm.getUsername();
                if (StringUtils.isEmpty((String)forgotPasswordForm.getSecurityQuestion())) {
                    DuracloudUser user = this.userService.loadDuracloudUserByUsernameInternal(username);
                    forgotPasswordForm.setSecurityQuestion(user.getSecurityQuestion());
                }
                if (StringUtils.isEmpty((String)forgotPasswordForm.getSecurityAnswer())) {
                    return "forgot-password";
                }
                this.userService.forgotPassword(username, forgotPasswordForm.getSecurityQuestion(), forgotPasswordForm.getSecurityAnswer());
            }
            catch (DBNotFoundException e) {
                result.addError((ObjectError)new FieldError("forgotPasswordForm", "username", "The username does not exist"));
                return "forgot-password";
            }
            catch (InvalidPasswordException e) {
                result.addError((ObjectError)new FieldError("forgotPasswordForm", "securityQuestion", "The security answer is not correct"));
                return "forgot-password";
            }
            catch (UnsentEmailException ue) {
                result.addError(new ObjectError("forgotPasswordForm", "Unable to send email to the address associated with the username"));
                return "forgot-password";
            }
            return "forgot-password-success";
        }
        return "forgot-password";
    }

    private void addErrorMessage(String string) {
    }

    @RequestMapping(value={"/redeem/{redemptionCode}"}, method={RequestMethod.GET})
    public ModelAndView redeemUser(HttpServletRequest request, @PathVariable String redemptionCode) throws DBNotFoundException {
        this.log.info("getting redeem invitation {}", (Object)redemptionCode);
        request.getSession().setAttribute("redemptionCode", (Object)redemptionCode);
        ModelAndView mav = new ModelAndView("home");
        mav.addObject("redemptionCode", (Object)redemptionCode);
        return mav;
    }

    public void setAccountManagerService(AccountManagerService accountManagerService) {
        this.accountManagerService = accountManagerService;
    }

    public AccountManagerService getAccountManagerService() {
        return this.accountManagerService;
    }

    public void setAmaEndpoint(AmaEndpoint amaEndpoint) {
        this.amaEndpoint = amaEndpoint;
    }
}

