/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import javax.validation.Valid;
import org.duracloud.account.app.controller.DuracloudMillForm;
import org.duracloud.account.db.model.DuracloudMill;
import org.duracloud.account.db.model.RabbitmqConfig;
import org.duracloud.account.db.util.DuracloudMillConfigService;
import org.duracloud.account.db.util.RabbitmqConfigService;
import org.duracloud.account.util.UserFeedbackUtil;
import org.duracloud.common.queue.QueueType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/root/duracloudmill"})
public class DuracloudMillController {
    @Autowired
    private DuracloudMillConfigService duracloudMillConfigService;
    public static final String BASE_MAPPING = "/root/duracloudmill";
    @Autowired
    private RabbitmqConfigService rabbitmqConfigService;

    public void setDuracloudMillConfigService(DuracloudMillConfigService duracloudMillConfigService) {
        this.duracloudMillConfigService = duracloudMillConfigService;
    }

    public void setRabbitmqConfigService(RabbitmqConfigService rabbitmqConfigService) {
        this.rabbitmqConfigService = rabbitmqConfigService;
    }

    @RequestMapping(value={""})
    public ModelAndView get() {
        ModelAndView mav = new ModelAndView(BASE_MAPPING);
        return mav;
    }

    @ModelAttribute(value="duracloudMill")
    public DuracloudMillForm form() {
        DuracloudMillForm form = new DuracloudMillForm();
        DuracloudMill entity = this.duracloudMillConfigService.get();
        if (entity == null) {
            return new DuracloudMillForm();
        }
        form.setDbHost(entity.getDbHost());
        form.setDbPort(entity.getDbPort());
        form.setDbName(entity.getDbName());
        form.setDbUsername(entity.getDbUsername());
        form.setDbPassword(entity.getDbPassword());
        form.setAuditQueue(entity.getAuditQueue());
        form.setAuditLogSpaceId(entity.getAuditLogSpaceId());
        form.setQueueType(entity.getQueueType());
        form.setRabbitmqExchange(entity.getRabbitmqExchange());
        RabbitmqConfig rabbitmqConfig = entity.getRabbitmqConfig();
        if (rabbitmqConfig != null) {
            form.setRabbitmqHost(rabbitmqConfig.getHost());
            form.setRabbitmqPort(rabbitmqConfig.getPort());
            form.setRabbitmqVhost(rabbitmqConfig.getVhost());
            form.setRabbitmqUsername(rabbitmqConfig.getUsername());
            form.setRabbitmqPassword(rabbitmqConfig.getPassword());
            form.setGlobalPropsRmqConf(Boolean.valueOf(rabbitmqConfig.getId() == 1L));
        }
        form.setGlobalPropsRmqConfAvailable(Boolean.valueOf(this.rabbitmqConfigService.get(Long.valueOf(1L)) != null));
        return form;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public ModelAndView edit() {
        return new ModelAndView("/root/duracloudmill/edit");
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView update(@ModelAttribute(value="duracloudMill") @Valid DuracloudMillForm form, BindingResult bindingResult, Model model, RedirectAttributes redirectAttributes) {
        boolean hasErrors = bindingResult.hasErrors();
        if (hasErrors) {
            return new ModelAndView("/root/duracloudmill/edit");
        }
        Long rabbitmqConfigId = null;
        if (form.getQueueType().equalsIgnoreCase(QueueType.RABBITMQ.toString())) {
            if (form.getGlobalPropsRmqConf().booleanValue()) {
                rabbitmqConfigId = 1L;
            } else {
                rabbitmqConfigId = 2L;
                this.rabbitmqConfigService.set(rabbitmqConfigId, form.getRabbitmqHost(), form.getRabbitmqPort(), form.getRabbitmqVhost(), form.getRabbitmqUsername(), form.getRabbitmqPassword());
            }
        }
        this.duracloudMillConfigService.set(form.getDbHost(), form.getDbPort(), form.getDbName(), form.getDbUsername(), form.getDbPassword(), form.getAuditQueue(), form.getAuditLogSpaceId(), form.getQueueType(), rabbitmqConfigId, form.getRabbitmqExchange());
        UserFeedbackUtil.addSuccessFlash((String)"Successfully updated!", (RedirectAttributes)redirectAttributes);
        return new ModelAndView((View)new RedirectView(BASE_MAPPING, true));
    }
}

