/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.app.controller;

import javax.validation.Valid;
import org.duracloud.account.app.controller.AbstractController;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

public abstract class AbstractCrudController<T>
extends AbstractController {
    private Class<T> clazz;

    protected abstract String getBaseViewId();

    public AbstractCrudController(Class<T> clazz) {
        this.clazz = clazz;
    }

    @ModelAttribute(value="form")
    public T form() {
        try {
            return this.clazz.newInstance();
        }
        catch (Exception e) {
            throw new DuraCloudRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getNewViewId() {
        return this.getBaseViewId() + "/new";
    }

    protected String getEditViewId() {
        return this.getBaseViewId() + "/edit";
    }

    @RequestMapping(value={""})
    public abstract ModelAndView get();

    @RequestMapping(value={"/new"})
    public ModelAndView getNew() {
        return new ModelAndView(this.getNewViewId());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView create(@ModelAttribute(value="form") @Valid T form, BindingResult bindingResult, Model model, RedirectAttributes redirectAttributes) {
        boolean hasErrors = bindingResult.hasErrors();
        if (hasErrors) {
            return new ModelAndView(this.getNewViewId());
        }
        this.create(form);
        this.log.info("created entity: {}", form);
        this.setSuccessFeedback(this.createSuccessMessage(), redirectAttributes);
        return new ModelAndView((View)new RedirectView(this.getBaseViewId(), true));
    }

    protected String createSuccessMessage() {
        return "Successfully created!";
    }

    protected abstract void create(T var1);

    @RequestMapping(value={"/byid/{id}/edit"}, method={RequestMethod.GET})
    @Transactional
    public ModelAndView edit(@PathVariable Long id) {
        Object form = this.getFormById(id);
        this.log.debug("retrieved form: id={} -> form={}", (Object)id, form);
        return new ModelAndView(this.getEditViewId(), "form", form);
    }

    protected T getFormById(Long id) {
        Object entity = this.getEntity(id);
        return (T)this.loadForm(entity);
    }

    protected abstract Object getEntity(Long var1);

    protected abstract T loadForm(Object var1);

    @RequestMapping(value={"/byid/{id}/edit"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView update(@PathVariable Long id, @ModelAttribute(value="form") @Valid T form, BindingResult bindingResult, Model model, RedirectAttributes redirectAttributes) {
        boolean hasErrors = bindingResult.hasErrors();
        if (hasErrors) {
            return new ModelAndView(this.getEditViewId());
        }
        this.update(id, form);
        this.log.info("updated form: id={} -> form={}", (Object)id, form);
        this.setSuccessFeedback(this.updateSuccessMessage(), redirectAttributes);
        return new ModelAndView((View)new RedirectView(this.getBaseViewId(), true));
    }

    protected String updateSuccessMessage() {
        return "Update successful!";
    }

    protected abstract void update(Long var1, T var2);

    @RequestMapping(value={"/byid/{id}/delete"}, method={RequestMethod.POST})
    @Transactional
    public ModelAndView delete(@PathVariable Long id, RedirectAttributes redirectAttributes) {
        this.delete(id);
        this.setSuccessFeedback(this.deleteSuccessMessage(), redirectAttributes);
        this.log.info("deleted object: id={}", (Object)id);
        return new ModelAndView((View)new RedirectView(this.getBaseViewId(), true));
    }

    protected String deleteSuccessMessage() {
        return "Successfully deleted!";
    }

    protected abstract void delete(Long var1);
}

