/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.appconfig.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.duracloud.appconfig.domain.AppConfig;
import org.duracloud.appconfig.domain.BaseConfig;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.storage.domain.AuditConfig;
import org.duracloud.storage.domain.DatabaseConfig;
import org.duracloud.storage.domain.DuraStoreInitConfig;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.domain.impl.StorageAccountImpl;
import org.duracloud.storage.xml.DuraStoreInitDocumentBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurastoreConfig
extends BaseConfig
implements AppConfig {
    private final Logger log = LoggerFactory.getLogger(DurastoreConfig.class);
    public static final String QUALIFIER = "durastore";
    protected static final String auditKey = "audit";
    protected static final String queueKey = "queue";
    protected static final String logSpaceIdKey = "log-space-id";
    protected static final String storageAccountKey = "storage-acct";
    protected static final String ownerIdKey = "owner-id";
    protected static final String isPrimaryKey = "is-primary";
    protected static final String idKey = "id";
    protected static final String providerTypeKey = "provider-type";
    protected static final String usernameKey = "username";
    protected static final String passwordKey = "password";
    protected static final String storageClassKey = "storage-class";
    protected static final String zoneKey = "zone";
    protected static final String portKey = "port";
    protected static final String hostKey = "host";
    protected static final String baseDirectoryKey = "base-directory";
    protected static final String resourceKey = "resource";
    protected static final String snapshotUserKey = "snapshot-user";
    protected static final String bridgeHostKey = "bridge-host";
    protected static final String bridgePortKey = "bridge-port";
    protected static final String bridgeUserKey = "bridge-user";
    protected static final String bridgePassKey = "bridge-pass";
    private DatabaseConfig millDbConfig = new DatabaseConfig();
    private AuditConfig auditConfig = new AuditConfig();
    private Map<String, StorageAccount> storageAccounts = new HashMap<String, StorageAccount>();
    private DuraStoreInitDocumentBinding documentBinding = new DuraStoreInitDocumentBinding();

    @Override
    protected String getQualifier() {
        return QUALIFIER;
    }

    @Override
    protected void loadProperty(String key, String value) {
        if ((key = key.toLowerCase()).startsWith(storageAccountKey)) {
            String suffix = this.getSuffix(key);
            this.loadStorageAcct(suffix, value);
        } else if (key.startsWith(auditKey)) {
            String suffix = this.getSuffix(key);
            this.loadAudit(suffix, value);
        } else if (key.startsWith("mill.db")) {
            String suffix = this.getSuffix(key);
            this.loadDbConfig(this.millDbConfig, suffix, value);
        } else {
            String msg = "unknown key: " + key + " (" + value + ")";
            this.log.error(msg);
            throw new DuraCloudRuntimeException(msg);
        }
    }

    private void loadAudit(String key, String value) {
        String suffix = this.getSuffix(key);
        if (suffix.equalsIgnoreCase(usernameKey)) {
            this.auditConfig.setAuditUsername(value);
        } else if (suffix.equalsIgnoreCase(passwordKey)) {
            this.auditConfig.setAuditPassword(value);
        } else if (suffix.equalsIgnoreCase(queueKey)) {
            this.auditConfig.setAuditQueueName(value);
        } else if (suffix.equalsIgnoreCase(logSpaceIdKey)) {
            this.auditConfig.setAuditLogSpaceId(value);
        }
    }

    private void loadStorageAcct(String key, String value) {
        String suffix;
        String id = this.getPrefix(key);
        StorageAccount acct = this.storageAccounts.get(id);
        if (null == acct) {
            acct = new StorageAccountImpl(null, null, null, null);
        }
        if ((suffix = this.getSuffix(key)).equalsIgnoreCase(idKey)) {
            acct.setId(value);
        } else if (suffix.equalsIgnoreCase(ownerIdKey)) {
            acct.setOwnerId(value);
        } else if (suffix.equalsIgnoreCase(isPrimaryKey)) {
            acct.setPrimary(Boolean.valueOf(value).booleanValue());
        } else if (suffix.equalsIgnoreCase(providerTypeKey)) {
            acct.setType(StorageProviderType.fromString((String)value));
        } else if (suffix.equalsIgnoreCase(usernameKey)) {
            acct.setUsername(value);
        } else if (suffix.equalsIgnoreCase(passwordKey)) {
            acct.setPassword(value);
        } else if (suffix.equalsIgnoreCase(storageClassKey)) {
            acct.setOption(StorageAccount.OPTS.STORAGE_CLASS.name(), value);
        } else if (suffix.equalsIgnoreCase(zoneKey)) {
            acct.setOption(StorageAccount.OPTS.ZONE.name(), value);
        } else if (suffix.equalsIgnoreCase(hostKey)) {
            acct.setOption(StorageAccount.OPTS.HOST.name(), value);
        } else if (suffix.equalsIgnoreCase(portKey)) {
            acct.setOption(StorageAccount.OPTS.PORT.name(), value);
        } else if (suffix.equalsIgnoreCase(baseDirectoryKey)) {
            acct.setOption(StorageAccount.OPTS.BASE_DIRECTORY.name(), value);
        } else if (suffix.equalsIgnoreCase(resourceKey)) {
            acct.setOption(StorageAccount.OPTS.RESOURCE.name(), value);
        } else if (suffix.equalsIgnoreCase(snapshotUserKey)) {
            acct.setOption(StorageAccount.OPTS.SNAPSHOT_USER.name(), value);
        } else if (suffix.equalsIgnoreCase(bridgeHostKey)) {
            acct.setOption(StorageAccount.OPTS.BRIDGE_HOST.name(), value);
        } else if (suffix.equalsIgnoreCase(bridgePortKey)) {
            acct.setOption(StorageAccount.OPTS.BRIDGE_PORT.name(), value);
        } else if (suffix.equalsIgnoreCase(bridgeUserKey)) {
            acct.setOption(StorageAccount.OPTS.BRIDGE_USER.name(), value);
        } else if (suffix.equalsIgnoreCase(bridgePassKey)) {
            acct.setOption(StorageAccount.OPTS.BRIDGE_PASS.name(), value);
        } else {
            String msg = "unknown acct key: " + key + " (" + value + ")";
            this.log.error(msg);
            throw new DuraCloudRuntimeException(msg);
        }
        this.storageAccounts.put(id, acct);
    }

    public AuditConfig getAuditConfig() {
        return this.auditConfig;
    }

    public Collection<StorageAccount> getStorageAccounts() {
        return this.storageAccounts.values();
    }

    public void setStorageAccounts(Set<StorageAccount> storageAccts) {
        this.storageAccounts = new HashMap<String, StorageAccount>();
        for (StorageAccount storageAcct : storageAccts) {
            this.storageAccounts.put(storageAcct.getId(), storageAcct);
        }
    }

    @Override
    public String asXml() {
        boolean includeCredentials = true;
        boolean includeOptions = true;
        DuraStoreInitConfig initConfig = new DuraStoreInitConfig();
        initConfig.setAuditConfig(this.getAuditConfig());
        initConfig.setMillDbConfig(this.getMillDbConfig());
        ArrayList<StorageAccount> accounts = new ArrayList<StorageAccount>(this.getStorageAccounts());
        initConfig.setStorageAccounts(accounts);
        return this.documentBinding.createXmlFrom(initConfig, includeCredentials, includeOptions);
    }

    private DatabaseConfig getMillDbConfig() {
        return this.millDbConfig;
    }

    @Override
    public String getInitResource() {
        return "/init";
    }
}

